/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop.command;

import com.skyblockexp.ezshops.common.EconomyUtils;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.ezshops.shop.ShopPrice;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopTransactionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class PriceCommand
implements CommandExecutor,
TabCompleter {
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final ShopMessageConfiguration.CommandMessages.PriceCommandMessages messages;

    public PriceCommand(ShopPricingManager pricingManager, ShopTransactionService transactionService, ShopMessageConfiguration.CommandMessages.PriceCommandMessages messages) {
        this.pricingManager = pricingManager;
        this.transactionService = transactionService;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1 || args[0].trim().isEmpty()) {
            sender.sendMessage(this.messages.usage(label));
            return true;
        }
        String materialName = args[0];
        Material material = Material.matchMaterial((String)materialName, (boolean)false);
        if (material == null) {
            sender.sendMessage(this.messages.unknownItem(materialName));
            return true;
        }
        Optional<ShopPrice> priceLookup = this.pricingManager.getPrice(material);
        if (priceLookup.isEmpty()) {
            sender.sendMessage(this.messages.notConfigured());
            return true;
        }
        ShopPrice price = priceLookup.get();
        String displayName = ShopTransactionService.friendlyMaterialName(material);
        sender.sendMessage(this.messages.header(displayName));
        sender.sendMessage(this.resolveBuyLine(price));
        sender.sendMessage(this.resolveSellLine(price));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        String current = args[0].toLowerCase(Locale.ENGLISH);
        Set<Material> materials = this.pricingManager.getConfiguredMaterials();
        ArrayList<String> completions = new ArrayList<String>();
        for (Material material : materials) {
            String name = material.name().toLowerCase(Locale.ENGLISH);
            if (!current.isEmpty() && !name.startsWith(current)) continue;
            completions.add(name);
        }
        return completions;
    }

    private String resolveBuyLine(ShopPrice price) {
        double normalized = EconomyUtils.normalizeCurrency(price.buyPrice());
        if (!price.canBuy() || normalized <= 0.0) {
            return this.messages.buyUnavailable();
        }
        return this.messages.buyLine(this.transactionService.formatCurrency(normalized));
    }

    private String resolveSellLine(ShopPrice price) {
        double normalized = EconomyUtils.normalizeCurrency(price.sellPrice());
        if (!price.canSell() || normalized <= 0.0) {
            return this.messages.sellUnavailable();
        }
        return this.messages.sellLine(this.transactionService.formatCurrency(normalized));
    }
}

