/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop;

import com.skyblockexp.ezshops.common.EconomyUtils;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.ezshops.shop.ShopMenuLayout;
import com.skyblockexp.ezshops.shop.ShopPrice;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopTransactionResult;
import java.lang.invoke.CallSite;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopTransactionService {
    public static final String PERMISSION_BUY = "ezshops.shop.buy";
    public static final String PERMISSION_SELL = "ezshops.shop.sell";
    public static final String PERMISSION_ADMIN_MINION_HEAD = "ezshops.shop.admin.minionhead";
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance(Locale.US);
    private final ShopPricingManager pricingManager;
    private final Economy economy;
    private final ShopMessageConfiguration.TransactionMessages.ErrorMessages errorMessages;
    private final ShopMessageConfiguration.TransactionMessages.SuccessMessages successMessages;
    private final ShopMessageConfiguration.TransactionMessages.NotificationMessages notificationMessages;
    private final ShopMessageConfiguration.TransactionMessages.CustomItemMessages customItemMessages;
    private final Map<EntityType, ItemStack> spawnerCache = new EnumMap<EntityType, ItemStack>(EntityType.class);

    public ShopTransactionService(ShopPricingManager pricingManager, Economy economy, ShopMessageConfiguration.TransactionMessages transactionMessages) {
        this.pricingManager = pricingManager;
        this.economy = economy;
        this.errorMessages = transactionMessages.errors();
        this.successMessages = transactionMessages.success();
        this.notificationMessages = transactionMessages.notifications();
        this.customItemMessages = transactionMessages.customItems();
    }

    public ShopTransactionResult buy(Player player, Material material, int amount) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_BUY)) {
            return ShopTransactionResult.failure(this.errorMessages.noBuyPermission());
        }
        if (amount <= 0) {
            return ShopTransactionResult.failure(this.errorMessages.amountPositive());
        }
        ShopPrice price = this.pricingManager.getPrice(material).orElse(null);
        if (price == null) {
            return ShopTransactionResult.failure(this.errorMessages.notConfigured());
        }
        if (!price.canBuy()) {
            return ShopTransactionResult.failure(this.errorMessages.notBuyable());
        }
        double totalCost = EconomyUtils.normalizeCurrency(price.buyPrice() * (double)amount);
        if (totalCost <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidBuyPrice());
        }
        if (!this.hasInventorySpace(player, material, amount)) {
            return ShopTransactionResult.failure(this.errorMessages.noInventorySpace());
        }
        if (this.economy.getBalance((OfflinePlayer)player) < totalCost) {
            return ShopTransactionResult.failure(this.errorMessages.cannotAfford());
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, totalCost);
        if (!response.transactionSuccess()) {
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        List<ItemStack> leftovers = this.giveItems(player, material, amount);
        this.handleLeftoverItems(player, leftovers);
        this.pricingManager.handlePurchase(material, amount);
        return ShopTransactionResult.success(this.successMessages.purchase(amount, String.valueOf(ChatColor.AQUA) + ShopTransactionService.friendlyMaterialName(material), this.formatCurrency(totalCost)));
    }

    public ShopTransactionResult sell(Player player, Material material, int amount) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_SELL)) {
            return ShopTransactionResult.failure(this.errorMessages.noSellPermission());
        }
        if (amount <= 0) {
            return ShopTransactionResult.failure(this.errorMessages.amountPositive());
        }
        ShopPrice price = this.pricingManager.getPrice(material).orElse(null);
        if (price == null) {
            return ShopTransactionResult.failure(this.errorMessages.notConfigured());
        }
        if (!price.canSell()) {
            return ShopTransactionResult.failure(this.errorMessages.notSellable());
        }
        double totalGain = EconomyUtils.normalizeCurrency(price.sellPrice() * (double)amount);
        if (totalGain <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidSellPrice());
        }
        int sellableAmount = this.countMaterial(player, material);
        if (sellableAmount < amount) {
            return ShopTransactionResult.failure(this.errorMessages.insufficientItems());
        }
        this.removeItems(player, material, amount);
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, totalGain);
        if (!response.transactionSuccess()) {
            List<ItemStack> leftovers = this.giveItems(player, material, amount);
            this.handleLeftoverItems(player, leftovers);
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        this.pricingManager.handleSale(material, amount);
        return ShopTransactionResult.success(this.successMessages.sale(amount, String.valueOf(ChatColor.AQUA) + ShopTransactionService.friendlyMaterialName(material), this.formatCurrency(totalGain)));
    }

    public ShopTransactionResult sellInventory(Player player) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_SELL)) {
            return ShopTransactionResult.failure(this.errorMessages.noSellPermission());
        }
        PlayerInventory inventory = player.getInventory();
        EnumMap<Material, Integer> soldAmounts = new EnumMap<Material, Integer>(Material.class);
        double totalGain = 0.0;
        ItemStack[] itemStackArray = inventory.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            int amount;
            double unitPrice;
            Material material;
            ShopPrice price;
            ItemStack stack = itemStackArray[n2];
            if (stack != null && stack.getType() != Material.AIR && (price = (ShopPrice)this.pricingManager.getPrice(material = stack.getType()).orElse(null)) != null && price.canSell() && !((unitPrice = price.sellPrice()) <= 0.0) && (amount = stack.getAmount()) > 0) {
                soldAmounts.merge(material, amount, Integer::sum);
                totalGain += unitPrice * (double)amount;
            }
            ++n2;
        }
        if (soldAmounts.isEmpty()) {
            return ShopTransactionResult.failure(this.errorMessages.noSellableItems());
        }
        if ((totalGain = EconomyUtils.normalizeCurrency(totalGain)) <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.noSellablePrices());
        }
        for (Map.Entry entry : soldAmounts.entrySet()) {
            this.removeItems(player, (Material)entry.getKey(), (Integer)entry.getValue());
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, totalGain);
        if (!response.transactionSuccess()) {
            ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
            for (Map.Entry entry : soldAmounts.entrySet()) {
                leftovers.addAll(this.giveItems(player, (Material)entry.getKey(), (int)((Integer)entry.getValue())));
            }
            this.handleLeftoverItems(player, leftovers);
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        for (Map.Entry entry : soldAmounts.entrySet()) {
            this.pricingManager.handleSale((Material)entry.getKey(), (Integer)entry.getValue());
        }
        String soldItems = this.formatSoldInventorySummary(soldAmounts);
        return ShopTransactionResult.success(this.successMessages.sellInventory(soldItems, this.formatCurrency(totalGain)));
    }

    public ShopTransactionResult buyMinionCrateKey(Player player, double unitPrice, int quantity) {
        return this.purchaseCustomItem(player, unitPrice, quantity, Material.TRIPWIRE_HOOK, this.customItemMessages.minionCrateName(), this.customItemMessages.minionCrateLore());
    }

    public ShopTransactionResult buyVoteCrateKey(Player player, double unitPrice, int quantity) {
        return this.purchaseCustomItem(player, unitPrice, quantity, Material.TRIPWIRE_HOOK, this.customItemMessages.voteCrateName(), this.customItemMessages.voteCrateLore());
    }

    public ShopTransactionResult buySpawner(Player player, EntityType entityType, double unitPrice, int quantity) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_BUY)) {
            return ShopTransactionResult.failure(this.errorMessages.noBuyPermission());
        }
        if (entityType == null) {
            return ShopTransactionResult.failure(this.errorMessages.invalidSpawner());
        }
        if (quantity <= 0) {
            return ShopTransactionResult.failure(this.errorMessages.amountPositive());
        }
        double totalCost = EconomyUtils.normalizeCurrency(unitPrice * (double)quantity);
        if (totalCost <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidCustomPrice());
        }
        if (this.economy.getBalance((OfflinePlayer)player) < totalCost) {
            return ShopTransactionResult.failure(this.errorMessages.cannotAfford());
        }
        ItemStack template = this.spawnerCache.computeIfAbsent(entityType, this::createSpawnerItem);
        IntFunction<ItemStack> spawnerFactory = count -> {
            ItemStack stack = template.clone();
            stack.setAmount(count);
            return stack;
        };
        if (!this.hasInventorySpace(player, spawnerFactory, quantity)) {
            return ShopTransactionResult.failure(this.errorMessages.noInventorySpace());
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, totalCost);
        if (!response.transactionSuccess()) {
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        List<ItemStack> leftovers = this.giveSpawner(player, spawnerFactory, quantity);
        this.handleLeftoverItems(player, leftovers);
        String friendlyName = this.friendlyEntityName(entityType);
        return ShopTransactionResult.success(this.successMessages.spawnerPurchase(quantity, String.valueOf(ChatColor.AQUA) + friendlyName, this.formatCurrency(totalCost)));
    }

    public ShopTransactionResult buyEnchantedBook(Player player, ShopMenuLayout.Item item, int quantity) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_BUY)) {
            return ShopTransactionResult.failure(this.errorMessages.noBuyPermission());
        }
        if (item == null) {
            return ShopTransactionResult.failure(this.errorMessages.notConfigured());
        }
        if (item.material() != Material.ENCHANTED_BOOK) {
            return ShopTransactionResult.failure(this.errorMessages.notConfigured());
        }
        if (quantity <= 0) {
            return ShopTransactionResult.failure(this.errorMessages.amountPositive());
        }
        Map<Enchantment, Integer> enchantments = item.enchantments();
        if (enchantments == null || enchantments.isEmpty()) {
            return ShopTransactionResult.failure(this.errorMessages.notConfigured());
        }
        ShopPrice price = item.price();
        if (price == null || !price.canBuy()) {
            return ShopTransactionResult.failure(this.errorMessages.notBuyable());
        }
        double unitPrice = price.buyPrice();
        if (unitPrice <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidCustomPrice());
        }
        double totalCost = EconomyUtils.normalizeCurrency(unitPrice * (double)quantity);
        if (totalCost <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidCustomPrice());
        }
        String bookName = this.formatEnchantedBookName(enchantments);
        String displayName = bookName.isEmpty() ? null : String.valueOf(ChatColor.LIGHT_PURPLE) + bookName;
        IntFunction<ItemStack> bookFactory = count -> {
            ItemStack book = this.createEnchantedBook(enchantments, displayName);
            book.setAmount(Math.max(1, Math.min(book.getMaxStackSize(), count)));
            return book;
        };
        if (!this.hasInventorySpace(player, bookFactory, quantity)) {
            return ShopTransactionResult.failure(this.errorMessages.noInventorySpace());
        }
        if (this.economy.getBalance((OfflinePlayer)player) < totalCost) {
            return ShopTransactionResult.failure(this.errorMessages.cannotAfford());
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, totalCost);
        if (!response.transactionSuccess()) {
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        List<ItemStack> leftovers = this.giveItems(player, bookFactory, quantity);
        this.handleLeftoverItems(player, leftovers);
        String friendlyName = bookName.isEmpty() ? ShopTransactionService.friendlyMaterialName(item.material()) : bookName;
        return ShopTransactionResult.success(this.successMessages.purchase(quantity, String.valueOf(ChatColor.AQUA) + friendlyName, this.formatCurrency(totalCost)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatCurrency(double amount) {
        if (this.economy != null) {
            return this.economy.format(amount);
        }
        NumberFormat numberFormat = CURRENCY_FORMAT;
        synchronized (numberFormat) {
            return CURRENCY_FORMAT.format(amount);
        }
    }

    public static String friendlyMaterialName(Material material) {
        String name = material.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = name.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return name;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private ShopTransactionResult purchaseCustomItem(Player player, double unitPrice, int quantity, Material material, String displayName, String loreLine) {
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.errorMessages.noEconomy());
        }
        if (!player.hasPermission(PERMISSION_BUY)) {
            return ShopTransactionResult.failure(this.errorMessages.noBuyPermission());
        }
        if (quantity <= 0) {
            return ShopTransactionResult.failure(this.errorMessages.amountPositive());
        }
        double totalCost = EconomyUtils.normalizeCurrency(unitPrice * (double)quantity);
        if (totalCost <= 0.0) {
            return ShopTransactionResult.failure(this.errorMessages.invalidCustomPrice());
        }
        IntFunction<ItemStack> itemFactory = count -> {
            ItemStack custom = this.createCustomItem(material, displayName, loreLine);
            custom.setAmount(count);
            return custom;
        };
        if (!this.hasInventorySpace(player, itemFactory, quantity)) {
            return ShopTransactionResult.failure(this.errorMessages.noInventorySpace());
        }
        if (this.economy.getBalance((OfflinePlayer)player) < totalCost) {
            return ShopTransactionResult.failure(this.errorMessages.cannotAfford());
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, totalCost);
        if (!response.transactionSuccess()) {
            return ShopTransactionResult.failure(this.errorMessages.transactionFailed(response.errorMessage));
        }
        List<ItemStack> leftovers = this.giveItems(player, itemFactory, quantity);
        this.handleLeftoverItems(player, leftovers);
        return ShopTransactionResult.success(this.successMessages.purchase(quantity, displayName, this.formatCurrency(totalCost)));
    }

    private ItemStack createCustomItem(Material material, String displayName, String loreLine) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (displayName != null) {
                meta.setDisplayName(displayName);
            }
            if (loreLine != null && !loreLine.isEmpty()) {
                meta.setLore(List.of(loreLine));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private boolean hasInventorySpace(Player player, Material material, int amount) {
        return this.hasInventorySpace(player, (int count) -> new ItemStack(material, count), amount);
    }

    private boolean hasInventorySpace(Player player, IntFunction<ItemStack> itemFactory, int quantity) {
        if (quantity <= 0) {
            return true;
        }
        Inventory snapshot = this.cloneStorageInventory(player);
        int remaining = quantity;
        while (remaining > 0) {
            ItemStack stack = itemFactory.apply(remaining);
            if (stack == null || stack.getType() == Material.AIR) {
                return true;
            }
            int stackSize = Math.min(stack.getMaxStackSize(), remaining);
            stack.setAmount(stackSize);
            HashMap leftovers = snapshot.addItem(new ItemStack[]{stack});
            if (!leftovers.isEmpty()) {
                return false;
            }
            remaining -= stackSize;
        }
        return true;
    }

    private int countMaterial(Player player, Material material) {
        int total = 0;
        ItemStack[] itemStackArray = player.getInventory().getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack stack = itemStackArray[n2];
            if (stack != null && stack.getType() == material) {
                total += stack.getAmount();
            }
            ++n2;
        }
        return total;
    }

    private void removeItems(Player player, Material material, int amount) {
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getStorageContents();
        int remaining = amount;
        int i = 0;
        while (i < contents.length && remaining > 0) {
            ItemStack stack = contents[i];
            if (stack != null && stack.getType() == material) {
                int toRemove = Math.min(stack.getAmount(), remaining);
                remaining -= toRemove;
                int newAmount = stack.getAmount() - toRemove;
                if (newAmount <= 0) {
                    contents[i] = null;
                } else {
                    stack.setAmount(newAmount);
                    contents[i] = stack;
                }
            }
            ++i;
        }
        inventory.setStorageContents(contents);
    }

    private List<ItemStack> giveItems(Player player, Material material, int amount) {
        return this.giveItems(player, (int count) -> new ItemStack(material, count), amount);
    }

    private List<ItemStack> giveItems(Player player, IntFunction<ItemStack> itemFactory, int quantity) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        if (quantity <= 0) {
            return leftovers;
        }
        PlayerInventory inventory = player.getInventory();
        int remaining = quantity;
        while (remaining > 0) {
            ItemStack stack = itemFactory.apply(remaining);
            if (stack == null || stack.getType() == Material.AIR) break;
            int stackSize = Math.min(stack.getMaxStackSize(), remaining);
            stack.setAmount(stackSize);
            HashMap result = inventory.addItem(new ItemStack[]{stack});
            if (!result.isEmpty()) {
                leftovers.addAll(result.values());
            }
            remaining -= stackSize;
        }
        return leftovers;
    }

    private List<ItemStack> giveSpawner(Player player, IntFunction<ItemStack> spawnerFactory, int quantity) {
        return this.giveItems(player, spawnerFactory, quantity);
    }

    private String formatSoldInventorySummary(Map<Material, Integer> soldAmounts) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Map.Entry<Material, Integer> entry : soldAmounts.entrySet()) {
            parts.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + String.valueOf(entry.getValue()) + String.valueOf(ChatColor.GREEN) + "x " + String.valueOf(ChatColor.AQUA) + ShopTransactionService.friendlyMaterialName(entry.getKey()))));
        }
        return String.join((CharSequence)(String.valueOf(ChatColor.GREEN) + ", "), parts);
    }

    private void handleLeftoverItems(Player player, List<ItemStack> leftovers) {
        if (leftovers == null || leftovers.isEmpty()) {
            return;
        }
        for (ItemStack leftover : leftovers) {
            if (leftover == null || leftover.getType() == Material.AIR) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), leftover.clone());
        }
        player.sendMessage(this.notificationMessages.inventoryLeftovers());
    }

    private Inventory cloneStorageInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getStorageContents();
        Inventory snapshot = Bukkit.createInventory(null, (int)contents.length);
        int i = 0;
        while (i < contents.length) {
            ItemStack item = contents[i];
            snapshot.setItem(i, item == null ? null : item.clone());
            ++i;
        }
        return snapshot;
    }

    private ItemStack createEnchantedBook(Map<Enchantment, Integer> enchantments, String displayName) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = book.getItemMeta();
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                storageMeta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), true);
            }
            if (displayName != null && !displayName.isEmpty()) {
                storageMeta.setDisplayName(displayName);
            }
            book.setItemMeta((ItemMeta)storageMeta);
            return book;
        }
        if (meta != null) {
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
            }
            if (displayName != null && !displayName.isEmpty()) {
                meta.setDisplayName(displayName);
            }
            book.setItemMeta(meta);
        }
        return book;
    }

    private String formatEnchantedBookName(Map<Enchantment, Integer> enchantments) {
        if (enchantments == null || enchantments.isEmpty()) {
            return "";
        }
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            String name = this.friendlyEnchantmentName(entry.getKey());
            String level = this.toRomanNumeral(Math.max(1, entry.getValue()));
            parts.add((CallSite)((Object)(name + " " + level)));
        }
        return String.join((CharSequence)", ", parts) + " Book";
    }

    private String friendlyEnchantmentName(Enchantment enchantment) {
        if (enchantment == null) {
            return "";
        }
        String key = enchantment.getKey().getKey().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = key.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return key;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String toRomanNumeral(int number) {
        if (number <= 0) {
            return Integer.toString(number);
        }
        values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        remaining = number;
        builder = new StringBuilder();
        i = 0;
        ** GOTO lbl15
        {
            builder.append(numerals[i]);
            remaining -= values[i];
            do {
                if (remaining >= values[i]) continue block0;
                ++i;
lbl15:
                // 2 sources

            } while (i < values.length && remaining > 0);
        }
        return builder.toString();
    }

    private ItemStack createSpawnerItem(EntityType entityType) {
        ItemStack item = new ItemStack(Material.SPAWNER);
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            BlockState blockState = blockStateMeta.getBlockState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                spawner.setSpawnedType(entityType);
                blockStateMeta.setBlockState((BlockState)spawner);
            }
            blockStateMeta.setDisplayName(this.customItemMessages.spawnerDisplayName(this.friendlyEntityName(entityType)));
            item.setItemMeta((ItemMeta)blockStateMeta);
        }
        return item;
    }

    private String friendlyEntityName(EntityType entityType) {
        if (entityType == null) {
            return "";
        }
        String name = entityType.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = name.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return name;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }
}

