/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop;

import com.skyblockexp.ezshops.shop.ShopRotationMode;
import com.skyblockexp.ezshops.shop.ShopRotationOption;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ShopRotationDefinition {
    private final String id;
    private final Duration interval;
    private final ShopRotationMode mode;
    private final List<ShopRotationOption> options;
    private final Map<String, ShopRotationOption> optionLookup;
    private final String defaultOptionId;

    public ShopRotationDefinition(String id, Duration interval, ShopRotationMode mode, List<ShopRotationOption> options, String defaultOptionId) {
        this.id = Objects.requireNonNull(id, "id");
        this.interval = interval;
        ShopRotationMode shopRotationMode = this.mode = mode == null ? ShopRotationMode.SEQUENTIAL : mode;
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("Rotation definitions require at least one option.");
        }
        this.options = List.copyOf(options);
        LinkedHashMap<String, ShopRotationOption> lookup = new LinkedHashMap<String, ShopRotationOption>();
        for (ShopRotationOption option : options) {
            lookup.put(option.id(), option);
        }
        this.optionLookup = Collections.unmodifiableMap(lookup);
        String resolvedDefault = defaultOptionId;
        if (resolvedDefault == null || !lookup.containsKey(resolvedDefault)) {
            resolvedDefault = options.get(0).id();
        }
        this.defaultOptionId = resolvedDefault;
    }

    public String id() {
        return this.id;
    }

    public Duration interval() {
        return this.interval;
    }

    public ShopRotationMode mode() {
        return this.mode;
    }

    public List<ShopRotationOption> options() {
        return this.options;
    }

    public Optional<ShopRotationOption> option(String optionId) {
        if (optionId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.optionLookup.get(optionId));
    }

    public boolean containsOption(String optionId) {
        return this.optionLookup.containsKey(optionId);
    }

    public String defaultOptionId() {
        return this.defaultOptionId;
    }
}

