/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop;

import com.skyblockexp.ezshops.shop.ShopPrice;
import com.skyblockexp.ezshops.shop.ShopPriceType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;

public final class ShopMenuLayout {
    private final String mainTitle;
    private final int mainSize;
    private final ItemDecoration mainFill;
    private final ItemDecoration defaultBackButton;
    private final int defaultBackButtonSlot;
    private final List<Category> categories;

    public ShopMenuLayout(String mainTitle, int mainSize, ItemDecoration mainFill, ItemDecoration defaultBackButton, int defaultBackButtonSlot, List<Category> categories) {
        this.mainTitle = Objects.requireNonNull(mainTitle, "mainTitle");
        this.mainSize = mainSize;
        this.mainFill = mainFill;
        this.defaultBackButton = defaultBackButton;
        this.defaultBackButtonSlot = defaultBackButtonSlot;
        this.categories = List.copyOf(categories);
    }

    public static ShopMenuLayout empty() {
        return new ShopMenuLayout("Skyblock Shop", 27, null, null, 0, List.of());
    }

    public String mainTitle() {
        return this.mainTitle;
    }

    public int mainSize() {
        return this.mainSize;
    }

    public ItemDecoration mainFill() {
        return this.mainFill;
    }

    public ItemDecoration defaultBackButton() {
        return this.defaultBackButton;
    }

    public int defaultBackButtonSlot() {
        return this.defaultBackButtonSlot;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public static final class Category {
        private final String id;
        private final String displayName;
        private final ItemDecoration icon;
        private final int slot;
        private final String menuTitle;
        private final int menuSize;
        private final ItemDecoration menuFill;
        private final ItemDecoration backButton;
        private final Integer backButtonSlot;
        private final List<Item> items;
        private final CategoryRotation rotation;
        private final String command;

        public Category(String id, String displayName, ItemDecoration icon, int slot, String menuTitle, int menuSize, ItemDecoration menuFill, ItemDecoration backButton, Integer backButtonSlot, List<Item> items, CategoryRotation rotation, String command) {
            this.id = Objects.requireNonNull(id, "id");
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.icon = icon;
            this.slot = slot;
            this.menuTitle = Objects.requireNonNull(menuTitle, "menuTitle");
            this.menuSize = menuSize;
            this.menuFill = menuFill;
            this.backButton = backButton;
            this.backButtonSlot = backButtonSlot;
            this.items = List.copyOf(items);
            this.rotation = rotation;
            this.command = command;
        }

        public String id() {
            return this.id;
        }

        public String displayName() {
            return this.displayName;
        }

        public ItemDecoration icon() {
            return this.icon;
        }

        public int slot() {
            return this.slot;
        }

        public String menuTitle() {
            return this.menuTitle;
        }

        public int menuSize() {
            return this.menuSize;
        }

        public ItemDecoration menuFill() {
            return this.menuFill;
        }

        public ItemDecoration backButton() {
            return this.backButton;
        }

        public Integer backButtonSlot() {
            return this.backButtonSlot;
        }

        public List<Item> items() {
            return this.items;
        }

        public CategoryRotation rotation() {
            return this.rotation;
        }

        public String command() {
            return this.command;
        }
    }

    public static final class CategoryRotation {
        private final String groupId;
        private final String optionId;

        public CategoryRotation(String groupId, String optionId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.optionId = Objects.requireNonNull(optionId, "optionId");
        }

        public String groupId() {
            return this.groupId;
        }

        public String optionId() {
            return this.optionId;
        }
    }

    public static final class Item {
        private final String id;
        private final Material material;
        private final ItemDecoration display;
        private final int slot;
        private final int amount;
        private final int bulkAmount;
        private final ShopPrice price;
        private final ItemType type;
        private final EntityType spawnerEntity;
        private final Map<Enchantment, Integer> enchantments;
        private final int requiredIslandLevel;
        private final ShopPriceType priceType;

        public Item(String id, Material material, ItemDecoration display, int slot, int amount, int bulkAmount, ShopPrice price, ItemType type, EntityType spawnerEntity, Map<Enchantment, Integer> enchantments, int requiredIslandLevel) {
            this(id, material, display, slot, amount, bulkAmount, price, type, spawnerEntity, enchantments, requiredIslandLevel, ShopPriceType.STATIC);
        }

        public Item(String id, Material material, ItemDecoration display, int slot, int amount, int bulkAmount, ShopPrice price, ItemType type, EntityType spawnerEntity, Map<Enchantment, Integer> enchantments, int requiredIslandLevel, ShopPriceType priceType) {
            this.id = Objects.requireNonNull(id, "id");
            this.material = Objects.requireNonNull(material, "material");
            this.display = Objects.requireNonNull(display, "display");
            this.slot = slot;
            this.amount = amount;
            this.bulkAmount = bulkAmount;
            this.price = Objects.requireNonNull(price, "price");
            this.type = type == null ? ItemType.MATERIAL : type;
            this.spawnerEntity = spawnerEntity;
            this.enchantments = enchantments == null ? Map.of() : Map.copyOf(enchantments);
            this.requiredIslandLevel = Math.max(0, requiredIslandLevel);
            this.priceType = priceType == null ? ShopPriceType.STATIC : priceType;
        }

        public ShopPriceType priceType() {
            return this.priceType;
        }

        public String id() {
            return this.id;
        }

        public Material material() {
            return this.material;
        }

        public ItemDecoration display() {
            return this.display;
        }

        public int slot() {
            return this.slot;
        }

        public int amount() {
            return this.amount;
        }

        public int bulkAmount() {
            return this.bulkAmount;
        }

        public ShopPrice price() {
            return this.price;
        }

        public ItemType type() {
            return this.type;
        }

        public EntityType spawnerEntity() {
            return this.spawnerEntity;
        }

        public Map<Enchantment, Integer> enchantments() {
            return this.enchantments;
        }

        public int requiredIslandLevel() {
            return this.requiredIslandLevel;
        }
    }

    public static final class ItemDecoration {
        private final Material material;
        private final int amount;
        private final String displayName;
        private final List<String> lore;

        public ItemDecoration(Material material, int amount, String displayName, List<String> lore) {
            this.material = material;
            this.amount = amount;
            this.displayName = displayName;
            this.lore = lore == null ? List.of() : List.copyOf(lore);
        }

        public Material material() {
            return this.material;
        }

        public int amount() {
            return this.amount;
        }

        public String displayName() {
            return this.displayName;
        }

        public List<String> lore() {
            return this.lore;
        }
    }

    public static enum ItemType {
        MATERIAL,
        MINION_HEAD,
        MINION_CRATE_KEY,
        VOTE_CRATE_KEY,
        SPAWNER,
        ENCHANTED_BOOK;


        public static ItemType fromConfig(String value) {
            String normalized;
            if (value == null || value.isEmpty()) {
                return MATERIAL;
            }
            return switch (normalized = value.trim().toUpperCase(Locale.ROOT)) {
                case "MINION_BLUEPRINT", "MINION_HEAD" -> MINION_HEAD;
                case "MINION_CRATE_KEY", "MINION_HEAD_CRATE", "MINION_BLUEPRINT_CRATE" -> MINION_CRATE_KEY;
                case "VOTE_KEY", "VOTE_CRATE", "VOTE_CRATE_KEY" -> VOTE_CRATE_KEY;
                case "ENCHANTMENT_BOOK", "ENCHANT_BOOK", "ENCHANTED_BOOK" -> ENCHANTED_BOOK;
                default -> {
                    ItemType[] var6_3 = ItemType.values();
                    int var5_4 = var6_3.length;
                    int var4_5 = 0;
                    while (var4_5 < var5_4) {
                        ItemType type = var6_3[var4_5];
                        if (type.name().equals(normalized)) {
                            yield type;
                        }
                        ++var4_5;
                    }
                    yield MATERIAL;
                }
            };
        }
    }
}

