/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.repository.yml;

import com.skyblockexp.ezshops.repository.StockMarketRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class YmlStockMarketRepository
implements StockMarketRepository {
    private final File file;
    private final Map<String, StockMarketRepository.FrozenMeta> frozen;
    private final File pricesFile;

    public YmlStockMarketRepository(File dataFolder) {
        this.file = new File(dataFolder, "stock-frozen.yml");
        this.frozen = new HashMap<String, StockMarketRepository.FrozenMeta>();
        this.pricesFile = new File(dataFolder, "stock-prices.yml");
    }

    @Override
    public synchronized Map<String, Double> loadPrices() {
        HashMap<String, Double> prices = new HashMap<String, Double>();
        if (!this.pricesFile.exists()) {
            return prices;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.pricesFile);
        for (String key : yaml.getKeys(false)) {
            prices.put(key, yaml.getDouble(key));
        }
        return prices;
    }

    @Override
    public synchronized void savePrices(Map<String, Double> prices) {
        YamlConfiguration yaml = new YamlConfiguration();
        for (Map.Entry<String, Double> entry : prices.entrySet()) {
            yaml.set(entry.getKey(), (Object)entry.getValue());
        }
        try {
            yaml.save(this.pricesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void load() {
        this.frozen.clear();
        if (!this.file.exists()) {
            return;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.file);
        List list = yaml.getMapList("frozen");
        for (Map entry : list) {
            long when;
            String id = Objects.toString(entry.get("id"), null);
            String by = Objects.toString(entry.get("by"), "?");
            Object v = entry.get("when");
            if (v instanceof Number) {
                Number n = (Number)v;
                v0 = n.longValue();
            } else {
                v0 = when = 0L;
            }
            if (id == null) continue;
            this.frozen.put(id.toUpperCase(), new StockMarketRepository.FrozenMeta(id, by, when));
        }
    }

    @Override
    public synchronized void save() {
        YamlConfiguration yaml = new YamlConfiguration();
        ArrayList list = new ArrayList();
        for (StockMarketRepository.FrozenMeta meta : this.frozen.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", meta.id);
            map.put("by", meta.by);
            map.put("when", meta.when);
            list.add(map);
        }
        yaml.set("frozen", list);
        try {
            yaml.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void freeze(String id, String by) {
        this.frozen.put(id.toUpperCase(), new StockMarketRepository.FrozenMeta(id.toUpperCase(), by, System.currentTimeMillis()));
        this.save();
    }

    @Override
    public synchronized void unfreeze(String id) {
        this.frozen.remove(id.toUpperCase());
        this.save();
    }

    @Override
    public synchronized boolean isFrozen(String id) {
        return this.frozen.containsKey(id.toUpperCase());
    }

    @Override
    public synchronized Collection<StockMarketRepository.FrozenMeta> getAllFrozenMeta() {
        return Collections.unmodifiableCollection(this.frozen.values());
    }

    @Override
    public synchronized Set<String> getAllFrozen() {
        return Collections.unmodifiableSet(new HashSet<String>(this.frozen.keySet()));
    }
}

