/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.repository.yml;

import com.skyblockexp.ezshops.playershop.PlayerShop;
import com.skyblockexp.ezshops.repository.PlayerShopRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class YmlPlayerShopRepository
implements PlayerShopRepository {
    private final File dataFile;
    private final Logger logger;
    private final Map<String, Map<String, Object>> deferredEntries;

    public YmlPlayerShopRepository(File dataFolder, Logger logger) {
        this.dataFile = new File(dataFolder, "player-shops.yml");
        this.logger = logger;
        this.deferredEntries = new HashMap<String, Map<String, Object>>();
    }

    @Override
    public Collection<PlayerShop> loadShops() {
        this.deferredEntries.clear();
        ArrayList<PlayerShop> shops = new ArrayList<PlayerShop>();
        try {
            this.ensureDataFile();
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Failed to prepare player shop data file", ex);
            return shops;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.dataFile);
        ConfigurationSection section = configuration.getConfigurationSection("shops");
        if (section == null) {
            return shops;
        }
        for (String key : section.getKeys(false)) {
            Block signBlock;
            ConfigurationSection shopSection = section.getConfigurationSection(key);
            if (shopSection == null) continue;
            Location signLocation = this.parseLocation(key);
            if (signLocation == null) {
                String signWorld = this.worldNameForKey(key);
                if (signWorld == null || Bukkit.getWorld((String)signWorld) != null) continue;
                this.logger.log(Level.INFO, "Skipping player shop at {0} because world ''{1}'' is not loaded; preserving entry.", new Object[]{key, signWorld});
                this.deferredEntries.put(key, new HashMap(shopSection.getValues(false)));
                continue;
            }
            UUID ownerId = null;
            String ownerText = shopSection.getString("owner");
            if (ownerText != null) {
                try {
                    ownerId = UUID.fromString(ownerText);
                }
                catch (IllegalArgumentException ignored) {
                    ownerId = null;
                }
            }
            if (ownerId == null) continue;
            int quantity = shopSection.getInt("quantity");
            double price = shopSection.getDouble("price");
            ItemStack item = shopSection.getItemStack("item");
            List chestKeys = shopSection.getStringList("chests");
            if (quantity <= 0 || price <= 0.0 || item == null || chestKeys.isEmpty()) continue;
            ArrayList<Location> chestLocations = new ArrayList<Location>();
            HashSet<String> missingWorlds = new HashSet<String>();
            for (String chestKey : chestKeys) {
                Location chestLocation = this.parseLocation(chestKey);
                if (chestLocation != null) {
                    chestLocations.add(chestLocation);
                    continue;
                }
                String chestWorld = this.worldNameForKey(chestKey);
                if (chestWorld == null || Bukkit.getWorld((String)chestWorld) != null) continue;
                missingWorlds.add(chestWorld);
            }
            if (!missingWorlds.isEmpty()) {
                this.logger.log(Level.INFO, "Skipping player shop at {0} because world(s) {1} are not loaded; preserving entry.", new Object[]{key, String.join((CharSequence)", ", missingWorlds)});
                this.deferredEntries.put(key, new HashMap(shopSection.getValues(false)));
                continue;
            }
            if (chestLocations.isEmpty() || !((signBlock = signLocation.getBlock()).getState() instanceof Sign)) continue;
            PlayerShop shop = new PlayerShop(ownerId, signLocation, (Location)chestLocations.get(0), chestLocations, item, quantity, price);
            shops.add(shop);
        }
        return shops;
    }

    @Override
    public void saveShops(Map<String, PlayerShop> shopsBySign, Map<String, Map<String, Object>> deferredEntries) {
        try {
            this.ensureDataFile();
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Failed to create player shop data file", ex);
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        ConfigurationSection section = configuration.createSection("shops");
        for (PlayerShop playerShop : shopsBySign.values()) {
            String key = this.locationKey(playerShop.signLocation());
            ConfigurationSection shopSection = section.createSection(key);
            shopSection.set("owner", (Object)playerShop.ownerId().toString());
            shopSection.set("quantity", (Object)playerShop.quantityPerSale());
            shopSection.set("price", (Object)playerShop.price());
            shopSection.set("item", (Object)playerShop.itemTemplate());
            List chestKeys = playerShop.chestLocations().stream().map(this::locationKey).collect(Collectors.toList());
            shopSection.set("chests", chestKeys);
        }
        for (Map.Entry entry : deferredEntries.entrySet()) {
            if (section.getConfigurationSection((String)entry.getKey()) != null) continue;
            section.createSection((String)entry.getKey(), (Map)entry.getValue());
        }
        try {
            configuration.save(this.dataFile);
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Failed to save player shop data", iOException);
        }
    }

    @Override
    public String locationKey(Location location) {
        if (location == null || location.getWorld() == null) {
            return "";
        }
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    @Override
    public Location parseLocation(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        String[] parts = key.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return Optional.ofNullable(Bukkit.getWorld((String)parts[0])).map(world -> new Location(world, (double)x, (double)y, (double)z)).orElse(null);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public String worldNameForKey(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        String[] parts = key.split(",");
        if (parts.length != 4) {
            return null;
        }
        return parts[0].isEmpty() ? null : parts[0];
    }

    @Override
    public Map<String, Map<String, Object>> getDeferredEntries() {
        return new HashMap<String, Map<String, Object>>(this.deferredEntries);
    }

    private void ensureDataFile() throws IOException {
        if (!this.dataFile.exists()) {
            File parent = this.dataFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (!this.dataFile.createNewFile()) {
                throw new IOException("Unable to create player-shops.yml");
            }
        }
    }
}

