/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.playershop;

import com.skyblockexp.ezshops.config.PlayerShopConfiguration;
import com.skyblockexp.ezshops.playershop.PlayerShopManager;
import com.skyblockexp.ezshops.playershop.PlayerShopMessages;
import com.skyblockexp.ezshops.playershop.PlayerShopSetup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerShopSetupMenu
implements Listener {
    private static final int INVENTORY_SIZE = 27;
    private static final int SLOT_CONFIRM = 4;
    private static final int SLOT_ITEM_DISPLAY = 12;
    private static final int SLOT_QUANTITY_DISPLAY = 13;
    private static final int SLOT_QUANTITY_INPUT = 14;
    private static final int SLOT_PRICE_DISPLAY = 22;
    private static final int SLOT_PRICE_INPUT = 23;
    private static final int SLOT_QUANTITY_MINUS_ONE = 9;
    private static final int SLOT_QUANTITY_MINUS_SIXTEEN = 10;
    private static final int SLOT_QUANTITY_PLUS_SIXTEEN = 16;
    private static final int SLOT_QUANTITY_PLUS_ONE = 17;
    private static final int SLOT_PRICE_MINUS_ONE = 18;
    private static final int SLOT_PRICE_MINUS_TEN = 19;
    private static final int SLOT_PRICE_PLUS_TEN = 25;
    private static final int SLOT_PRICE_PLUS_ONE = 26;
    private final JavaPlugin plugin;
    private final PlayerShopManager manager;
    private final PlayerShopConfiguration configuration;
    private final PlayerShopMessages messages;
    private final Map<UUID, MenuState> openMenus;
    private final Map<UUID, PendingChatInput> pendingInputs;

    public PlayerShopSetupMenu(JavaPlugin plugin, PlayerShopManager manager, PlayerShopConfiguration configuration) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.manager = Objects.requireNonNull(manager, "manager");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.messages = configuration.messages();
        this.openMenus = new HashMap<UUID, MenuState>();
        this.pendingInputs = new ConcurrentHashMap<UUID, PendingChatInput>();
    }

    public void open(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.pendingInputs.remove(playerId);
        PlayerShopSetup existing = this.manager.normalizeSetup(this.manager.getPendingSetup(playerId));
        int startingQuantity = existing != null ? existing.quantity() : Math.max(1, this.configuration.minQuantity());
        double startingPrice = existing != null ? existing.price() : this.defaultPrice();
        MenuState state = new MenuState(startingQuantity, startingPrice);
        state.inventory = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)this.messages.menu().inventoryTitle());
        state.itemTemplate = this.sanitizeTemplate(existing != null ? existing.itemTemplate() : null);
        this.openMenus.put(playerId, state);
        this.redraw(state);
        player.openInventory(state.inventory);
        player.sendMessage(this.messages.setupOpen());
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        void player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        MenuState state = this.openMenus.get(player.getUniqueId());
        if (state == null || state.inventory == null) {
            return;
        }
        if (!event.getInventory().equals(state.inventory)) {
            return;
        }
        event.setCancelled(true);
        int rawSlot = event.getRawSlot();
        this.pendingInputs.remove(player.getUniqueId());
        if (rawSlot >= state.inventory.getSize()) {
            ItemStack template;
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && (template = this.sanitizeTemplate(clicked)) != null) {
                state.itemTemplate = template;
                player.sendMessage(this.messages.setupItemSelected(this.describeItem(template)));
                this.redraw(state);
            }
            return;
        }
        if (rawSlot < 0) {
            return;
        }
        if (rawSlot == 12) {
            if (state.itemTemplate != null) {
                state.itemTemplate = null;
                player.sendMessage(this.messages.setupItemCleared());
                this.redraw(state);
            } else {
                player.sendMessage(this.messages.setupSelectItem());
            }
            return;
        }
        if (rawSlot == 4) {
            this.manager.setPendingSetup(player.getUniqueId(), new PlayerShopSetup(state.quantity, state.price, this.copyTemplate(state.itemTemplate)));
            player.closeInventory();
            player.sendMessage(this.messages.setupSaved());
            return;
        }
        switch (rawSlot) {
            case 9: {
                this.adjustQuantity(state, -1);
                break;
            }
            case 10: {
                this.adjustQuantity(state, -16);
                break;
            }
            case 16: {
                this.adjustQuantity(state, 16);
                break;
            }
            case 17: {
                this.adjustQuantity(state, 1);
                break;
            }
            case 14: {
                this.startQuantityInput((Player)player, state);
                break;
            }
            case 18: {
                this.adjustPrice(state, -1.0);
                break;
            }
            case 19: {
                this.adjustPrice(state, -10.0);
                break;
            }
            case 25: {
                this.adjustPrice(state, 10.0);
                break;
            }
            case 26: {
                this.adjustPrice(state, 1.0);
                break;
            }
            case 23: {
                this.startPriceInput((Player)player, state);
                break;
            }
        }
        this.redraw(state);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        MenuState state = this.openMenus.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        if (state.inventory != null && state.inventory.equals(event.getInventory())) {
            this.openMenus.remove(player.getUniqueId());
            this.pendingInputs.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        PendingChatInput pending = this.pendingInputs.get(playerId);
        if (pending == null) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleChatInput(event.getPlayer(), message));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.pendingInputs.remove(playerId);
        this.openMenus.remove(playerId);
    }

    private void adjustQuantity(MenuState state, int delta) {
        int newValue = state.quantity + delta;
        newValue = Math.max(this.configuration.minQuantity(), newValue);
        if (this.configuration.maxQuantity() > 0) {
            newValue = Math.min(this.configuration.maxQuantity(), newValue);
        }
        state.quantity = Math.max(1, newValue);
    }

    private void adjustPrice(MenuState state, double delta) {
        double newValue = state.price + delta;
        double min = Math.max(this.configuration.minPrice(), 0.01);
        if (newValue < min) {
            newValue = min;
        }
        if (this.configuration.maxPrice() > 0.0) {
            newValue = Math.min(this.configuration.maxPrice(), newValue);
        }
        state.price = this.roundPrice(newValue);
    }

    private void startQuantityInput(Player player, MenuState state) {
        if (player == null || state == null) {
            return;
        }
        this.pendingInputs.put(player.getUniqueId(), new PendingChatInput(state, InputType.QUANTITY));
        player.sendMessage(this.messages.setupQuantityChatPrompt());
    }

    private void startPriceInput(Player player, MenuState state) {
        if (player == null || state == null) {
            return;
        }
        this.pendingInputs.put(player.getUniqueId(), new PendingChatInput(state, InputType.PRICE));
        player.sendMessage(this.messages.setupPriceChatPrompt());
    }

    private void handleChatInput(Player player, String message) {
        String trimmed;
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        PendingChatInput pending = this.pendingInputs.get(playerId);
        if (pending == null || pending.state == null) {
            return;
        }
        String string = trimmed = message == null ? "" : message.trim();
        if (trimmed.equalsIgnoreCase("cancel")) {
            this.pendingInputs.remove(playerId);
            player.sendMessage(this.messages.setupChatCancelled());
            this.redraw(pending.state);
            return;
        }
        switch (pending.type) {
            case QUANTITY: {
                int value;
                try {
                    value = Integer.parseInt(trimmed);
                }
                catch (NumberFormatException ex) {
                    player.sendMessage(this.messages.setupChatInvalidNumber());
                    player.sendMessage(this.messages.setupQuantityChatPrompt());
                    return;
                }
                if (this.applyQuantityInput(player, pending.state, value)) {
                    this.pendingInputs.remove(playerId);
                    break;
                }
                player.sendMessage(this.messages.setupQuantityChatPrompt());
                break;
            }
            case PRICE: {
                double value;
                try {
                    value = Double.parseDouble(trimmed);
                }
                catch (NumberFormatException ex) {
                    player.sendMessage(this.messages.setupChatInvalidNumber());
                    player.sendMessage(this.messages.setupPriceChatPrompt());
                    return;
                }
                if (!Double.isFinite(value)) {
                    player.sendMessage(this.messages.setupChatInvalidNumber());
                    player.sendMessage(this.messages.setupPriceChatPrompt());
                    return;
                }
                if (this.applyPriceInput(player, pending.state, value)) {
                    this.pendingInputs.remove(playerId);
                    break;
                }
                player.sendMessage(this.messages.setupPriceChatPrompt());
                break;
            }
        }
    }

    private boolean applyQuantityInput(Player player, MenuState state, int value) {
        if (value <= 0) {
            player.sendMessage(this.messages.creationQuantityPositive());
            return false;
        }
        int min = Math.max(this.configuration.minQuantity(), 1);
        if (value < min) {
            player.sendMessage(this.messages.creationQuantityMin(min));
            return false;
        }
        if (this.configuration.maxQuantity() > 0 && value > this.configuration.maxQuantity()) {
            player.sendMessage(this.messages.creationQuantityMax(this.configuration.maxQuantity()));
            return false;
        }
        state.quantity = value;
        player.sendMessage(this.messages.setupQuantityUpdated(state.quantity));
        this.redraw(state);
        return true;
    }

    private boolean applyPriceInput(Player player, MenuState state, double value) {
        if (value <= 0.0) {
            player.sendMessage(this.messages.creationPricePositive());
            return false;
        }
        double min = this.configuration.minPrice();
        if (min > 0.0 && value < min) {
            player.sendMessage(this.messages.creationPriceMin(this.formatPrice(min)));
            return false;
        }
        double minimumAllowed = Math.max(min, 0.01);
        if (value < minimumAllowed) {
            player.sendMessage(this.messages.creationPricePositive());
            return false;
        }
        if (this.configuration.maxPrice() > 0.0 && value > this.configuration.maxPrice()) {
            player.sendMessage(this.messages.creationPriceMax(this.formatPrice(this.configuration.maxPrice())));
            return false;
        }
        state.price = this.roundPrice(value);
        player.sendMessage(this.messages.setupPriceUpdated(this.formatPrice(state.price)));
        this.redraw(state);
        return true;
    }

    private void redraw(MenuState state) {
        if (state.inventory == null) {
            return;
        }
        PlayerShopMessages.MenuMessages menuMessages = this.messages.menu();
        this.fillSpacer(state.inventory);
        state.inventory.setItem(4, this.item(Material.EMERALD_BLOCK, menuMessages.confirmButtonName(), menuMessages.confirmButtonLore().toArray(new String[0])));
        if (state.itemTemplate != null) {
            state.inventory.setItem(12, this.itemDisplay(state.itemTemplate));
        } else {
            state.inventory.setItem(12, this.item(Material.CHEST, menuMessages.selectItemName(), menuMessages.selectItemLore().toArray(new String[0])));
        }
        state.inventory.setItem(13, this.item(Material.PAPER, menuMessages.quantityName(), menuMessages.quantityValue(state.quantity)));
        state.inventory.setItem(14, this.item(Material.WRITABLE_BOOK, menuMessages.quantityTypeName(), menuMessages.quantityTypeLore().toArray(new String[0])));
        state.inventory.setItem(22, this.item(Material.GOLD_INGOT, menuMessages.priceName(), menuMessages.priceValue(this.formatPrice(state.price))));
        state.inventory.setItem(23, this.item(Material.NAME_TAG, menuMessages.priceTypeName(), menuMessages.priceTypeLore().toArray(new String[0])));
        state.inventory.setItem(9, this.item(Material.RED_STAINED_GLASS_PANE, menuMessages.quantityMinusOneLabel(), new String[0]));
        state.inventory.setItem(10, this.item(Material.REDSTONE, menuMessages.quantityMinusSixteenLabel(), new String[0]));
        state.inventory.setItem(16, this.item(Material.EMERALD, menuMessages.quantityPlusSixteenLabel(), new String[0]));
        state.inventory.setItem(17, this.item(Material.LIME_STAINED_GLASS_PANE, menuMessages.quantityPlusOneLabel(), new String[0]));
        state.inventory.setItem(18, this.item(Material.REDSTONE_TORCH, menuMessages.priceMinusOneLabel(), new String[0]));
        state.inventory.setItem(19, this.item(Material.REDSTONE_BLOCK, menuMessages.priceMinusTenLabel(), new String[0]));
        state.inventory.setItem(25, this.item(Material.EMERALD_BLOCK, menuMessages.pricePlusTenLabel(), new String[0]));
        state.inventory.setItem(26, this.item(Material.SEA_LANTERN, menuMessages.pricePlusOneLabel(), new String[0]));
    }

    private void fillSpacer(Inventory inventory) {
        ItemStack spacer = this.item(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        int i = 0;
        while (i < inventory.getSize()) {
            inventory.setItem(i, spacer);
            ++i;
        }
    }

    private ItemStack item(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null && lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            meta.setLocalizedName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack itemDisplay(ItemStack template) {
        ItemStack display = template.clone();
        display.setAmount(1);
        ItemMeta meta = display.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (meta != null) {
            if (meta.hasLore() && meta.getLore() != null) {
                lore.addAll(meta.getLore());
                if (!lore.isEmpty()) {
                    lore.add(" ");
                }
            }
            lore.add(this.messages.menu().itemSelectedClearHint());
            meta.setLore(lore);
            display.setItemMeta(meta);
        }
        return display;
    }

    private ItemStack sanitizeTemplate(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        ItemStack clone = item.clone();
        clone.setAmount(1);
        return clone;
    }

    private ItemStack copyTemplate(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemStack clone = item.clone();
        clone.setAmount(Math.max(1, clone.getAmount()));
        return clone;
    }

    private String describeItem(ItemStack item) {
        String displayName;
        if (item == null) {
            return this.messages.menu().unknownItemSingularPlain();
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && (displayName = ChatColor.stripColor((String)meta.getDisplayName())) != null && !displayName.isBlank()) {
            return displayName;
        }
        String[] parts = item.getType().name().toLowerCase(Locale.ENGLISH).split("_");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        String result = builder.toString().trim();
        return result.isEmpty() ? item.getType().name() : result;
    }

    private double defaultPrice() {
        double min = this.configuration.minPrice();
        if (min > 0.0) {
            return this.roundPrice(min);
        }
        return 1.0;
    }

    private String formatPrice(double price) {
        return String.format(Locale.US, "%.2f", price);
    }

    private double roundPrice(double price) {
        return (double)Math.round(price * 100.0) / 100.0;
    }

    private static enum InputType {
        QUANTITY,
        PRICE;

    }

    private static final class MenuState {
        private Inventory inventory;
        private int quantity;
        private double price;
        private ItemStack itemTemplate;

        private MenuState(int quantity, double price) {
            this.quantity = quantity;
            this.price = price;
        }
    }

    private static final class PendingChatInput {
        private final MenuState state;
        private final InputType type;

        private PendingChatInput(MenuState state, InputType type) {
            this.state = state;
            this.type = type;
        }
    }
}

