/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.playershop;

import com.skyblockexp.ezshops.common.MessageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public final class PlayerShopMessages {
    private static final String DEFAULT_NO_PERMISSION_CREATE = "&cYou do not have permission to create shops.";
    private static final String DEFAULT_SIGN_REQUIRES_CHEST = "&cShop signs must be attached to a chest.";
    private static final String DEFAULT_ENTER_QUANTITY = "&cEnter the quantity to sell on the second line.";
    private static final String DEFAULT_QUANTITY_PROMPT = "&cQty?";
    private static final String DEFAULT_ENTER_PRICE = "&cEnter the price on the third line.";
    private static final String DEFAULT_PRICE_PROMPT = "&cPrice?";
    private static final String DEFAULT_USING_SAVED_SETTINGS = "&aUsing your saved /playershop settings.";
    private static final String DEFAULT_CHEST_ACCESS_DENIED = "&cYou cannot open another player's shop chest.";
    private static final String DEFAULT_BREAK_DENIED = "&cYou cannot break someone else's shop.";
    private static final String DEFAULT_SHOP_REMOVED = "&eShop removed.";
    private static final String DEFAULT_CREATION_INVALID_CONFIGURATION = "&cInvalid shop configuration.";
    private static final String DEFAULT_CREATION_QUANTITY_POSITIVE = "&cQuantity must be greater than zero.";
    private static final String DEFAULT_CREATION_QUANTITY_MIN = "&cQuantity must be at least &b{min}&c.";
    private static final String DEFAULT_CREATION_QUANTITY_MAX = "&cQuantity cannot exceed &b{max}&c.";
    private static final String DEFAULT_CREATION_PRICE_POSITIVE = "&cPrice must be greater than zero.";
    private static final String DEFAULT_CREATION_PRICE_MIN = "&cPrice must be at least &6{min}&c.";
    private static final String DEFAULT_CREATION_PRICE_MAX = "&cPrice cannot exceed &6{max}&c.";
    private static final String DEFAULT_CREATION_SIGN_IN_USE = "&cThere is already a shop on this sign.";
    private static final String DEFAULT_CREATION_CHEST_UNRESOLVED = "&cShop chests could not be resolved.";
    private static final String DEFAULT_CREATION_CHEST_IN_USE = "&cA shop already uses that chest.";
    private static final String DEFAULT_CREATION_CHEST_INACCESSIBLE = "&cUnable to access the chest inventory.";
    private static final String DEFAULT_CREATION_SELECTED_ITEM_MISSING = "&cThe chest does not contain the item you selected in /playershop.";
    private static final String DEFAULT_CREATION_ITEM_MISSING = "&cPlace the item you want to sell inside the chest.";
    private static final String DEFAULT_CREATION_INSUFFICIENT_STOCK = "&cThe chest does not contain enough items to start the shop.";
    private static final String DEFAULT_CREATION_SUCCESS = "&aShop created successfully!";
    private static final String DEFAULT_PURCHASE_INVALID = "&cInvalid shop purchase attempt.";
    private static final String DEFAULT_PURCHASE_NO_PERMISSION = "&cYou do not have permission to buy from shops.";
    private static final String DEFAULT_PURCHASE_NO_ECONOMY = "&cThe shop is currently unavailable because no economy provider is configured.";
    private static final String DEFAULT_PURCHASE_OWN_SHOP = "&cYou cannot buy from your own shop.";
    private static final String DEFAULT_PURCHASE_MISSING_CHEST = "&cThe shop chest is missing. The listing has been removed.";
    private static final String DEFAULT_PURCHASE_OUT_OF_STOCK = "&cThis shop is currently out of stock.";
    private static final String DEFAULT_PURCHASE_NO_SPACE = "&cYou do not have enough inventory space.";
    private static final String DEFAULT_PURCHASE_TRANSACTION_FAILED = "&cTransaction failed: {error}";
    private static final String DEFAULT_PURCHASE_OWNER_NOTIFY = "&b{buyer} &abought &b{item}&a for &6{price}&a.";
    private static final String DEFAULT_PURCHASE_BUYER_SUCCESS = "&aPurchased &b{item}&a from &b{seller}&a for &6{price}&a.";
    private static final String DEFAULT_UNKNOWN_SELLER_NAME = "the seller";
    private static final String DEFAULT_SETUP_OPEN = "&aConfigure your player shop settings, then confirm to save them.";
    private static final String DEFAULT_SETUP_ITEM_SELECTED = "&aSelected &b{item}&a to sell.";
    private static final String DEFAULT_SETUP_ITEM_CLEARED = "&eCleared the selected item. The chest contents will decide what the shop sells.";
    private static final String DEFAULT_SETUP_SELECT_ITEM = "&eClick an item in your inventory to choose what to sell.";
    private static final String DEFAULT_SETUP_SAVED = "&aSaved your player shop settings. Place a [playershop] sign on a chest to use them.";
    private static final String DEFAULT_SETUP_QUANTITY_CHAT_PROMPT = "&eType the quantity to sell in chat, or type cancel to abort.";
    private static final String DEFAULT_SETUP_PRICE_CHAT_PROMPT = "&eType the price in chat, or type cancel to abort.";
    private static final String DEFAULT_SETUP_CHAT_CANCELLED = "&eInput cancelled. Keeping the previous value.";
    private static final String DEFAULT_SETUP_CHAT_INVALID_NUMBER = "&cPlease enter a valid number.";
    private static final String DEFAULT_SETUP_QUANTITY_UPDATED = "&aQuantity set to &b{amount}&a.";
    private static final String DEFAULT_SETUP_PRICE_UPDATED = "&aPrice set to &6{price}&a.";
    private static final String DEFAULT_COMMAND_PLAYERS_ONLY = "&cOnly players can use this command.";
    private static final String DEFAULT_COMMAND_DISABLED = "&cPlayer shops are currently disabled.";
    private static final String DEFAULT_MENU_INVENTORY_TITLE = "&2Player Shop Setup";
    private static final String DEFAULT_MENU_CONFIRM_BUTTON_NAME = "&aSave Settings";
    private static final List<String> DEFAULT_MENU_CONFIRM_BUTTON_LORE = List.of("&7Apply these values to your next shop.");
    private static final String DEFAULT_MENU_SELECT_ITEM_NAME = "&eSelect Item";
    private static final List<String> DEFAULT_MENU_SELECT_ITEM_LORE = List.of("&7Click an item in your inventory to choose it.", "&7Current: None", "&7Click this slot to clear the selection.");
    private static final String DEFAULT_MENU_ITEM_SELECTED_CLEAR_HINT = "&7Click to clear this selection.";
    private static final String DEFAULT_MENU_QUANTITY_NAME = "&bQuantity";
    private static final String DEFAULT_MENU_QUANTITY_VALUE_FORMAT = "&ex{amount}";
    private static final String DEFAULT_MENU_PRICE_NAME = "&6Price";
    private static final String DEFAULT_MENU_PRICE_VALUE_FORMAT = "&e{price}";
    private static final String DEFAULT_MENU_QUANTITY_MINUS_ONE = "&c-1";
    private static final String DEFAULT_MENU_QUANTITY_MINUS_SIXTEEN = "&c-16";
    private static final String DEFAULT_MENU_QUANTITY_PLUS_SIXTEEN = "&a+16";
    private static final String DEFAULT_MENU_QUANTITY_PLUS_ONE = "&a+1";
    private static final String DEFAULT_MENU_PRICE_MINUS_ONE = "&c-1";
    private static final String DEFAULT_MENU_PRICE_MINUS_TEN = "&c-10";
    private static final String DEFAULT_MENU_PRICE_PLUS_TEN = "&a+10";
    private static final String DEFAULT_MENU_PRICE_PLUS_ONE = "&a+1";
    private static final String DEFAULT_MENU_QUANTITY_TYPE_NAME = "&bType Quantity";
    private static final List<String> DEFAULT_MENU_QUANTITY_TYPE_LORE = List.of("&7Enter an exact quantity in chat.", "&7Type &fcancel &7to abort.");
    private static final String DEFAULT_MENU_PRICE_TYPE_NAME = "&6Type Price";
    private static final List<String> DEFAULT_MENU_PRICE_TYPE_LORE = List.of("&7Enter an exact price in chat.", "&7Type &fcancel &7to abort.");
    private static final String DEFAULT_MENU_ITEM_DESCRIPTION_FORMAT = "&b{amount}&7x {item}";
    private static final String DEFAULT_MENU_UNKNOWN_ITEM_SINGULAR = "&bItem";
    private static final String DEFAULT_MENU_UNKNOWN_ITEM_PLURAL = "&bItems";
    private final String noPermissionCreate;
    private final String signRequiresChest;
    private final String enterQuantity;
    private final String quantityPrompt;
    private final String enterPrice;
    private final String pricePrompt;
    private final String usingSavedSettings;
    private final String chestAccessDenied;
    private final String breakDenied;
    private final String shopRemoved;
    private final String creationInvalidConfiguration;
    private final String creationQuantityPositive;
    private final String creationQuantityMin;
    private final String creationQuantityMax;
    private final String creationPricePositive;
    private final String creationPriceMin;
    private final String creationPriceMax;
    private final String creationSignInUse;
    private final String creationChestUnresolved;
    private final String creationChestInUse;
    private final String creationChestInaccessible;
    private final String creationSelectedItemMissing;
    private final String creationItemMissing;
    private final String creationInsufficientStock;
    private final String creationSuccess;
    private final String purchaseInvalid;
    private final String purchaseNoPermission;
    private final String purchaseNoEconomy;
    private final String purchaseOwnShop;
    private final String purchaseMissingChest;
    private final String purchaseOutOfStock;
    private final String purchaseNoSpace;
    private final String purchaseTransactionFailed;
    private final String purchaseOwnerNotify;
    private final String purchaseBuyerSuccess;
    private final String unknownSellerName;
    private final String setupOpen;
    private final String setupItemSelected;
    private final String setupItemCleared;
    private final String setupSelectItem;
    private final String setupSaved;
    private final String setupQuantityChatPrompt;
    private final String setupPriceChatPrompt;
    private final String setupChatCancelled;
    private final String setupChatInvalidNumber;
    private final String setupQuantityUpdated;
    private final String setupPriceUpdated;
    private final String commandPlayersOnly;
    private final String commandDisabled;
    private final MenuMessages menu;

    private PlayerShopMessages(String noPermissionCreate, String signRequiresChest, String enterQuantity, String quantityPrompt, String enterPrice, String pricePrompt, String usingSavedSettings, String chestAccessDenied, String breakDenied, String shopRemoved, String creationInvalidConfiguration, String creationQuantityPositive, String creationQuantityMin, String creationQuantityMax, String creationPricePositive, String creationPriceMin, String creationPriceMax, String creationSignInUse, String creationChestUnresolved, String creationChestInUse, String creationChestInaccessible, String creationSelectedItemMissing, String creationItemMissing, String creationInsufficientStock, String creationSuccess, String purchaseInvalid, String purchaseNoPermission, String purchaseNoEconomy, String purchaseOwnShop, String purchaseMissingChest, String purchaseOutOfStock, String purchaseNoSpace, String purchaseTransactionFailed, String purchaseOwnerNotify, String purchaseBuyerSuccess, String unknownSellerName, String setupOpen, String setupItemSelected, String setupItemCleared, String setupSelectItem, String setupSaved, String setupQuantityChatPrompt, String setupPriceChatPrompt, String setupChatCancelled, String setupChatInvalidNumber, String setupQuantityUpdated, String setupPriceUpdated, String commandPlayersOnly, String commandDisabled, MenuMessages menu) {
        this.noPermissionCreate = noPermissionCreate;
        this.signRequiresChest = signRequiresChest;
        this.enterQuantity = enterQuantity;
        this.quantityPrompt = quantityPrompt;
        this.enterPrice = enterPrice;
        this.pricePrompt = pricePrompt;
        this.usingSavedSettings = usingSavedSettings;
        this.chestAccessDenied = chestAccessDenied;
        this.breakDenied = breakDenied;
        this.shopRemoved = shopRemoved;
        this.creationInvalidConfiguration = creationInvalidConfiguration;
        this.creationQuantityPositive = creationQuantityPositive;
        this.creationQuantityMin = creationQuantityMin;
        this.creationQuantityMax = creationQuantityMax;
        this.creationPricePositive = creationPricePositive;
        this.creationPriceMin = creationPriceMin;
        this.creationPriceMax = creationPriceMax;
        this.creationSignInUse = creationSignInUse;
        this.creationChestUnresolved = creationChestUnresolved;
        this.creationChestInUse = creationChestInUse;
        this.creationChestInaccessible = creationChestInaccessible;
        this.creationSelectedItemMissing = creationSelectedItemMissing;
        this.creationItemMissing = creationItemMissing;
        this.creationInsufficientStock = creationInsufficientStock;
        this.creationSuccess = creationSuccess;
        this.purchaseInvalid = purchaseInvalid;
        this.purchaseNoPermission = purchaseNoPermission;
        this.purchaseNoEconomy = purchaseNoEconomy;
        this.purchaseOwnShop = purchaseOwnShop;
        this.purchaseMissingChest = purchaseMissingChest;
        this.purchaseOutOfStock = purchaseOutOfStock;
        this.purchaseNoSpace = purchaseNoSpace;
        this.purchaseTransactionFailed = purchaseTransactionFailed;
        this.purchaseOwnerNotify = purchaseOwnerNotify;
        this.purchaseBuyerSuccess = purchaseBuyerSuccess;
        this.unknownSellerName = unknownSellerName;
        this.setupOpen = setupOpen;
        this.setupItemSelected = setupItemSelected;
        this.setupItemCleared = setupItemCleared;
        this.setupSelectItem = setupSelectItem;
        this.setupSaved = setupSaved;
        this.setupQuantityChatPrompt = setupQuantityChatPrompt;
        this.setupPriceChatPrompt = setupPriceChatPrompt;
        this.setupChatCancelled = setupChatCancelled;
        this.setupChatInvalidNumber = setupChatInvalidNumber;
        this.setupQuantityUpdated = setupQuantityUpdated;
        this.setupPriceUpdated = setupPriceUpdated;
        this.commandPlayersOnly = commandPlayersOnly;
        this.commandDisabled = commandDisabled;
        this.menu = Objects.requireNonNull(menu, "menu");
    }

    public static PlayerShopMessages from(ConfigurationSection section) {
        if (section == null) {
            return PlayerShopMessages.defaults();
        }
        MenuMessages menu = MenuMessages.from(section.getConfigurationSection("menu"));
        return new PlayerShopMessages(PlayerShopMessages.translate(section.getString("no-permission-create", DEFAULT_NO_PERMISSION_CREATE)), PlayerShopMessages.translate(section.getString("sign-requires-chest", DEFAULT_SIGN_REQUIRES_CHEST)), PlayerShopMessages.translate(section.getString("enter-quantity", DEFAULT_ENTER_QUANTITY)), PlayerShopMessages.translate(section.getString("quantity-prompt", DEFAULT_QUANTITY_PROMPT)), PlayerShopMessages.translate(section.getString("enter-price", DEFAULT_ENTER_PRICE)), PlayerShopMessages.translate(section.getString("price-prompt", DEFAULT_PRICE_PROMPT)), PlayerShopMessages.translate(section.getString("using-saved-settings", DEFAULT_USING_SAVED_SETTINGS)), PlayerShopMessages.translate(section.getString("chest-access-denied", DEFAULT_CHEST_ACCESS_DENIED)), PlayerShopMessages.translate(section.getString("break-denied", DEFAULT_BREAK_DENIED)), PlayerShopMessages.translate(section.getString("shop-removed", DEFAULT_SHOP_REMOVED)), PlayerShopMessages.translate(section.getString("creation-invalid-configuration", DEFAULT_CREATION_INVALID_CONFIGURATION)), PlayerShopMessages.translate(section.getString("creation-quantity-positive", DEFAULT_CREATION_QUANTITY_POSITIVE)), PlayerShopMessages.translate(section.getString("creation-quantity-min", DEFAULT_CREATION_QUANTITY_MIN)), PlayerShopMessages.translate(section.getString("creation-quantity-max", DEFAULT_CREATION_QUANTITY_MAX)), PlayerShopMessages.translate(section.getString("creation-price-positive", DEFAULT_CREATION_PRICE_POSITIVE)), PlayerShopMessages.translate(section.getString("creation-price-min", DEFAULT_CREATION_PRICE_MIN)), PlayerShopMessages.translate(section.getString("creation-price-max", DEFAULT_CREATION_PRICE_MAX)), PlayerShopMessages.translate(section.getString("creation-sign-in-use", DEFAULT_CREATION_SIGN_IN_USE)), PlayerShopMessages.translate(section.getString("creation-chest-unresolved", DEFAULT_CREATION_CHEST_UNRESOLVED)), PlayerShopMessages.translate(section.getString("creation-chest-in-use", DEFAULT_CREATION_CHEST_IN_USE)), PlayerShopMessages.translate(section.getString("creation-chest-inaccessible", DEFAULT_CREATION_CHEST_INACCESSIBLE)), PlayerShopMessages.translate(section.getString("creation-selected-item-missing", DEFAULT_CREATION_SELECTED_ITEM_MISSING)), PlayerShopMessages.translate(section.getString("creation-item-missing", DEFAULT_CREATION_ITEM_MISSING)), PlayerShopMessages.translate(section.getString("creation-insufficient-stock", DEFAULT_CREATION_INSUFFICIENT_STOCK)), PlayerShopMessages.translate(section.getString("creation-success", DEFAULT_CREATION_SUCCESS)), PlayerShopMessages.translate(section.getString("purchase-invalid", DEFAULT_PURCHASE_INVALID)), PlayerShopMessages.translate(section.getString("purchase-no-permission", DEFAULT_PURCHASE_NO_PERMISSION)), PlayerShopMessages.translate(section.getString("purchase-no-economy", DEFAULT_PURCHASE_NO_ECONOMY)), PlayerShopMessages.translate(section.getString("purchase-own-shop", DEFAULT_PURCHASE_OWN_SHOP)), PlayerShopMessages.translate(section.getString("purchase-missing-chest", DEFAULT_PURCHASE_MISSING_CHEST)), PlayerShopMessages.translate(section.getString("purchase-out-of-stock", DEFAULT_PURCHASE_OUT_OF_STOCK)), PlayerShopMessages.translate(section.getString("purchase-no-space", DEFAULT_PURCHASE_NO_SPACE)), PlayerShopMessages.translate(section.getString("purchase-transaction-failed", DEFAULT_PURCHASE_TRANSACTION_FAILED)), PlayerShopMessages.translate(section.getString("purchase-owner-notify", DEFAULT_PURCHASE_OWNER_NOTIFY)), PlayerShopMessages.translate(section.getString("purchase-buyer-success", DEFAULT_PURCHASE_BUYER_SUCCESS)), section.getString("unknown-seller-name", DEFAULT_UNKNOWN_SELLER_NAME), PlayerShopMessages.translate(section.getString("setup-open", DEFAULT_SETUP_OPEN)), PlayerShopMessages.translate(section.getString("setup-item-selected", DEFAULT_SETUP_ITEM_SELECTED)), PlayerShopMessages.translate(section.getString("setup-item-cleared", DEFAULT_SETUP_ITEM_CLEARED)), PlayerShopMessages.translate(section.getString("setup-select-item", DEFAULT_SETUP_SELECT_ITEM)), PlayerShopMessages.translate(section.getString("setup-saved", DEFAULT_SETUP_SAVED)), PlayerShopMessages.translate(section.getString("setup-quantity-chat-prompt", DEFAULT_SETUP_QUANTITY_CHAT_PROMPT)), PlayerShopMessages.translate(section.getString("setup-price-chat-prompt", DEFAULT_SETUP_PRICE_CHAT_PROMPT)), PlayerShopMessages.translate(section.getString("setup-chat-cancelled", DEFAULT_SETUP_CHAT_CANCELLED)), PlayerShopMessages.translate(section.getString("setup-chat-invalid-number", DEFAULT_SETUP_CHAT_INVALID_NUMBER)), PlayerShopMessages.translate(section.getString("setup-quantity-updated", DEFAULT_SETUP_QUANTITY_UPDATED)), PlayerShopMessages.translate(section.getString("setup-price-updated", DEFAULT_SETUP_PRICE_UPDATED)), PlayerShopMessages.translate(section.getString("command-players-only", DEFAULT_COMMAND_PLAYERS_ONLY)), PlayerShopMessages.translate(section.getString("command-disabled", DEFAULT_COMMAND_DISABLED)), menu);
    }

    public static PlayerShopMessages defaults() {
        return new PlayerShopMessages(PlayerShopMessages.translate(DEFAULT_NO_PERMISSION_CREATE), PlayerShopMessages.translate(DEFAULT_SIGN_REQUIRES_CHEST), PlayerShopMessages.translate(DEFAULT_ENTER_QUANTITY), PlayerShopMessages.translate(DEFAULT_QUANTITY_PROMPT), PlayerShopMessages.translate(DEFAULT_ENTER_PRICE), PlayerShopMessages.translate(DEFAULT_PRICE_PROMPT), PlayerShopMessages.translate(DEFAULT_USING_SAVED_SETTINGS), PlayerShopMessages.translate(DEFAULT_CHEST_ACCESS_DENIED), PlayerShopMessages.translate(DEFAULT_BREAK_DENIED), PlayerShopMessages.translate(DEFAULT_SHOP_REMOVED), PlayerShopMessages.translate(DEFAULT_CREATION_INVALID_CONFIGURATION), PlayerShopMessages.translate(DEFAULT_CREATION_QUANTITY_POSITIVE), PlayerShopMessages.translate(DEFAULT_CREATION_QUANTITY_MIN), PlayerShopMessages.translate(DEFAULT_CREATION_QUANTITY_MAX), PlayerShopMessages.translate(DEFAULT_CREATION_PRICE_POSITIVE), PlayerShopMessages.translate(DEFAULT_CREATION_PRICE_MIN), PlayerShopMessages.translate(DEFAULT_CREATION_PRICE_MAX), PlayerShopMessages.translate(DEFAULT_CREATION_SIGN_IN_USE), PlayerShopMessages.translate(DEFAULT_CREATION_CHEST_UNRESOLVED), PlayerShopMessages.translate(DEFAULT_CREATION_CHEST_IN_USE), PlayerShopMessages.translate(DEFAULT_CREATION_CHEST_INACCESSIBLE), PlayerShopMessages.translate(DEFAULT_CREATION_SELECTED_ITEM_MISSING), PlayerShopMessages.translate(DEFAULT_CREATION_ITEM_MISSING), PlayerShopMessages.translate(DEFAULT_CREATION_INSUFFICIENT_STOCK), PlayerShopMessages.translate(DEFAULT_CREATION_SUCCESS), PlayerShopMessages.translate(DEFAULT_PURCHASE_INVALID), PlayerShopMessages.translate(DEFAULT_PURCHASE_NO_PERMISSION), PlayerShopMessages.translate(DEFAULT_PURCHASE_NO_ECONOMY), PlayerShopMessages.translate(DEFAULT_PURCHASE_OWN_SHOP), PlayerShopMessages.translate(DEFAULT_PURCHASE_MISSING_CHEST), PlayerShopMessages.translate(DEFAULT_PURCHASE_OUT_OF_STOCK), PlayerShopMessages.translate(DEFAULT_PURCHASE_NO_SPACE), PlayerShopMessages.translate(DEFAULT_PURCHASE_TRANSACTION_FAILED), PlayerShopMessages.translate(DEFAULT_PURCHASE_OWNER_NOTIFY), PlayerShopMessages.translate(DEFAULT_PURCHASE_BUYER_SUCCESS), DEFAULT_UNKNOWN_SELLER_NAME, PlayerShopMessages.translate(DEFAULT_SETUP_OPEN), PlayerShopMessages.translate(DEFAULT_SETUP_ITEM_SELECTED), PlayerShopMessages.translate(DEFAULT_SETUP_ITEM_CLEARED), PlayerShopMessages.translate(DEFAULT_SETUP_SELECT_ITEM), PlayerShopMessages.translate(DEFAULT_SETUP_SAVED), PlayerShopMessages.translate(DEFAULT_SETUP_QUANTITY_CHAT_PROMPT), PlayerShopMessages.translate(DEFAULT_SETUP_PRICE_CHAT_PROMPT), PlayerShopMessages.translate(DEFAULT_SETUP_CHAT_CANCELLED), PlayerShopMessages.translate(DEFAULT_SETUP_CHAT_INVALID_NUMBER), PlayerShopMessages.translate(DEFAULT_SETUP_QUANTITY_UPDATED), PlayerShopMessages.translate(DEFAULT_SETUP_PRICE_UPDATED), PlayerShopMessages.translate(DEFAULT_COMMAND_PLAYERS_ONLY), PlayerShopMessages.translate(DEFAULT_COMMAND_DISABLED), MenuMessages.defaults());
    }

    public String noPermissionCreate() {
        return this.noPermissionCreate;
    }

    public String signRequiresChest() {
        return this.signRequiresChest;
    }

    public String enterQuantity() {
        return this.enterQuantity;
    }

    public String quantityPrompt() {
        return this.quantityPrompt;
    }

    public String enterPrice() {
        return this.enterPrice;
    }

    public String pricePrompt() {
        return this.pricePrompt;
    }

    public String usingSavedSettings() {
        return this.usingSavedSettings;
    }

    public String chestAccessDenied() {
        return this.chestAccessDenied;
    }

    public String breakDenied() {
        return this.breakDenied;
    }

    public String shopRemoved() {
        return this.shopRemoved;
    }

    public String creationInvalidConfiguration() {
        return this.creationInvalidConfiguration;
    }

    public String creationQuantityPositive() {
        return this.creationQuantityPositive;
    }

    public String creationQuantityMin(int min) {
        return PlayerShopMessages.format(this.creationQuantityMin, "min", Integer.toString(min));
    }

    public String creationQuantityMax(int max) {
        return PlayerShopMessages.format(this.creationQuantityMax, "max", Integer.toString(max));
    }

    public String creationPricePositive() {
        return this.creationPricePositive;
    }

    public String creationPriceMin(String minPrice) {
        return PlayerShopMessages.format(this.creationPriceMin, "min", Objects.toString(minPrice, ""));
    }

    public String creationPriceMax(String maxPrice) {
        return PlayerShopMessages.format(this.creationPriceMax, "max", Objects.toString(maxPrice, ""));
    }

    public String creationSignInUse() {
        return this.creationSignInUse;
    }

    public String creationChestUnresolved() {
        return this.creationChestUnresolved;
    }

    public String creationChestInUse() {
        return this.creationChestInUse;
    }

    public String creationChestInaccessible() {
        return this.creationChestInaccessible;
    }

    public String creationSelectedItemMissing() {
        return this.creationSelectedItemMissing;
    }

    public String creationItemMissing() {
        return this.creationItemMissing;
    }

    public String creationInsufficientStock() {
        return this.creationInsufficientStock;
    }

    public String creationSuccess() {
        return this.creationSuccess;
    }

    public String purchaseInvalid() {
        return this.purchaseInvalid;
    }

    public String purchaseNoPermission() {
        return this.purchaseNoPermission;
    }

    public String purchaseNoEconomy() {
        return this.purchaseNoEconomy;
    }

    public String purchaseOwnShop() {
        return this.purchaseOwnShop;
    }

    public String purchaseMissingChest() {
        return this.purchaseMissingChest;
    }

    public String purchaseOutOfStock() {
        return this.purchaseOutOfStock;
    }

    public String purchaseNoSpace() {
        return this.purchaseNoSpace;
    }

    public String purchaseTransactionFailed(String error) {
        String sanitized = error;
        if (sanitized == null || sanitized.isBlank()) {
            sanitized = "unknown error";
        }
        return PlayerShopMessages.format(this.purchaseTransactionFailed, "error", sanitized);
    }

    public String purchaseOwnerNotify(String buyer, String item, String price) {
        return PlayerShopMessages.format(this.purchaseOwnerNotify, "buyer", Objects.toString(buyer, ""), "item", Objects.toString(item, ""), "price", Objects.toString(price, ""));
    }

    public String purchaseBuyerSuccess(String item, String seller, String price) {
        return PlayerShopMessages.format(this.purchaseBuyerSuccess, "item", Objects.toString(item, ""), "seller", Objects.toString(seller, ""), "price", Objects.toString(price, ""));
    }

    public String unknownSellerName() {
        return this.unknownSellerName;
    }

    public String setupOpen() {
        return this.setupOpen;
    }

    public String setupItemSelected(String itemName) {
        return PlayerShopMessages.format(this.setupItemSelected, "item", Objects.toString(itemName, ""));
    }

    public String setupItemCleared() {
        return this.setupItemCleared;
    }

    public String setupSelectItem() {
        return this.setupSelectItem;
    }

    public String setupSaved() {
        return this.setupSaved;
    }

    public String setupQuantityChatPrompt() {
        return this.setupQuantityChatPrompt;
    }

    public String setupPriceChatPrompt() {
        return this.setupPriceChatPrompt;
    }

    public String setupChatCancelled() {
        return this.setupChatCancelled;
    }

    public String setupChatInvalidNumber() {
        return this.setupChatInvalidNumber;
    }

    public String setupQuantityUpdated(int amount) {
        return PlayerShopMessages.format(this.setupQuantityUpdated, "amount", Integer.toString(amount));
    }

    public String setupPriceUpdated(String price) {
        return PlayerShopMessages.format(this.setupPriceUpdated, "price", Objects.toString(price, ""));
    }

    public String commandPlayersOnly() {
        return this.commandPlayersOnly;
    }

    public String commandDisabled() {
        return this.commandDisabled;
    }

    public MenuMessages menu() {
        return this.menu;
    }

    private static String translate(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        return MessageUtil.translateColors(text);
    }

    private static List<String> translateList(List<String> lines, List<String> defaults) {
        List<String> source = lines;
        if (source == null || source.isEmpty()) {
            source = defaults;
        }
        if (source == null || source.isEmpty()) {
            return List.of();
        }
        ArrayList<String> translated = new ArrayList<String>(source.size());
        for (String line : source) {
            translated.add(PlayerShopMessages.translate(line));
        }
        return List.copyOf(translated);
    }

    private static String format(String template, Object ... replacements) {
        if (template == null || template.isEmpty() || replacements.length == 0) {
            return template;
        }
        String result = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = Objects.toString(replacements[i], "");
            String value = Objects.toString(replacements[i + 1], "");
            result = result.replace("{" + key + "}", value);
            i += 2;
        }
        return result;
    }

    public static final class MenuMessages {
        private final String inventoryTitle;
        private final String confirmButtonName;
        private final List<String> confirmButtonLore;
        private final String selectItemName;
        private final List<String> selectItemLore;
        private final String itemSelectedClearHint;
        private final String quantityName;
        private final String quantityValueFormat;
        private final String priceName;
        private final String priceValueFormat;
        private final String quantityTypeName;
        private final List<String> quantityTypeLore;
        private final String priceTypeName;
        private final List<String> priceTypeLore;
        private final String quantityMinusOneLabel;
        private final String quantityMinusSixteenLabel;
        private final String quantityPlusSixteenLabel;
        private final String quantityPlusOneLabel;
        private final String priceMinusOneLabel;
        private final String priceMinusTenLabel;
        private final String pricePlusTenLabel;
        private final String pricePlusOneLabel;
        private final String itemDescriptionFormat;
        private final String unknownItemSingular;
        private final String unknownItemPlural;

        private MenuMessages(String inventoryTitle, String confirmButtonName, List<String> confirmButtonLore, String selectItemName, List<String> selectItemLore, String itemSelectedClearHint, String quantityName, String quantityValueFormat, String priceName, String priceValueFormat, String quantityTypeName, List<String> quantityTypeLore, String priceTypeName, List<String> priceTypeLore, String quantityMinusOneLabel, String quantityMinusSixteenLabel, String quantityPlusSixteenLabel, String quantityPlusOneLabel, String priceMinusOneLabel, String priceMinusTenLabel, String pricePlusTenLabel, String pricePlusOneLabel, String itemDescriptionFormat, String unknownItemSingular, String unknownItemPlural) {
            this.inventoryTitle = inventoryTitle;
            this.confirmButtonName = confirmButtonName;
            this.confirmButtonLore = confirmButtonLore;
            this.selectItemName = selectItemName;
            this.selectItemLore = selectItemLore;
            this.itemSelectedClearHint = itemSelectedClearHint;
            this.quantityName = quantityName;
            this.quantityValueFormat = quantityValueFormat;
            this.priceName = priceName;
            this.priceValueFormat = priceValueFormat;
            this.quantityTypeName = quantityTypeName;
            this.quantityTypeLore = quantityTypeLore;
            this.priceTypeName = priceTypeName;
            this.priceTypeLore = priceTypeLore;
            this.quantityMinusOneLabel = quantityMinusOneLabel;
            this.quantityMinusSixteenLabel = quantityMinusSixteenLabel;
            this.quantityPlusSixteenLabel = quantityPlusSixteenLabel;
            this.quantityPlusOneLabel = quantityPlusOneLabel;
            this.priceMinusOneLabel = priceMinusOneLabel;
            this.priceMinusTenLabel = priceMinusTenLabel;
            this.pricePlusTenLabel = pricePlusTenLabel;
            this.pricePlusOneLabel = pricePlusOneLabel;
            this.itemDescriptionFormat = itemDescriptionFormat;
            this.unknownItemSingular = unknownItemSingular;
            this.unknownItemPlural = unknownItemPlural;
        }

        public static MenuMessages from(ConfigurationSection section) {
            if (section == null) {
                return MenuMessages.defaults();
            }
            ConfigurationSection confirmSection = section.getConfigurationSection("confirm-button");
            ConfigurationSection selectSection = section.getConfigurationSection("select-item");
            ConfigurationSection quantityDisplay = section.getConfigurationSection("quantity-display");
            ConfigurationSection priceDisplay = section.getConfigurationSection("price-display");
            ConfigurationSection quantityInput = section.getConfigurationSection("quantity-input");
            ConfigurationSection priceInput = section.getConfigurationSection("price-input");
            ConfigurationSection quantityAdjust = section.getConfigurationSection("quantity-adjust");
            ConfigurationSection priceAdjust = section.getConfigurationSection("price-adjust");
            ConfigurationSection unknownItem = section.getConfigurationSection("unknown-item");
            List confirmLore = confirmSection != null ? confirmSection.getStringList("lore") : null;
            List selectLore = selectSection != null ? selectSection.getStringList("lore") : null;
            List quantityInputLore = quantityInput != null ? quantityInput.getStringList("lore") : null;
            List priceInputLore = priceInput != null ? priceInput.getStringList("lore") : null;
            return new MenuMessages(PlayerShopMessages.translate(section.getString("inventory-title", PlayerShopMessages.DEFAULT_MENU_INVENTORY_TITLE)), PlayerShopMessages.translate(confirmSection != null ? confirmSection.getString("name", PlayerShopMessages.DEFAULT_MENU_CONFIRM_BUTTON_NAME) : PlayerShopMessages.DEFAULT_MENU_CONFIRM_BUTTON_NAME), PlayerShopMessages.translateList(confirmLore, DEFAULT_MENU_CONFIRM_BUTTON_LORE), PlayerShopMessages.translate(selectSection != null ? selectSection.getString("name", PlayerShopMessages.DEFAULT_MENU_SELECT_ITEM_NAME) : PlayerShopMessages.DEFAULT_MENU_SELECT_ITEM_NAME), PlayerShopMessages.translateList(selectLore, DEFAULT_MENU_SELECT_ITEM_LORE), PlayerShopMessages.translate(section.getString("item-selected-clear-hint", PlayerShopMessages.DEFAULT_MENU_ITEM_SELECTED_CLEAR_HINT)), PlayerShopMessages.translate(quantityDisplay != null ? quantityDisplay.getString("name", PlayerShopMessages.DEFAULT_MENU_QUANTITY_NAME) : PlayerShopMessages.DEFAULT_MENU_QUANTITY_NAME), PlayerShopMessages.translate(quantityDisplay != null ? quantityDisplay.getString("value-format", PlayerShopMessages.DEFAULT_MENU_QUANTITY_VALUE_FORMAT) : PlayerShopMessages.DEFAULT_MENU_QUANTITY_VALUE_FORMAT), PlayerShopMessages.translate(priceDisplay != null ? priceDisplay.getString("name", PlayerShopMessages.DEFAULT_MENU_PRICE_NAME) : PlayerShopMessages.DEFAULT_MENU_PRICE_NAME), PlayerShopMessages.translate(priceDisplay != null ? priceDisplay.getString("value-format", PlayerShopMessages.DEFAULT_MENU_PRICE_VALUE_FORMAT) : PlayerShopMessages.DEFAULT_MENU_PRICE_VALUE_FORMAT), PlayerShopMessages.translate(quantityInput != null ? quantityInput.getString("name", PlayerShopMessages.DEFAULT_MENU_QUANTITY_TYPE_NAME) : PlayerShopMessages.DEFAULT_MENU_QUANTITY_TYPE_NAME), PlayerShopMessages.translateList(quantityInputLore, DEFAULT_MENU_QUANTITY_TYPE_LORE), PlayerShopMessages.translate(priceInput != null ? priceInput.getString("name", PlayerShopMessages.DEFAULT_MENU_PRICE_TYPE_NAME) : PlayerShopMessages.DEFAULT_MENU_PRICE_TYPE_NAME), PlayerShopMessages.translateList(priceInputLore, DEFAULT_MENU_PRICE_TYPE_LORE), PlayerShopMessages.translate(quantityAdjust != null ? quantityAdjust.getString("minus-one", "&c-1") : "&c-1"), PlayerShopMessages.translate(quantityAdjust != null ? quantityAdjust.getString("minus-sixteen", PlayerShopMessages.DEFAULT_MENU_QUANTITY_MINUS_SIXTEEN) : PlayerShopMessages.DEFAULT_MENU_QUANTITY_MINUS_SIXTEEN), PlayerShopMessages.translate(quantityAdjust != null ? quantityAdjust.getString("plus-sixteen", PlayerShopMessages.DEFAULT_MENU_QUANTITY_PLUS_SIXTEEN) : PlayerShopMessages.DEFAULT_MENU_QUANTITY_PLUS_SIXTEEN), PlayerShopMessages.translate(quantityAdjust != null ? quantityAdjust.getString("plus-one", "&a+1") : "&a+1"), PlayerShopMessages.translate(priceAdjust != null ? priceAdjust.getString("minus-one", "&c-1") : "&c-1"), PlayerShopMessages.translate(priceAdjust != null ? priceAdjust.getString("minus-ten", PlayerShopMessages.DEFAULT_MENU_PRICE_MINUS_TEN) : PlayerShopMessages.DEFAULT_MENU_PRICE_MINUS_TEN), PlayerShopMessages.translate(priceAdjust != null ? priceAdjust.getString("plus-ten", PlayerShopMessages.DEFAULT_MENU_PRICE_PLUS_TEN) : PlayerShopMessages.DEFAULT_MENU_PRICE_PLUS_TEN), PlayerShopMessages.translate(priceAdjust != null ? priceAdjust.getString("plus-one", "&a+1") : "&a+1"), PlayerShopMessages.translate(section.getString("item-description-format", PlayerShopMessages.DEFAULT_MENU_ITEM_DESCRIPTION_FORMAT)), PlayerShopMessages.translate(unknownItem != null ? unknownItem.getString("singular", PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_SINGULAR) : PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_SINGULAR), PlayerShopMessages.translate(unknownItem != null ? unknownItem.getString("plural", PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_PLURAL) : PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_PLURAL));
        }

        public static MenuMessages defaults() {
            return new MenuMessages(PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_INVENTORY_TITLE), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_CONFIRM_BUTTON_NAME), PlayerShopMessages.translateList(DEFAULT_MENU_CONFIRM_BUTTON_LORE, DEFAULT_MENU_CONFIRM_BUTTON_LORE), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_SELECT_ITEM_NAME), PlayerShopMessages.translateList(DEFAULT_MENU_SELECT_ITEM_LORE, DEFAULT_MENU_SELECT_ITEM_LORE), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_ITEM_SELECTED_CLEAR_HINT), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_QUANTITY_NAME), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_QUANTITY_VALUE_FORMAT), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_PRICE_NAME), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_PRICE_VALUE_FORMAT), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_QUANTITY_TYPE_NAME), PlayerShopMessages.translateList(DEFAULT_MENU_QUANTITY_TYPE_LORE, DEFAULT_MENU_QUANTITY_TYPE_LORE), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_PRICE_TYPE_NAME), PlayerShopMessages.translateList(DEFAULT_MENU_PRICE_TYPE_LORE, DEFAULT_MENU_PRICE_TYPE_LORE), PlayerShopMessages.translate("&c-1"), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_QUANTITY_MINUS_SIXTEEN), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_QUANTITY_PLUS_SIXTEEN), PlayerShopMessages.translate("&a+1"), PlayerShopMessages.translate("&c-1"), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_PRICE_MINUS_TEN), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_PRICE_PLUS_TEN), PlayerShopMessages.translate("&a+1"), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_ITEM_DESCRIPTION_FORMAT), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_SINGULAR), PlayerShopMessages.translate(PlayerShopMessages.DEFAULT_MENU_UNKNOWN_ITEM_PLURAL));
        }

        public String inventoryTitle() {
            return this.inventoryTitle;
        }

        public String confirmButtonName() {
            return this.confirmButtonName;
        }

        public List<String> confirmButtonLore() {
            return this.confirmButtonLore;
        }

        public String selectItemName() {
            return this.selectItemName;
        }

        public List<String> selectItemLore() {
            return this.selectItemLore;
        }

        public String itemSelectedClearHint() {
            return this.itemSelectedClearHint;
        }

        public String quantityName() {
            return this.quantityName;
        }

        public String quantityValue(int amount) {
            return PlayerShopMessages.format(this.quantityValueFormat, "amount", Integer.toString(amount));
        }

        public String priceName() {
            return this.priceName;
        }

        public String priceValue(String price) {
            return PlayerShopMessages.format(this.priceValueFormat, "price", Objects.toString(price, ""));
        }

        public String quantityTypeName() {
            return this.quantityTypeName;
        }

        public List<String> quantityTypeLore() {
            return this.quantityTypeLore;
        }

        public String priceTypeName() {
            return this.priceTypeName;
        }

        public List<String> priceTypeLore() {
            return this.priceTypeLore;
        }

        public String quantityMinusOneLabel() {
            return this.quantityMinusOneLabel;
        }

        public String quantityMinusSixteenLabel() {
            return this.quantityMinusSixteenLabel;
        }

        public String quantityPlusSixteenLabel() {
            return this.quantityPlusSixteenLabel;
        }

        public String quantityPlusOneLabel() {
            return this.quantityPlusOneLabel;
        }

        public String priceMinusOneLabel() {
            return this.priceMinusOneLabel;
        }

        public String priceMinusTenLabel() {
            return this.priceMinusTenLabel;
        }

        public String pricePlusTenLabel() {
            return this.pricePlusTenLabel;
        }

        public String pricePlusOneLabel() {
            return this.pricePlusOneLabel;
        }

        public String itemDescription(int amount, String itemName) {
            return PlayerShopMessages.format(this.itemDescriptionFormat, "amount", Integer.toString(amount), "item", Objects.toString(itemName, ""));
        }

        public String unknownItemDescription(int amount) {
            String itemName = amount == 1 ? this.unknownItemSingular : this.unknownItemPlural;
            return PlayerShopMessages.format(this.itemDescriptionFormat, "amount", Integer.toString(amount), "item", Objects.toString(itemName, ""));
        }

        public String unknownItemSingularPlain() {
            return ChatColor.stripColor((String)Objects.toString(this.unknownItemSingular, ""));
        }
    }
}

