/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.playershop;

import com.skyblockexp.ezshops.config.PlayerShopConfiguration;
import com.skyblockexp.ezshops.playershop.PlayerShop;
import com.skyblockexp.ezshops.playershop.PlayerShopCreationResult;
import com.skyblockexp.ezshops.playershop.PlayerShopMessages;
import com.skyblockexp.ezshops.playershop.PlayerShopSetup;
import com.skyblockexp.ezshops.repository.PlayerShopRepository;
import com.skyblockexp.ezshops.shop.ShopTransactionResult;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerShopManager {
    public static final String PERMISSION_CREATE = "ezshops.playershop.create";
    public static final String PERMISSION_ADMIN = "ezshops.playershop.admin";
    public static final String PERMISSION_BUY = "ezshops.playershop.buy";
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance(Locale.US);
    private final JavaPlugin plugin;
    private final Economy economy;
    private final PlayerShopConfiguration configuration;
    private final PlayerShopMessages messages;
    private final PlayerShopRepository repository;
    private final Map<String, PlayerShop> shopsBySign;
    private final Map<String, PlayerShop> shopsByChest;
    private final Map<UUID, PlayerShopSetup> pendingSetups;

    public PlayerShopManager(JavaPlugin plugin, Economy economy, PlayerShopConfiguration configuration, PlayerShopRepository repository) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.economy = economy;
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.messages = configuration.messages();
        this.repository = Objects.requireNonNull(repository, "repository");
        this.shopsBySign = new HashMap<String, PlayerShop>();
        this.shopsByChest = new HashMap<String, PlayerShop>();
        this.pendingSetups = new HashMap<UUID, PlayerShopSetup>();
    }

    public void enable() {
        this.loadShops();
    }

    public void disable() {
        this.saveShops();
        this.shopsBySign.clear();
        this.shopsByChest.clear();
        this.pendingSetups.clear();
    }

    private void loadShops() {
        this.shopsBySign.clear();
        this.shopsByChest.clear();
        Collection<PlayerShop> shops = this.repository.loadShops();
        for (PlayerShop shop : shops) {
            this.registerShop(shop);
            this.refreshSign(shop);
        }
    }

    private void registerShop(PlayerShop shop) {
        this.shopsBySign.put(this.repository.locationKey(shop.signLocation()), shop);
        for (Location chestLocation : shop.chestLocations()) {
            this.shopsByChest.put(this.repository.locationKey(chestLocation), shop);
        }
    }

    public Collection<PlayerShop> getShops() {
        return List.copyOf(this.shopsBySign.values());
    }

    public PlayerShop getShopBySign(Block block) {
        if (block == null) {
            return null;
        }
        return this.shopsBySign.get(this.repository.locationKey(block.getLocation()));
    }

    public PlayerShop getShopBySign(Location location) {
        if (location == null) {
            return null;
        }
        return this.shopsBySign.get(this.repository.locationKey(location));
    }

    public PlayerShop getShopByChest(Block block) {
        if (block == null) {
            return null;
        }
        return this.shopsByChest.get(this.repository.locationKey(block.getLocation()));
    }

    public PlayerShop getShopByChest(Location location) {
        if (location == null) {
            return null;
        }
        return this.shopsByChest.get(this.repository.locationKey(location));
    }

    public PlayerShopSetup getPendingSetup(UUID playerId) {
        if (playerId == null) {
            return null;
        }
        return this.pendingSetups.get(playerId);
    }

    public void setPendingSetup(UUID playerId, PlayerShopSetup setup) {
        if (playerId == null || setup == null) {
            return;
        }
        this.pendingSetups.put(playerId, this.normalizeSetup(setup));
    }

    public void clearPendingSetup(UUID playerId) {
        if (playerId == null) {
            return;
        }
        this.pendingSetups.remove(playerId);
    }

    public PlayerShopSetup normalizeSetup(PlayerShopSetup setup) {
        if (setup == null) {
            return null;
        }
        int quantity = Math.max(this.configuration.minQuantity(), setup.quantity());
        if (this.configuration.maxQuantity() > 0) {
            quantity = Math.min(this.configuration.maxQuantity(), quantity);
        }
        quantity = Math.max(1, quantity);
        double minimumPrice = this.configuration.minPrice() > 0.0 ? this.configuration.minPrice() : 0.01;
        double price = Math.max(minimumPrice, setup.price());
        if (this.configuration.maxPrice() > 0.0) {
            price = Math.min(this.configuration.maxPrice(), price);
        }
        return new PlayerShopSetup(quantity, price, setup.itemTemplate());
    }

    public PlayerShopCreationResult createShop(Player owner, Block signBlock, Block attachedBlock, int quantity, double price) {
        if (owner == null || signBlock == null || attachedBlock == null) {
            return PlayerShopCreationResult.failure(this.messages.creationInvalidConfiguration());
        }
        if (quantity <= 0) {
            return PlayerShopCreationResult.failure(this.messages.creationQuantityPositive());
        }
        if (quantity < this.configuration.minQuantity()) {
            return PlayerShopCreationResult.failure(this.messages.creationQuantityMin(this.configuration.minQuantity()));
        }
        if (this.configuration.maxQuantity() > 0 && quantity > this.configuration.maxQuantity()) {
            return PlayerShopCreationResult.failure(this.messages.creationQuantityMax(this.configuration.maxQuantity()));
        }
        if (price <= 0.0) {
            return PlayerShopCreationResult.failure(this.messages.creationPricePositive());
        }
        if (price < this.configuration.minPrice()) {
            return PlayerShopCreationResult.failure(this.messages.creationPriceMin(this.formatCurrency(this.configuration.minPrice())));
        }
        if (this.configuration.maxPrice() > 0.0 && price > this.configuration.maxPrice()) {
            return PlayerShopCreationResult.failure(this.messages.creationPriceMax(this.formatCurrency(this.configuration.maxPrice())));
        }
        if (this.getShopBySign(signBlock) != null) {
            return PlayerShopCreationResult.failure(this.messages.creationSignInUse());
        }
        if (!this.isContainer(attachedBlock)) {
            return PlayerShopCreationResult.failure(this.messages.signRequiresChest());
        }
        List<Location> chestLocations = this.resolveChestLocations(attachedBlock);
        if (chestLocations.isEmpty()) {
            return PlayerShopCreationResult.failure(this.messages.creationChestUnresolved());
        }
        for (Location chestLocation : chestLocations) {
            if (this.getShopByChest(chestLocation) == null) continue;
            return PlayerShopCreationResult.failure(this.messages.creationChestInUse());
        }
        Inventory chestInventory = this.getInventory(attachedBlock);
        if (chestInventory == null) {
            return PlayerShopCreationResult.failure(this.messages.creationChestInaccessible());
        }
        PlayerShopSetup pendingSetup = this.normalizeSetup(this.getPendingSetup(owner.getUniqueId()));
        ItemStack template = null;
        if (pendingSetup != null) {
            template = pendingSetup.itemTemplate();
        }
        if (template != null) {
            if ((template = this.findMatchingItem(chestInventory, template)) == null) {
                return PlayerShopCreationResult.failure(this.messages.creationSelectedItemMissing());
            }
        } else {
            template = this.findTemplateItem(chestInventory);
            if (template == null) {
                return PlayerShopCreationResult.failure(this.messages.creationItemMissing());
            }
        }
        if (this.configuration.requireStockOnCreation() && this.countItems(chestInventory, template) < quantity) {
            return PlayerShopCreationResult.failure(this.messages.creationInsufficientStock());
        }
        PlayerShop shop = new PlayerShop(owner.getUniqueId(), signBlock.getLocation(), attachedBlock.getLocation(), chestLocations, template, quantity, price);
        this.registerShop(shop);
        this.refreshSign(shop);
        this.saveShops();
        return PlayerShopCreationResult.success(this.messages.creationSuccess(), shop);
    }

    public ShopTransactionResult purchase(PlayerShop shop, Player buyer) {
        Player ownerPlayer;
        String ownerName;
        if (shop == null || buyer == null) {
            return ShopTransactionResult.failure(this.messages.purchaseInvalid());
        }
        if (!buyer.hasPermission(PERMISSION_BUY)) {
            return ShopTransactionResult.failure(this.messages.purchaseNoPermission());
        }
        if (this.economy == null) {
            return ShopTransactionResult.failure(this.messages.purchaseNoEconomy());
        }
        if (buyer.getUniqueId().equals(shop.ownerId())) {
            return ShopTransactionResult.failure(this.messages.purchaseOwnShop());
        }
        Inventory inventory = this.getInventory(shop.primaryChestLocation());
        if (inventory == null) {
            this.removeShop(shop);
            this.saveShops();
            return ShopTransactionResult.failure(this.messages.purchaseMissingChest());
        }
        ItemStack template = shop.itemTemplate();
        int available = this.countItems(inventory, template);
        if (available < shop.quantityPerSale()) {
            this.refreshSign(shop);
            return ShopTransactionResult.failure(this.messages.purchaseOutOfStock());
        }
        ItemStack toGive = template.clone();
        toGive.setAmount(shop.quantityPerSale());
        if (!this.hasInventorySpace(buyer, toGive)) {
            return ShopTransactionResult.failure(this.messages.purchaseNoSpace());
        }
        double price = shop.price();
        EconomyResponse withdraw = this.economy.withdrawPlayer((OfflinePlayer)buyer, price);
        if (!withdraw.transactionSuccess()) {
            return ShopTransactionResult.failure(this.messages.purchaseTransactionFailed(withdraw.errorMessage));
        }
        this.removeItems(inventory, template, shop.quantityPerSale());
        HashMap leftovers = buyer.getInventory().addItem(new ItemStack[]{toGive});
        int deliveredAmount = shop.quantityPerSale();
        if (!leftovers.isEmpty()) {
            deliveredAmount -= leftovers.values().stream().filter(Objects::nonNull).mapToInt(ItemStack::getAmount).sum();
        }
        if (deliveredAmount < shop.quantityPerSale()) {
            int amountToReturn = shop.quantityPerSale() - deliveredAmount;
            this.addItems(inventory, template, amountToReturn);
            this.economy.depositPlayer((OfflinePlayer)buyer, price);
            this.removeItems((Inventory)buyer.getInventory(), template, deliveredAmount);
            this.refreshSign(shop);
            return ShopTransactionResult.failure(this.messages.purchaseNoSpace());
        }
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)shop.ownerId());
        EconomyResponse deposit = this.economy.depositPlayer(owner, price);
        if (!deposit.transactionSuccess()) {
            this.removeItems((Inventory)buyer.getInventory(), template, shop.quantityPerSale());
            this.addItems(inventory, template, shop.quantityPerSale());
            this.economy.depositPlayer((OfflinePlayer)buyer, price);
            this.refreshSign(shop);
            return ShopTransactionResult.failure(this.messages.purchaseTransactionFailed(deposit.errorMessage));
        }
        this.refreshSign(shop);
        String string = ownerName = owner != null ? owner.getName() : this.messages.unknownSellerName();
        if (ownerName == null || ownerName.isEmpty()) {
            ownerName = this.messages.unknownSellerName();
        }
        String itemName = this.describeItem(template, shop.quantityPerSale());
        if (owner != null && owner.isOnline() && (ownerPlayer = owner.getPlayer()) != null) {
            ownerPlayer.sendMessage(this.messages.purchaseOwnerNotify(buyer.getName(), itemName, this.formatCurrency(price)));
        }
        return ShopTransactionResult.success(this.messages.purchaseBuyerSuccess(itemName, ownerName, this.formatCurrency(price)));
    }

    public void removeShop(PlayerShop shop) {
        if (shop == null) {
            return;
        }
        this.shopsBySign.remove(this.repository.locationKey(shop.signLocation()));
        for (Location chestLocation : shop.chestLocations()) {
            this.shopsByChest.remove(this.repository.locationKey(chestLocation));
        }
    }

    public boolean removeShopBySign(Location location) {
        PlayerShop shop = this.getShopBySign(location);
        if (shop == null) {
            return false;
        }
        this.removeShop(shop);
        this.saveShops();
        return true;
    }

    public boolean removeShopByChest(Location location) {
        PlayerShop shop = this.getShopByChest(location);
        if (shop == null) {
            return false;
        }
        this.removeShop(shop);
        this.saveShops();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void refreshSign(PlayerShop shop) {
        void sign;
        if (shop == null) {
            return;
        }
        Location signLocation = shop.signLocation();
        Block signBlock = signLocation.getBlock();
        BlockState state = signBlock.getState();
        if (!(state instanceof Sign)) {
            this.removeShop(shop);
            this.saveShops();
            return;
        }
        Sign sign2 = (Sign)state;
        Inventory inventory = this.getInventory(shop.primaryChestLocation());
        ItemStack template = shop.itemTemplate();
        boolean hasStock = inventory != null && this.countItems(inventory, template) >= shop.quantityPerSale();
        String[] lines = this.formatSignLines(shop, hasStock);
        int i = 0;
        while (i < lines.length && i < sign.getLines().length) {
            sign.setLine(i, lines[i]);
            ++i;
        }
        sign.update();
    }

    public String[] formatSignLines(PlayerShop shop, boolean hasStock) {
        PlayerShopConfiguration.SignFormat signFormat = this.configuration.signFormat();
        String ownerName = Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)shop.ownerId()).getName()).filter(name -> !name.isBlank()).orElse(signFormat.unknownOwnerName());
        ItemStack template = shop.itemTemplate();
        String itemName = this.friendlyItemName(template.getType());
        String priceText = this.formatCurrency(shop.price());
        return signFormat.formatLines(ownerName, shop.quantityPerSale(), itemName, priceText, hasStock);
    }

    public void saveShops() {
        this.repository.saveShops(this.shopsBySign, this.repository.getDeferredEntries());
    }

    private List<Location> resolveChestLocations(Block block) {
        InventoryHolder holder;
        Inventory inventory;
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(block.getLocation());
        BlockState state = block.getState();
        if (state instanceof InventoryHolder && (inventory = (holder = (InventoryHolder)state).getInventory()) != null) {
            InventoryHolder inventoryHolder = inventory.getHolder();
            if (inventoryHolder instanceof DoubleChest) {
                DoubleChest doubleChest = (DoubleChest)inventoryHolder;
                this.addChestLocation(locations, doubleChest.getLeftSide());
                this.addChestLocation(locations, doubleChest.getRightSide());
            } else {
                try {
                    Class<?> barrelClass = Class.forName("org.bukkit.block.Barrel");
                    if (barrelClass.isInstance(inventoryHolder)) {
                        BlockState barrelState = (BlockState)inventoryHolder;
                        locations.add(barrelState.getLocation());
                    } else {
                        locations.add(block.getLocation());
                    }
                }
                catch (ClassNotFoundException ignored) {
                    locations.add(block.getLocation());
                }
            }
        }
        HashSet<String> unique = new HashSet<String>();
        ArrayList<Location> deduplicated = new ArrayList<Location>();
        for (Location location : locations) {
            String key = this.repository.locationKey(location);
            if (key.isEmpty() || !unique.add(key)) continue;
            deduplicated.add(location);
        }
        return deduplicated;
    }

    private void addChestLocation(List<Location> locations, InventoryHolder holder) {
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            locations.add(chest.getLocation());
        } else {
            try {
                Class<?> barrelClass = Class.forName("org.bukkit.block.Barrel");
                if (barrelClass.isInstance(holder)) {
                    BlockState state = (BlockState)holder;
                    locations.add(state.getLocation());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private boolean isContainer(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        if (type == Material.CHEST || type == Material.TRAPPED_CHEST) {
            return true;
        }
        try {
            if (Material.valueOf((String)"BARREL") == type) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private Inventory getInventory(Location location) {
        if (location == null) {
            return null;
        }
        return this.getInventory(location.getBlock());
    }

    private Inventory getInventory(Block block) {
        if (block == null) {
            return null;
        }
        BlockState state = block.getState();
        if (state instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)state;
            return holder.getInventory();
        }
        try {
            Class<?> barrelClass = Class.forName("org.bukkit.block.Barrel");
            if (barrelClass.isInstance(state)) {
                return ((InventoryHolder)state).getInventory();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private ItemStack findTemplateItem(Inventory inventory) {
        if (inventory == null) {
            return null;
        }
        ItemStack[] itemStackArray = inventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != Material.AIR) {
                ItemStack template = item.clone();
                template.setAmount(1);
                return template;
            }
            ++n2;
        }
        return null;
    }

    private ItemStack findMatchingItem(Inventory inventory, ItemStack template) {
        if (inventory == null || template == null) {
            return null;
        }
        ItemStack[] itemStackArray = inventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != Material.AIR && item.isSimilar(template)) {
                ItemStack clone = item.clone();
                clone.setAmount(1);
                return clone;
            }
            ++n2;
        }
        return null;
    }

    private int countItems(Inventory inventory, ItemStack template) {
        if (inventory == null || template == null) {
            return 0;
        }
        int total = 0;
        ItemStack[] itemStackArray = inventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() != Material.AIR && item.isSimilar(template)) {
                total += item.getAmount();
            }
            ++n2;
        }
        return total;
    }

    private void removeItems(Inventory inventory, ItemStack template, int amount) {
        if (inventory == null || template == null || amount <= 0) {
            return;
        }
        int remaining = amount;
        int i = 0;
        while (i < inventory.getSize() && remaining > 0) {
            ItemStack stack = inventory.getItem(i);
            if (stack != null && stack.getType() != Material.AIR && stack.isSimilar(template)) {
                int stackAmount = stack.getAmount();
                if (stackAmount <= remaining) {
                    inventory.setItem(i, null);
                    remaining -= stackAmount;
                } else {
                    stack.setAmount(stackAmount - remaining);
                    inventory.setItem(i, stack);
                    remaining = 0;
                }
            }
            ++i;
        }
    }

    private void addItems(Inventory inventory, ItemStack template, int amount) {
        if (inventory == null || template == null || amount <= 0) {
            return;
        }
        ItemStack toAdd = template.clone();
        toAdd.setAmount(amount);
        inventory.addItem(new ItemStack[]{toAdd});
    }

    private boolean hasInventorySpace(Player player, ItemStack item) {
        if (player == null || item == null) {
            return false;
        }
        int remaining = item.getAmount();
        int stackLimit = Math.min(item.getMaxStackSize(), player.getInventory().getMaxStackSize());
        ItemStack[] itemStackArray = player.getInventory().getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack content = itemStackArray[n2];
            if (remaining <= 0) break;
            if (content == null || content.getType() == Material.AIR) {
                remaining -= stackLimit;
            } else if (content.isSimilar(item)) {
                int contentLimit = Math.min(stackLimit, content.getMaxStackSize());
                remaining -= Math.max(0, contentLimit - content.getAmount());
            }
            ++n2;
        }
        return remaining <= 0;
    }

    private String friendlyItemName(Material material) {
        return material == null ? "Item" : this.capitalize(material.name().replace('_', ' ').toLowerCase(Locale.US));
    }

    private String describeItem(ItemStack item, int amount) {
        if (item == null) {
            return this.messages.menu().unknownItemDescription(amount);
        }
        ItemMeta meta = item.getItemMeta();
        Object itemName = meta != null && meta.hasDisplayName() ? meta.getDisplayName() : String.valueOf(ChatColor.AQUA) + this.friendlyItemName(item.getType());
        return this.messages.menu().itemDescription(amount, (String)itemName);
    }

    private String capitalize(String text) {
        String[] parts = text.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
            }
            ++n2;
        }
        return builder.length() == 0 ? text : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatCurrency(double value) {
        NumberFormat numberFormat = CURRENCY_FORMAT;
        synchronized (numberFormat) {
            return CURRENCY_FORMAT.format(value);
        }
    }
}

