/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.playershop;

import com.skyblockexp.ezshops.config.PlayerShopConfiguration;
import com.skyblockexp.ezshops.playershop.PlayerShop;
import com.skyblockexp.ezshops.playershop.PlayerShopCreationResult;
import com.skyblockexp.ezshops.playershop.PlayerShopManager;
import com.skyblockexp.ezshops.playershop.PlayerShopMessages;
import com.skyblockexp.ezshops.playershop.PlayerShopSetup;
import com.skyblockexp.ezshops.shop.ShopTransactionResult;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class PlayerShopListener
implements Listener {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private final PlayerShopManager manager;
    private final PlayerShopConfiguration configuration;
    private final PlayerShopMessages messages;

    public PlayerShopListener(PlayerShopManager manager, PlayerShopConfiguration configuration) {
        this.manager = Objects.requireNonNull(manager, "manager");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.messages = configuration.messages();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        String firstLine = event.getLine(0);
        if (firstLine == null || !this.configuration.isHeaderToken(firstLine)) {
            return;
        }
        if (!player.hasPermission("ezshops.playershop.create")) {
            player.sendMessage(this.messages.noPermissionCreate());
            event.setLine(0, this.failureHeader());
            return;
        }
        PlayerShopSetup pendingSetup = this.manager.normalizeSetup(this.manager.getPendingSetup(player.getUniqueId()));
        Block signBlock = event.getBlock();
        Block attachedBlock = this.getAttachedBlock(signBlock);
        if (attachedBlock == null || attachedBlock.getType() == Material.AIR) {
            player.sendMessage(this.messages.signRequiresChest());
            event.setLine(0, this.failureHeader());
            return;
        }
        int quantity = this.parseQuantity(event.getLine(1));
        double price = this.parsePrice(event.getLine(2));
        if (quantity <= 0 && pendingSetup != null) {
            quantity = pendingSetup.quantity();
        }
        if (price <= 0.0 && pendingSetup != null) {
            price = pendingSetup.price();
        }
        if (quantity <= 0) {
            player.sendMessage(this.messages.enterQuantity());
            event.setLine(1, this.messages.quantityPrompt());
            return;
        }
        if (price <= 0.0) {
            player.sendMessage(this.messages.enterPrice());
            event.setLine(2, this.messages.pricePrompt());
            return;
        }
        PlayerShopCreationResult result = this.manager.createShop(player, signBlock, attachedBlock, quantity, price);
        if (!result.success()) {
            player.sendMessage(result.message());
            event.setLine(0, this.failureHeader());
            return;
        }
        PlayerShop shop = result.shop();
        String[] lines = this.manager.formatSignLines(shop, true);
        int i = 0;
        while (i < lines.length && i < 4) {
            event.setLine(i, lines[i]);
            ++i;
        }
        player.sendMessage(result.message());
        if (pendingSetup != null) {
            player.sendMessage(this.messages.usingSavedSettings());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock() == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock.getState() instanceof Sign) {
            PlayerShop shop = this.manager.getShopBySign(clickedBlock.getLocation());
            if (shop == null) {
                return;
            }
            event.setCancelled(true);
            ShopTransactionResult result = this.manager.purchase(shop, player);
            player.sendMessage(result.message());
            return;
        }
        PlayerShop shop = this.manager.getShopByChest(clickedBlock.getLocation());
        if (shop == null) {
            return;
        }
        if (shop.ownerId().equals(player.getUniqueId())) {
            return;
        }
        if (player.hasPermission("ezshops.playershop.admin")) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.messages.chestAccessDenied());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        PlayerShop shop = this.manager.getShopBySign(block.getLocation());
        if (shop == null) {
            shop = this.manager.getShopByChest(block.getLocation());
        }
        if (shop == null) {
            return;
        }
        Player player = event.getPlayer();
        boolean isOwner = shop.ownerId().equals(player.getUniqueId());
        if (!isOwner && !player.hasPermission("ezshops.playershop.admin")) {
            player.sendMessage(this.messages.breakDenied());
            event.setCancelled(true);
            return;
        }
        this.manager.removeShop(shop);
        this.manager.saveShops();
        player.sendMessage(this.messages.shopRemoved());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)holder;
            this.updateChestShop(doubleChest.getLeftSide());
            this.updateChestShop(doubleChest.getRightSide());
        } else if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            this.updateChestShop((InventoryHolder)chest);
        }
    }

    private void updateChestShop(InventoryHolder holder) {
        Chest chest;
        PlayerShop shop;
        if (holder instanceof Chest && (shop = this.manager.getShopByChest((chest = (Chest)holder).getLocation())) != null) {
            this.manager.refreshSign(shop);
        }
    }

    private Block getAttachedBlock(Block signBlock) {
        if (signBlock == null) {
            return null;
        }
        BlockData data = signBlock.getBlockData();
        if (data instanceof WallSign) {
            WallSign wallSign = (WallSign)data;
            BlockFace face = wallSign.getFacing().getOppositeFace();
            return signBlock.getRelative(face);
        }
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            BlockFace face = directional.getFacing().getOppositeFace();
            return signBlock.getRelative(face);
        }
        return null;
    }

    private int parseQuantity(String text) {
        if (text == null) {
            return -1;
        }
        if ((text = ChatColor.stripColor((String)text).trim()).isEmpty()) {
            return -1;
        }
        if (text.startsWith("x") || text.startsWith("X")) {
            text = text.substring(1);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private double parsePrice(String text) {
        if (text == null) {
            return -1.0;
        }
        if ((text = ChatColor.stripColor((String)text).replaceAll("[^0-9.,]", "")).isEmpty()) {
            return -1.0;
        }
        try {
            Number number = NUMBER_FORMAT.parse(text);
            return number != null ? number.doubleValue() : -1.0;
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    private String failureHeader() {
        String base = ChatColor.stripColor((String)this.configuration.signFormat().availableHeader());
        if (base == null || base.isEmpty()) {
            base = "[PlayerShop]";
        }
        return String.valueOf(ChatColor.RED) + base;
    }
}

