/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.gui.stock.AllStocksGui;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.stock.StockManager;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.RegisteredServiceProvider;

public class StockTransactionConfirmGui {
    private static final int GUI_SIZE = 27;

    public static void open(Player player, String productId, TransactionType type, StockMarketManager stockMarketManager, AllStocksGui returnGui, int returnPage, String returnFilter) {
        StockTransactionConfirmGui.openWithContext(player, productId, type, stockMarketManager, returnGui, null, returnPage, returnFilter);
    }

    public static void openWithOverview(Player player, String productId, TransactionType type, StockMarketManager stockMarketManager, StockOverviewGui returnOverview) {
        StockTransactionConfirmGui.openWithContext(player, productId, type, stockMarketManager, null, returnOverview, 1, "all");
    }

    private static void openWithContext(Player player, String productId, TransactionType type, StockMarketManager stockMarketManager, AllStocksGui returnGui, StockOverviewGui returnOverview, int returnPage, String returnFilter) {
        double price = stockMarketManager.getPrice(productId);
        int ownedAmount = StockManager.getPlayerStockAmount(player, productId);
        String title = type == TransactionType.BUY ? String.valueOf(ChatColor.GREEN) + "Buy Stock" : String.valueOf(ChatColor.RED) + "Sell Stock";
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        int i = 0;
        while (i < 27) {
            inv.setItem(i, filler);
            ++i;
        }
        Material mat = Material.matchMaterial((String)productId);
        if (mat != null) {
            ItemStack displayItem = new ItemStack(mat);
            ItemMeta meta = displayItem.getItemMeta();
            String displayName = productId.charAt(0) + productId.substring(1).toLowerCase().replace('_', ' ');
            meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + displayName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Price per unit: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", price))));
            if (type == TransactionType.SELL) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "You own: " + String.valueOf(ChatColor.GREEN) + ownedAmount)));
            }
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
            inv.setItem(13, displayItem);
        }
        int[] amounts = new int[]{1, 8, 16, 32, 64};
        int[] slots = new int[]{10, 11, 12, 14, 15};
        int i2 = 0;
        while (i2 < amounts.length) {
            int amount = amounts[i2];
            double totalCost = price * (double)amount;
            if (type != TransactionType.SELL || amount <= ownedAmount) {
                Material buttonMat = type == TransactionType.BUY ? Material.LIME_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE;
                ItemStack button = new ItemStack(buttonMat, amount);
                ItemMeta buttonMeta = button.getItemMeta();
                if (type == TransactionType.BUY) {
                    buttonMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Buy " + amount);
                    buttonLore = new ArrayList<Object>();
                    buttonLore.add(String.valueOf(ChatColor.GRAY) + "Total cost: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", totalCost));
                    buttonLore.add("");
                    buttonLore.add(String.valueOf(ChatColor.YELLOW) + "Click to confirm purchase");
                    buttonMeta.setLore(buttonLore);
                } else {
                    buttonMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Sell " + amount);
                    buttonLore = new ArrayList();
                    buttonLore.add(String.valueOf(ChatColor.GRAY) + "Total value: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", totalCost));
                    buttonLore.add("");
                    buttonLore.add(String.valueOf(ChatColor.YELLOW) + "Click to confirm sale");
                    buttonMeta.setLore(buttonLore);
                }
                button.setItemMeta(buttonMeta);
                inv.setItem(slots[i2], button);
            }
            ++i2;
        }
        ItemStack cancel = new ItemStack(Material.BARRIER);
        ItemMeta cancelMeta = cancel.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        ArrayList<CallSite> cancelLore = new ArrayList<CallSite>();
        cancelLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Return to stock browser")));
        cancelMeta.setLore(cancelLore);
        cancel.setItemMeta(cancelMeta);
        inv.setItem(22, cancel);
        player.openInventory(inv);
    }

    public static boolean handleClick(Player player, Inventory inv, int slot, String productId, TransactionType type, StockMarketManager stockMarketManager, AllStocksGui returnGui, int returnPage, String returnFilter) {
        return StockTransactionConfirmGui.handleClick(player, inv, slot, productId, type, stockMarketManager, returnGui, null, returnPage, returnFilter);
    }

    public static boolean handleClick(Player player, Inventory inv, int slot, String productId, TransactionType type, StockMarketManager stockMarketManager, AllStocksGui returnGui, StockOverviewGui returnOverview, int returnPage, String returnFilter) {
        String title = ChatColor.stripColor((String)inv.getType().toString());
        if (slot == 22) {
            player.closeInventory();
            if (returnGui != null) {
                returnGui.open(player, returnPage, returnFilter);
            } else if (returnOverview != null) {
                returnOverview.open(player, returnFilter, returnPage);
            }
            return true;
        }
        int[] slots = new int[]{10, 11, 12, 14, 15};
        int[] amounts = new int[]{1, 8, 16, 32, 64};
        int i = 0;
        while (i < slots.length) {
            if (slot == slots[i]) {
                int amount = amounts[i];
                StockTransactionConfirmGui.processTransaction(player, productId, amount, type, stockMarketManager);
                player.closeInventory();
                if (returnGui != null) {
                    returnGui.open(player, returnPage, returnFilter);
                } else if (returnOverview != null) {
                    returnOverview.open(player, returnFilter, returnPage);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void processTransaction(Player player, String productId, int amount, TransactionType type, StockMarketManager stockMarketManager) {
        double price = stockMarketManager.getPrice(productId);
        double totalCost = price * (double)amount;
        RegisteredServiceProvider rsp = player.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Economy system not available.");
            return;
        }
        Economy econ = (Economy)rsp.getProvider();
        if (type == TransactionType.BUY) {
            if (econ.getBalance((OfflinePlayer)player) < totalCost) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Insufficient funds! You need " + String.format("%.2f", totalCost) + " but only have " + String.format("%.2f", econ.getBalance((OfflinePlayer)player)));
                return;
            }
            econ.withdrawPlayer((OfflinePlayer)player, totalCost);
            StockManager.addPlayerStock(player, productId, amount);
            stockMarketManager.updatePrice(productId, amount);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully bought " + amount + " " + productId + " for " + String.format("%.2f", totalCost));
        } else {
            int owned = StockManager.getPlayerStockAmount(player, productId);
            if (owned < amount) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough stock to sell! You have " + owned + " but tried to sell " + amount);
                return;
            }
            boolean removed = StockManager.removePlayerStock(player, productId, amount);
            if (removed) {
                econ.depositPlayer((OfflinePlayer)player, totalCost);
                stockMarketManager.updatePrice(productId, -amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully sold " + amount + " " + productId + " for " + String.format("%.2f", totalCost));
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to sell stock. Please try again.");
            }
        }
    }

    public static enum TransactionType {
        BUY,
        SELL;

    }
}

