/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.gui.stock.StockTransactionConfirmGui;
import com.skyblockexp.ezshops.stock.StockManager;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class StockOverviewGuiListener
implements Listener {
    private final StockMarketManager stockMarketManager;
    private final StockOverviewGui stockOverviewGui;

    public StockOverviewGuiListener(StockMarketManager stockMarketManager, StockOverviewGui stockOverviewGui) {
        this.stockMarketManager = stockMarketManager;
        this.stockOverviewGui = stockOverviewGui;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String productId;
        int owned;
        void player;
        String displayName;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        if (!event.getView().getTitle().contains(this.stockOverviewGui.getTitle())) {
            return;
        }
        if (this.stockOverviewGui.handleInventoryClick(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = displayName = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        if (displayName.contains(" - ")) {
            itemName = displayName.split(" - ")[0].trim();
        } else if (displayName.contains(":")) {
            itemName = displayName.split(":")[0].trim();
        } else if (displayName.contains(" ")) {
            itemName = displayName.split(" ")[0].trim();
        }
        if (event.isRightClick()) {
            this.stockOverviewGui.showHistory((Player)player, itemName);
            event.setCancelled(true);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && clickedItem.getType() != Material.AIR && (owned = StockManager.getPlayerStockAmount((Player)player, productId = clickedItem.getType().name())) > 0) {
            player.closeInventory();
            StockTransactionConfirmGui.openWithOverview((Player)player, productId, StockTransactionConfirmGui.TransactionType.SELL, this.stockMarketManager, this.stockOverviewGui);
        }
    }
}

