/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.common.MessageUtil;
import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.gui.stock.AllStocksGui;
import com.skyblockexp.ezshops.gui.stock.StockHistoryGui;
import com.skyblockexp.ezshops.stock.StockHistoryManager;
import com.skyblockexp.ezshops.stock.StockManager;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StockOverviewGui {
    private final StockMarketManager stockMarketManager;
    private final StockMarketConfig stockMarketConfig;
    private final StockMarketFrozenStore frozenStore;
    private final YamlConfiguration guiConfig;
    private final File guiConfigFile;
    private final int rows;
    private final String title;
    private final List<Map<String, String>> filters;
    private final Map<String, String> localization;
    private final Map<String, String> permissions;
    private final boolean debugMode;
    private final boolean seeAllStocksEnabled;
    private final int seeAllStocksSlot;
    private final Material seeAllStocksMaterial;
    private final String seeAllStocksDisplayName;
    private final List<String> seeAllStocksLore;

    public StockOverviewGui(StockMarketManager stockMarketManager, StockMarketConfig stockMarketConfig, StockMarketFrozenStore frozenStore, File configFile, boolean debugMode) {
        this.stockMarketManager = stockMarketManager;
        this.stockMarketConfig = stockMarketConfig;
        this.frozenStore = frozenStore;
        this.guiConfigFile = configFile;
        this.debugMode = debugMode;
        this.guiConfig = YamlConfiguration.loadConfiguration((File)configFile);
        this.rows = this.guiConfig.getInt("layout.rows", 6);
        this.title = MessageUtil.translateColors(this.guiConfig.getString("layout.title", "Stock Market Overview"));
        this.filters = new ArrayList<Map<String, String>>();
        List filterList = this.guiConfig.getList("filters");
        if (filterList != null) {
            for (Object obj : filterList) {
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                HashMap<String, String> f = new HashMap<String, String>();
                for (Map.Entry e : map.entrySet()) {
                    f.put(e.getKey().toString(), e.getValue().toString());
                }
                this.filters.add(f);
            }
        }
        this.localization = new HashMap<String, String>();
        if (this.guiConfig.isConfigurationSection("localization")) {
            Set keys = this.guiConfig.getConfigurationSection("localization").getKeys(false);
            for (Object key : keys) {
                this.localization.put((String)key, MessageUtil.translateColors(this.guiConfig.getString("localization." + (String)key)));
            }
        }
        if (!this.localization.containsKey("item-format")) {
            this.localization.put("item-format", "&e{item} &7- &6{price}");
        }
        this.permissions = new HashMap<String, String>();
        if (this.guiConfig.isConfigurationSection("permissions")) {
            for (String key : this.guiConfig.getConfigurationSection("permissions").getKeys(false)) {
                this.permissions.put(key, this.guiConfig.getString("permissions." + key));
            }
        }
        if (this.guiConfig.isConfigurationSection("see-all-stocks")) {
            ConfigurationSection section = this.guiConfig.getConfigurationSection("see-all-stocks");
            this.seeAllStocksEnabled = section.getBoolean("enabled", false);
            this.seeAllStocksSlot = section.getInt("slot", this.rows * 9 - 1);
            String matName = section.getString("material", "BOOK");
            Material mat = Material.matchMaterial((String)matName);
            this.seeAllStocksMaterial = mat != null ? mat : Material.BOOK;
            this.seeAllStocksDisplayName = MessageUtil.translateColors(section.getString("display-name", "&bSee All Stocks"));
            List loreList = section.getStringList("lore");
            if (loreList == null || loreList.isEmpty()) {
                this.seeAllStocksLore = Collections.singletonList(String.valueOf(ChatColor.GRAY) + "View all available stocks");
            } else {
                ArrayList<String> colored = new ArrayList<String>();
                for (String l : loreList) {
                    colored.add(MessageUtil.translateColors(l));
                }
                this.seeAllStocksLore = colored;
            }
        } else {
            this.seeAllStocksEnabled = false;
            this.seeAllStocksSlot = this.rows * 9 - 1;
            this.seeAllStocksMaterial = Material.BOOK;
            this.seeAllStocksDisplayName = MessageUtil.translateColors("&bSee All Stocks");
            this.seeAllStocksLore = Collections.singletonList(String.valueOf(ChatColor.GRAY) + "View all available stocks");
        }
    }

    public void open(Player player, String filter, int page) {
        if (!player.hasPermission(this.permissions.getOrDefault("view", "ezshops.stock.view"))) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view the stock market.");
            return;
        }
        List<String> ownedStocks = this.getPlayerOwnedStocks(player, filter);
        int pageSize = this.rows * 9 - 9;
        int totalPages = Math.max(1, (ownedStocks.size() + pageSize - 1) / pageSize);
        page = Math.max(1, Math.min(page, totalPages));
        String displayTitle = ownedStocks.isEmpty() ? this.title + " (No Stocks)" : this.title + " (" + page + "/" + totalPages + ")";
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(this.rows * 9), (String)displayTitle);
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, ownedStocks.size());
        int itemIndex = 0;
        int i = start;
        while (i < end) {
            String id = ownedStocks.get(i);
            Material mat = Material.matchMaterial((String)id);
            if (mat != null) {
                StockMarketConfig.OverrideItem override = this.stockMarketConfig.getOverride(id);
                double price = this.stockMarketManager.getPrice(id);
                Object displayName = override != null ? (override.display != null ? MessageUtil.translateColors(override.display) : id) : id.charAt(0) + id.substring(1).toLowerCase().replace('_', ' ');
                int owned = this.getPlayerStockAmount(player, id);
                double worth = (double)owned * this.stockMarketManager.getPrice(id);
                ItemStack item = new ItemStack(mat);
                ItemMeta meta = item.getItemMeta();
                String itemFormat = this.localize("item-format");
                String guiDisplayName = MessageUtil.translateColors(itemFormat).replace("{item}", (CharSequence)displayName).replace("{price}", String.format("%.2f", price));
                meta.setDisplayName(guiDisplayName);
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GREEN) + "Owned: " + String.valueOf(ChatColor.GOLD) + owned);
                lore.add(String.valueOf(ChatColor.GRAY) + "Total Value: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", worth));
                lore.add("");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click to sell");
                lore.add(String.valueOf(ChatColor.AQUA) + "Right-click for history");
                meta.setLore(lore);
                item.setItemMeta(meta);
                while (this.seeAllStocksEnabled && itemIndex == this.seeAllStocksSlot) {
                    ++itemIndex;
                }
                if (itemIndex < inv.getSize()) {
                    inv.setItem(itemIndex, item);
                    ++itemIndex;
                }
            }
            ++i;
        }
        if (this.seeAllStocksEnabled && this.seeAllStocksSlot < inv.getSize()) {
            ItemStack seeAll = new ItemStack(this.seeAllStocksMaterial);
            ItemMeta meta = seeAll.getItemMeta();
            meta.setDisplayName(this.seeAllStocksDisplayName);
            meta.setLore(this.seeAllStocksLore);
            seeAll.setItemMeta(meta);
            inv.setItem(this.seeAllStocksSlot, seeAll);
        }
        player.openInventory(inv);
    }

    public int getPlayerStockAmount(Player player, String productId) {
        return StockManager.getPlayerStockAmount(player, productId);
    }

    private List<String> getTradableProductIds(String filter) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : this.stockMarketManager.getAllProductIds()) {
            if (this.stockMarketConfig.isBlocked(id) || this.frozenStore.isFrozen(id)) continue;
            boolean matches = true;
            if (filter != null && !filter.equalsIgnoreCase("all") && !filter.isEmpty()) {
                String category = this.stockMarketConfig.getCategory(id);
                if (category == null || !category.equalsIgnoreCase(filter)) {
                    matches = false;
                }
                if (filter.startsWith("price:")) {
                    String[] parts = filter.substring(6).split("-");
                    try {
                        double min = Double.parseDouble(parts[0]);
                        double max = parts.length > 1 ? Double.parseDouble(parts[1]) : Double.MAX_VALUE;
                        double price = this.stockMarketManager.getPrice(id);
                        if (price < min || price > max) {
                            matches = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!matches) continue;
            ids.add(id);
        }
        return ids;
    }

    private List<String> getPlayerOwnedStocks(Player player, String filter) {
        List<String> ownedStocks = StockManager.getPlayerOwnedStocks(player);
        if (filter == null || filter.isEmpty() || filter.equalsIgnoreCase("all")) {
            return ownedStocks;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        String lowerFilter = filter.toLowerCase(Locale.ROOT);
        for (String id : ownedStocks) {
            String itemName = id.toLowerCase(Locale.ROOT).replace('_', ' ');
            if (!itemName.contains(lowerFilter)) continue;
            filtered.add(id);
        }
        return filtered;
    }

    public void showHistory(Player player, String productId) {
        List<StockHistoryManager.PriceEntry> history = this.stockMarketManager.getHistoryManager().getHistory(productId);
        if (history.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No price history for " + productId + ".");
            return;
        }
        StockHistoryGui.open(player, productId, history);
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleInventoryClick(InventoryClickEvent event) {
        void player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return false;
        }
        Player player2 = (Player)humanEntity;
        if (!this.seeAllStocksEnabled) {
            return false;
        }
        if (event.getSlot() != this.seeAllStocksSlot) {
            return false;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() != this.seeAllStocksMaterial) {
            return false;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || !this.seeAllStocksDisplayName.equals(meta.getDisplayName())) {
            return false;
        }
        event.setCancelled(true);
        AllStocksGui allStockGui = new AllStocksGui(this.stockMarketManager, this.stockMarketConfig, this.frozenStore, this.guiConfigFile);
        allStockGui.setStockOverviewGui(this);
        allStockGui.open((Player)player, 1);
        return true;
    }

    private String localize(String key) {
        return this.localization.getOrDefault(key, key);
    }

    public List<Map<String, String>> getFilters() {
        return this.filters;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isSeeAllStocksEnabled() {
        return this.seeAllStocksEnabled;
    }

    public int getSeeAllStocksSlot() {
        return this.seeAllStocksSlot;
    }

    public Material getSeeAllStocksMaterial() {
        return this.seeAllStocksMaterial;
    }

    public String getSeeAllStocksDisplayName() {
        return this.seeAllStocksDisplayName;
    }

    public List<String> getSeeAllStocksLore() {
        return this.seeAllStocksLore;
    }
}

