/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.gui.stock.StockHistoryGuiListener;
import com.skyblockexp.ezshops.stock.StockHistoryManager;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StockHistoryGui {
    private static final int GUI_SIZE = 54;
    private static final int ENTRIES_PER_PAGE = 28;
    private static StockHistoryGuiListener listener;

    public static void setListener(StockHistoryGuiListener l) {
        listener = l;
    }

    public static void open(Player player, String productId, List<StockHistoryManager.PriceEntry> history) {
        StockHistoryGui.open(player, productId, history, 0);
    }

    public static void open(Player player, String productId, List<StockHistoryManager.PriceEntry> history, int page) {
        int totalPages = Math.max(1, (int)Math.ceil((double)history.size() / 28.0));
        page = Math.max(0, Math.min(page, totalPages - 1));
        String itemName = StockHistoryGui.formatProductName(productId);
        String title = String.valueOf(ChatColor.GOLD) + "Price History: " + String.valueOf(ChatColor.YELLOW) + itemName;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        ItemStack border = new ItemStack(Material.BLUE_STAINED_GLASS_PANE);
        ItemMeta borderMeta = border.getItemMeta();
        borderMeta.setDisplayName(" ");
        border.setItemMeta(borderMeta);
        int i = 0;
        while (i < 9) {
            inv.setItem(i, border);
            inv.setItem(45 + i, border);
            ++i;
        }
        int row = 1;
        while (row < 5) {
            inv.setItem(row * 9, border);
            inv.setItem(row * 9 + 8, border);
            ++row;
        }
        if (history.isEmpty()) {
            ItemStack noData = new ItemStack(Material.PAPER);
            ItemMeta noDataMeta = noData.getItemMeta();
            noDataMeta.setDisplayName(String.valueOf(ChatColor.RED) + "No Price History");
            ArrayList<CallSite> noDataLore = new ArrayList<CallSite>();
            noDataLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "This stock has no recorded")));
            noDataLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "price history yet.")));
            noDataMeta.setLore(noDataLore);
            noData.setItemMeta(noDataMeta);
            inv.setItem(22, noData);
        } else {
            int start = page * 28;
            int end = Math.min(start + 28, history.size());
            double minPrice = Double.MAX_VALUE;
            double maxPrice = Double.MIN_VALUE;
            double avgPrice = 0.0;
            int count = 0;
            int i2 = Math.max(0, history.size() - end);
            while (i2 < Math.min(history.size(), history.size() - start)) {
                StockHistoryManager.PriceEntry entry = history.get(i2);
                minPrice = Math.min(minPrice, entry.price);
                maxPrice = Math.max(maxPrice, entry.price);
                avgPrice += entry.price;
                ++count;
                ++i2;
            }
            if (count > 0) {
                avgPrice /= (double)count;
            }
            ItemStack stats = new ItemStack(Material.GOLD_INGOT);
            ItemMeta statsMeta = stats.getItemMeta();
            statsMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Price Statistics");
            ArrayList<CallSite> statsLore = new ArrayList<CallSite>();
            statsLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Current Page Stats:")));
            statsLore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Average: " + String.valueOf(ChatColor.WHITE) + String.format("%.2f", avgPrice))));
            statsLore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Highest: " + String.valueOf(ChatColor.WHITE) + String.format("%.2f", maxPrice))));
            statsLore.add((CallSite)((Object)(String.valueOf(ChatColor.AQUA) + "Lowest: " + String.valueOf(ChatColor.WHITE) + String.format("%.2f", minPrice))));
            statsMeta.setLore(statsLore);
            stats.setItemMeta(statsMeta);
            inv.setItem(4, stats);
            int slot = 10;
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, HH:mm");
            int i3 = history.size() - 1 - start;
            while (i3 >= Math.max(0, history.size() - end)) {
                StockHistoryManager.PriceEntry entry = history.get(i3);
                Material entryMat = Material.PAPER;
                ChatColor priceColor = ChatColor.YELLOW;
                ItemStack entryItem = new ItemStack(entryMat);
                ItemMeta entryMeta = entryItem.getItemMeta();
                String time = dateFormat.format(new Date(entry.timestamp));
                entryMeta.setDisplayName(String.valueOf(priceColor) + String.format("%.2f", entry.price));
                ArrayList<CallSite> entryLore = new ArrayList<CallSite>();
                entryLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + time)));
                entryMeta.setLore(entryLore);
                entryItem.setItemMeta(entryMeta);
                while (slot % 9 == 0 || slot % 9 == 8 || slot < 9 || slot >= 45) {
                    ++slot;
                }
                inv.setItem(slot, entryItem);
                ++slot;
                --i3;
            }
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            prevMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "\u25c4 Previous Page");
            ArrayList<CallSite> prevLore = new ArrayList<CallSite>();
            prevLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Page " + page + " of " + totalPages)));
            prevMeta.setLore(prevLore);
            prev.setItemMeta(prevMeta);
            inv.setItem(48, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Next Page \u25ba");
            ArrayList<CallSite> nextLore = new ArrayList<CallSite>();
            nextLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Page " + (page + 2) + " of " + totalPages)));
            nextMeta.setLore(nextLore);
            next.setItemMeta(nextMeta);
            inv.setItem(50, next);
        }
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "\u2716 Close");
        ArrayList<CallSite> closeLore = new ArrayList<CallSite>();
        closeLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Return to stock browser")));
        closeMeta.setLore(closeLore);
        close.setItemMeta(closeMeta);
        inv.setItem(49, close);
        player.openInventory(inv);
        if (listener != null) {
            listener.trackGui(player, productId, history, page);
        }
    }

    private static String formatProductName(String id) {
        if (id == null || id.isEmpty()) {
            return "Unknown";
        }
        String[] parts = id.toLowerCase().split("_");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > 0) {
                sb.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(" ");
            }
            ++n2;
        }
        return sb.toString().trim();
    }
}

