/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.gui.stock.AllStocksGui;
import com.skyblockexp.ezshops.gui.stock.StockHistoryGui;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.gui.stock.StockTransactionConfirmGui;
import com.skyblockexp.ezshops.stock.StockHistoryManager;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.io.File;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AllStocksGuiListener
implements Listener {
    private final StockMarketManager stockMarketManager;
    private final StockMarketConfig stockMarketConfig;
    private final StockMarketFrozenStore frozenStore;
    private final File configFile;
    private final StockOverviewGui stockOverviewGui;

    public AllStocksGuiListener(StockMarketManager stockMarketManager, StockMarketConfig stockMarketConfig, StockMarketFrozenStore frozenStore, File configFile, StockOverviewGui stockOverviewGui) {
        this.stockMarketManager = stockMarketManager;
        this.stockMarketConfig = stockMarketConfig;
        this.frozenStore = frozenStore;
        this.configFile = configFile;
        this.stockOverviewGui = stockOverviewGui;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        void player;
        int rows;
        int size;
        String filterValue;
        String displayName;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (ChatColor.stripColor((String)title).equals("Buy Stock") || ChatColor.stripColor((String)title).equals("Sell Stock")) {
            event.setCancelled(true);
            return;
        }
        String strippedTitle = ChatColor.stripColor((String)title);
        if (!strippedTitle.startsWith(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&bAll Stocks")))) {
            return;
        }
        event.setCancelled(true);
        int page = 1;
        int idx1 = title.lastIndexOf(40);
        int idx2 = title.lastIndexOf(47) - 1;
        if (idx1 >= 0 && idx2 > idx1) {
            try {
                String pageStr = title.substring(idx1 + 1, idx2).trim();
                page = Integer.parseInt(pageStr);
            }
            catch (Exception pageStr) {
                // empty catch block
            }
        }
        AllStocksGui tempGui = new AllStocksGui(this.stockMarketManager, this.stockMarketConfig, this.frozenStore, this.configFile);
        tempGui.setStockOverviewGui(this.stockOverviewGui);
        String currentFilter = "all";
        int filterSlot = tempGui.getFilterButtonSlot();
        ItemStack filterButton = event.getInventory().getItem(filterSlot);
        if (filterButton != null && filterButton.hasItemMeta() && filterButton.getItemMeta().hasDisplayName() && (displayName = ChatColor.stripColor((String)filterButton.getItemMeta().getDisplayName())).startsWith("Filter: ") && ((filterValue = displayName.substring(8).toLowerCase()).equals("blocks") || filterValue.equals("items") || filterValue.equals("all items"))) {
            currentFilter = filterValue.replace("all items", "all");
        }
        if (tempGui.handleInventoryClick(event, page, currentFilter)) {
            return;
        }
        int slot = event.getSlot();
        if (slot >= (size = (rows = tempGui.getRows()) * 9) - 9) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || clicked.getType() == Material.AIR) {
            return;
        }
        String productId = clicked.getType().name();
        if (clicked.getItemMeta().hasLore()) {
            List lore = clicked.getItemMeta().getLore();
            for (String line : lore) {
                if (!ChatColor.stripColor((String)line).equals("Blocked") && !ChatColor.stripColor((String)line).equals("Frozen")) continue;
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item cannot be traded.");
                return;
            }
        }
        if (event.isShiftClick()) {
            StockHistoryManager historyManager = this.stockMarketManager.getHistoryManager();
            List<StockHistoryManager.PriceEntry> history = historyManager.getHistory(productId);
            StockHistoryGui.open((Player)player, productId, history);
        } else if (event.isLeftClick()) {
            StockTransactionConfirmGui.open((Player)player, productId, StockTransactionConfirmGui.TransactionType.BUY, this.stockMarketManager, tempGui, page, currentFilter);
        } else if (event.isRightClick()) {
            StockTransactionConfirmGui.open((Player)player, productId, StockTransactionConfirmGui.TransactionType.SELL, this.stockMarketManager, tempGui, page, currentFilter);
        }
    }
}

