/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.stock;

import com.skyblockexp.ezshops.common.MessageUtil;
import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AllStocksGui {
    private final StockMarketManager stockMarketManager;
    private final StockMarketConfig stockMarketConfig;
    private final StockMarketFrozenStore frozenStore;
    private final YamlConfiguration guiConfig;
    private final int rows;
    private final String title;
    private final boolean backButtonEnabled;
    private final int backButtonSlot;
    private final Material backButtonMaterial;
    private final String backButtonDisplayName;
    private final List<String> backButtonLore;
    private final boolean filterButtonEnabled;
    private final int filterButtonSlot;
    private final Material filterButtonMaterial;
    private final String filterButtonDisplayName;
    private final List<String> filterButtonLore;
    private final int previousPageSlot;
    private final Material previousPageMaterial;
    private final String previousPageDisplayName;
    private final int nextPageSlot;
    private final Material nextPageMaterial;
    private final String nextPageDisplayName;
    private final List<Map<String, String>> filters;
    private final Map<String, String> localization;
    private StockOverviewGui stockOverviewGui;

    public AllStocksGui(StockMarketManager stockMarketManager, StockMarketConfig stockMarketConfig, StockMarketFrozenStore frozenStore, File configFile) {
        this.stockMarketManager = stockMarketManager;
        this.stockMarketConfig = stockMarketConfig;
        this.frozenStore = frozenStore;
        this.guiConfig = YamlConfiguration.loadConfiguration((File)configFile);
        this.rows = this.guiConfig.getInt("all-stocks-gui.layout.rows", 6);
        this.title = MessageUtil.translateColors(this.guiConfig.getString("all-stocks-gui.layout.title", "&bAll Stocks"));
        ConfigurationSection backSection = this.guiConfig.getConfigurationSection("all-stocks-gui.back-button");
        if (backSection != null) {
            this.backButtonEnabled = backSection.getBoolean("enabled", true);
            this.backButtonSlot = backSection.getInt("slot", this.rows * 9 - 9);
            String matName = backSection.getString("material", "BARRIER");
            Material mat = Material.matchMaterial((String)matName);
            this.backButtonMaterial = mat != null ? mat : Material.BARRIER;
            this.backButtonDisplayName = MessageUtil.translateColors(backSection.getString("display-name", "&cBack to My Stocks"));
            List lore = backSection.getStringList("lore");
            this.backButtonLore = new ArrayList<String>();
            for (String l : lore) {
                this.backButtonLore.add(MessageUtil.translateColors(l));
            }
        } else {
            this.backButtonEnabled = true;
            this.backButtonSlot = this.rows * 9 - 9;
            this.backButtonMaterial = Material.BARRIER;
            this.backButtonDisplayName = String.valueOf(ChatColor.RED) + "Back to My Stocks";
            this.backButtonLore = List.of(String.valueOf(ChatColor.GRAY) + "Return to your stock overview");
        }
        ConfigurationSection filterSection = this.guiConfig.getConfigurationSection("all-stocks-gui.filter-button");
        if (filterSection != null) {
            this.filterButtonEnabled = filterSection.getBoolean("enabled", true);
            this.filterButtonSlot = filterSection.getInt("slot", this.rows * 9 - 8);
            String matName = filterSection.getString("material", "HOPPER");
            Material mat = Material.matchMaterial((String)matName);
            this.filterButtonMaterial = mat != null ? mat : Material.HOPPER;
            this.filterButtonDisplayName = MessageUtil.translateColors(filterSection.getString("display-name", "&aFilter: {filter}"));
            List lore = filterSection.getStringList("lore");
            this.filterButtonLore = new ArrayList<String>();
            for (String l : lore) {
                this.filterButtonLore.add(MessageUtil.translateColors(l));
            }
        } else {
            this.filterButtonEnabled = true;
            this.filterButtonSlot = this.rows * 9 - 8;
            this.filterButtonMaterial = Material.HOPPER;
            this.filterButtonDisplayName = String.valueOf(ChatColor.AQUA) + "Filter: {filter}";
            this.filterButtonLore = List.of(String.valueOf(ChatColor.GRAY) + "Click to cycle filters");
        }
        ConfigurationSection prevSection = this.guiConfig.getConfigurationSection("all-stocks-gui.pagination.previous");
        if (prevSection != null) {
            this.previousPageSlot = prevSection.getInt("slot", this.rows * 9 - 7);
            String matName = prevSection.getString("material", "ARROW");
            Material mat = Material.matchMaterial((String)matName);
            this.previousPageMaterial = mat != null ? mat : Material.ARROW;
            this.previousPageDisplayName = MessageUtil.translateColors(prevSection.getString("display-name", "&aPrevious Page"));
        } else {
            this.previousPageSlot = this.rows * 9 - 7;
            this.previousPageMaterial = Material.ARROW;
            this.previousPageDisplayName = String.valueOf(ChatColor.GREEN) + "Previous Page";
        }
        ConfigurationSection nextSection = this.guiConfig.getConfigurationSection("all-stocks-gui.pagination.next");
        if (nextSection != null) {
            this.nextPageSlot = nextSection.getInt("slot", this.rows * 9 - 1);
            String matName = nextSection.getString("material", "ARROW");
            Material mat = Material.matchMaterial((String)matName);
            this.nextPageMaterial = mat != null ? mat : Material.ARROW;
            this.nextPageDisplayName = MessageUtil.translateColors(nextSection.getString("display-name", "&aNext Page"));
        } else {
            this.nextPageSlot = this.rows * 9 - 1;
            this.nextPageMaterial = Material.ARROW;
            this.nextPageDisplayName = String.valueOf(ChatColor.GREEN) + "Next Page";
        }
        this.filters = new ArrayList<Map<String, String>>();
        List filterList = this.guiConfig.getList("all-stocks-gui.filters");
        if (filterList != null) {
            for (Object obj : filterList) {
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                HashMap<String, String> f = new HashMap<String, String>();
                for (Map.Entry e : map.entrySet()) {
                    f.put(e.getKey().toString(), e.getValue().toString());
                }
                this.filters.add(f);
            }
        }
        if (this.filters.isEmpty()) {
            HashMap<String, String> all = new HashMap<String, String>();
            all.put("id", "all");
            all.put("display", "All Items");
            this.filters.add(all);
            HashMap<String, String> blocks = new HashMap<String, String>();
            blocks.put("id", "blocks");
            blocks.put("display", "Blocks");
            this.filters.add(blocks);
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("id", "items");
            items.put("display", "Items");
            this.filters.add(items);
        }
        this.localization = new HashMap<String, String>();
        ConfigurationSection locSection = this.guiConfig.getConfigurationSection("all-stocks-gui.localization");
        if (locSection != null) {
            for (String key : locSection.getKeys(false)) {
                this.localization.put(key, MessageUtil.translateColors(locSection.getString(key)));
            }
        }
        if (!this.localization.containsKey("item-price-format")) {
            this.localization.put("item-price-format", String.valueOf(ChatColor.GRAY) + "Current Price: " + String.valueOf(ChatColor.GOLD) + "{price}");
        }
        if (!this.localization.containsKey("item-blocked")) {
            this.localization.put("item-blocked", String.valueOf(ChatColor.RED) + "Blocked");
        }
        if (!this.localization.containsKey("item-frozen")) {
            this.localization.put("item-frozen", String.valueOf(ChatColor.AQUA) + "Frozen");
        }
    }

    public void setStockOverviewGui(StockOverviewGui stockOverviewGui) {
        this.stockOverviewGui = stockOverviewGui;
    }

    public int getRows() {
        return this.rows;
    }

    public StockMarketManager getStockMarketManager() {
        return this.stockMarketManager;
    }

    public String getTitle() {
        return this.title;
    }

    public int getBackButtonSlot() {
        return this.backButtonSlot;
    }

    public int getFilterButtonSlot() {
        return this.filterButtonSlot;
    }

    public int getPreviousPageSlot() {
        return this.previousPageSlot;
    }

    public int getNextPageSlot() {
        return this.nextPageSlot;
    }

    public void open(Player player, int page) {
        this.open(player, page, "all");
    }

    public void open(Player player, int page, String filter) {
        ItemMeta meta;
        List<String> allIds = this.getFilteredProductIds(filter);
        int pageSize = (this.rows - 1) * 9;
        int totalPages = Math.max(1, (allIds.size() + pageSize - 1) / pageSize);
        page = Math.max(1, Math.min(page, totalPages));
        String displayTitle = MessageUtil.translateColors(this.title) + " (" + page + "/" + totalPages + ")";
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(this.rows * 9), (String)displayTitle);
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, allIds.size());
        int itemIndex = 0;
        int i = start;
        while (i < end) {
            String id = allIds.get(i);
            Material mat = Material.matchMaterial((String)id);
            if (mat != null) {
                double price;
                Object displayName;
                StockMarketConfig.OverrideItem override = this.stockMarketConfig.getOverride(id);
                if (override != null) {
                    displayName = override.display != null ? MessageUtil.translateColors(override.display) : id;
                    price = override.basePrice;
                } else {
                    displayName = id.charAt(0) + id.substring(1).toLowerCase().replace('_', ' ');
                    price = this.stockMarketManager.getPrice(id);
                }
                ItemStack item = new ItemStack(mat);
                ItemMeta meta2 = item.getItemMeta();
                meta2.setDisplayName(String.valueOf(ChatColor.YELLOW) + (String)displayName);
                ArrayList<Object> lore = new ArrayList<Object>();
                String priceFormat = this.localization.get("item-price-format");
                lore.add(priceFormat.replace("{price}", String.format("%.2f", price)));
                if (this.stockMarketConfig.isBlocked(id)) {
                    lore.add(this.localization.get("item-blocked"));
                } else if (this.frozenStore.isFrozen(id)) {
                    lore.add(this.localization.get("item-frozen"));
                } else {
                    lore.add("");
                    lore.add(String.valueOf(ChatColor.GREEN) + "Left-click to buy");
                    lore.add(String.valueOf(ChatColor.RED) + "Right-click to sell");
                    lore.add(String.valueOf(ChatColor.AQUA) + "Shift-click for history");
                }
                meta2.setLore(lore);
                item.setItemMeta(meta2);
                while (itemIndex >= (this.rows - 1) * 9) {
                    ++itemIndex;
                }
                if (itemIndex < (this.rows - 1) * 9) {
                    inv.setItem(itemIndex, item);
                    ++itemIndex;
                }
            }
            ++i;
        }
        if (this.backButtonEnabled && this.backButtonSlot < inv.getSize()) {
            ItemStack back = new ItemStack(this.backButtonMaterial);
            ItemMeta backMeta = back.getItemMeta();
            backMeta.setDisplayName(this.backButtonDisplayName);
            backMeta.setLore(this.backButtonLore);
            back.setItemMeta(backMeta);
            inv.setItem(this.backButtonSlot, back);
        }
        if (this.filterButtonEnabled && this.filterButtonSlot < inv.getSize()) {
            String filterDisplay = this.getFilterDisplay(filter);
            ItemStack filterItem = new ItemStack(this.filterButtonMaterial);
            ItemMeta filterMeta = filterItem.getItemMeta();
            String name = this.filterButtonDisplayName.replace("{filter}", filterDisplay);
            filterMeta.setDisplayName(name);
            ArrayList<String> fLore = new ArrayList<String>();
            for (String l : this.filterButtonLore) {
                fLore.add(l.replace("{filter}", filterDisplay));
            }
            filterMeta.setLore(fLore);
            filterItem.setItemMeta(filterMeta);
            inv.setItem(this.filterButtonSlot, filterItem);
        }
        if (page > 1 && this.previousPageSlot < inv.getSize()) {
            ItemStack prev = new ItemStack(this.previousPageMaterial);
            meta = prev.getItemMeta();
            meta.setDisplayName(this.previousPageDisplayName);
            prev.setItemMeta(meta);
            inv.setItem(this.previousPageSlot, prev);
        }
        if (page < totalPages && this.nextPageSlot < inv.getSize()) {
            ItemStack next = new ItemStack(this.nextPageMaterial);
            meta = next.getItemMeta();
            meta.setDisplayName(this.nextPageDisplayName);
            next.setItemMeta(meta);
            inv.setItem(this.nextPageSlot, next);
        }
        player.openInventory(inv);
    }

    private String getFilterDisplay(String filterId) {
        for (Map<String, String> filter : this.filters) {
            if (!filter.get("id").equals(filterId)) continue;
            return filter.get("display");
        }
        return filterId;
    }

    private List<String> getFilteredProductIds(String filter) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String id : this.stockMarketManager.getAllProductIds()) {
            String lowerFilter;
            Material mat;
            if (filter.equals("all")) {
                filtered.add(id);
                continue;
            }
            if (filter.equals("blocks")) {
                mat = Material.matchMaterial((String)id);
                if (mat == null || !mat.isBlock()) continue;
                filtered.add(id);
                continue;
            }
            if (filter.equals("items")) {
                mat = Material.matchMaterial((String)id);
                if (mat == null || mat.isBlock()) continue;
                filtered.add(id);
                continue;
            }
            if (filter.startsWith("price:")) {
                String[] parts = filter.substring(6).split("-");
                try {
                    double min = Double.parseDouble(parts[0]);
                    double max = parts.length > 1 ? Double.parseDouble(parts[1]) : Double.MAX_VALUE;
                    double price = this.stockMarketManager.getPrice(id);
                    if (!(price >= min) || !(price <= max)) continue;
                    filtered.add(id);
                }
                catch (Exception ignored) {
                    filtered.add(id);
                }
                continue;
            }
            String itemName = id.toLowerCase(Locale.ROOT).replace('_', ' ');
            if (!itemName.contains(lowerFilter = filter.toLowerCase(Locale.ROOT))) continue;
            filtered.add(id);
        }
        return filtered;
    }

    public String getNextFilter(String currentFilter) {
        int i = 0;
        while (i < this.filters.size()) {
            if (this.filters.get(i).get("id").equals(currentFilter)) {
                int nextIndex = (i + 1) % this.filters.size();
                return this.filters.get(nextIndex).get("id");
            }
            ++i;
        }
        return "all";
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleInventoryClick(InventoryClickEvent event, int currentPage, String currentFilter) {
        void player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return false;
        }
        Player player2 = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (!ChatColor.stripColor((String)title).startsWith(ChatColor.stripColor((String)this.title))) {
            return false;
        }
        int slot = event.getSlot();
        if (this.backButtonEnabled && slot == this.backButtonSlot) {
            event.setCancelled(true);
            if (this.stockOverviewGui != null) {
                this.stockOverviewGui.open((Player)player, "all", 1);
            } else {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Returned to main view");
            }
            return true;
        }
        if (this.filterButtonEnabled && slot == this.filterButtonSlot) {
            event.setCancelled(true);
            String nextFilter = this.getNextFilter(currentFilter);
            this.open((Player)player, 1, nextFilter);
            return true;
        }
        if (slot == this.previousPageSlot) {
            event.setCancelled(true);
            this.open((Player)player, currentPage - 1, currentFilter);
            return true;
        }
        if (slot == this.nextPageSlot) {
            event.setCancelled(true);
            this.open((Player)player, currentPage + 1, currentFilter);
            return true;
        }
        return false;
    }
}

