/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.shop;

import com.skyblockexp.ezshops.common.CompatibilityUtil;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.ezshops.gui.shop.CategoryShopMenuHolder;
import com.skyblockexp.ezshops.gui.shop.FlatShopMenuHolder;
import com.skyblockexp.ezshops.gui.shop.MainShopMenuHolder;
import com.skyblockexp.ezshops.gui.shop.QuantityShopMenuHolder;
import com.skyblockexp.ezshops.gui.shop.ShopTransactionType;
import com.skyblockexp.ezshops.shop.ShopMenuLayout;
import com.skyblockexp.ezshops.shop.ShopPrice;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopTransactionService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopInventoryComposer {
    public static final String ACTION_BACK = "back";
    public static final String ACTION_CUSTOM = "custom";
    public static final String ACTION_PREVIOUS = "previous";
    public static final String ACTION_NEXT = "next";
    private final JavaPlugin plugin;
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final NamespacedKey categoryKey;
    private final NamespacedKey itemKey;
    private final NamespacedKey actionKey;
    private final NamespacedKey quantityKey;
    private final ShopMessageConfiguration.GuiMessages guiMessages;
    private final ShopMessageConfiguration.GuiMessages.CommonMessages commonMessages;
    private final ShopMessageConfiguration.GuiMessages.MenuMessages menuMessages;
    private final ShopMessageConfiguration.GuiMessages.MenuMessages.MainMenuMessages mainMenuMessages;
    private final ShopMessageConfiguration.GuiMessages.MenuMessages.FlatMenuMessages flatMenuMessages;
    private final ShopMessageConfiguration.GuiMessages.MenuMessages.CategoryMenuMessages categoryMenuMessages;
    private final ShopMessageConfiguration.GuiMessages.MenuMessages.QuantityMenuMessages quantityMenuMessages;

    public ShopInventoryComposer(JavaPlugin plugin, ShopPricingManager pricingManager, ShopTransactionService transactionService, NamespacedKey categoryKey, NamespacedKey itemKey, NamespacedKey actionKey, NamespacedKey quantityKey, ShopMessageConfiguration.GuiMessages guiMessages) {
        this.plugin = plugin;
        this.pricingManager = pricingManager;
        this.transactionService = transactionService;
        this.categoryKey = categoryKey;
        this.itemKey = itemKey;
        this.actionKey = actionKey;
        this.quantityKey = quantityKey;
        this.guiMessages = guiMessages;
        this.commonMessages = guiMessages.common();
        this.menuMessages = guiMessages.menus();
        this.mainMenuMessages = this.menuMessages.main();
        this.flatMenuMessages = this.menuMessages.flat();
        this.categoryMenuMessages = this.menuMessages.category();
        this.quantityMenuMessages = this.menuMessages.quantity();
    }

    public void openMainMenu(Player player) {
        if (player == null) {
            return;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        MainShopMenuHolder holder = new MainShopMenuHolder(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)layout.mainSize(), (String)layout.mainTitle());
        holder.setInventory(inventory);
        this.applyFill(inventory, layout.mainFill());
        List<ShopMenuLayout.Category> categories = layout.categories();
        if (categories.isEmpty()) {
            inventory.setItem(Math.min(13, inventory.getSize() - 1), this.createPlaceholderItem(Material.BARRIER, this.mainMenuMessages.emptyTitle(), this.mainMenuMessages.emptyLore()));
        } else {
            for (ShopMenuLayout.Category category : categories) {
                if (category.slot() < 0 || category.slot() >= inventory.getSize()) {
                    this.plugin.getLogger().warning("Category '" + category.id() + "' has an invalid slot " + category.slot() + " for the main shop menu.");
                    continue;
                }
                ItemStack icon = this.createItem(category.icon(), this.createCategoryPlaceholders(category));
                if (icon == null) continue;
                this.setPersistent(icon, this.categoryKey, category.id());
                inventory.setItem(category.slot(), icon);
            }
        }
        player.openInventory(inventory);
    }

    public void openFlatMenu(Player player, int islandLevel, boolean ignoreIslandRequirements) {
        if (player == null) {
            return;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        List<FlatShopMenuHolder.FlatMenuEntry> entries = this.buildFlatMenuEntries(layout);
        FlatShopMenuHolder holder = new FlatShopMenuHolder(player.getUniqueId(), entries, layout.mainSize());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)layout.mainSize(), (String)layout.mainTitle());
        holder.setInventory(inventory);
        this.populateFlatMenu(holder, 0, islandLevel, ignoreIslandRequirements);
        player.openInventory(inventory);
    }

    public void populateFlatMenu(FlatShopMenuHolder holder, int page, int islandLevel, boolean ignoreIslandRequirements) {
        ItemStack indicator;
        int indicatorSlot;
        ItemStack next;
        ItemStack previous;
        if (holder == null) {
            return;
        }
        Inventory inventory = holder.getInventory();
        if (inventory == null) {
            return;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        inventory.clear();
        this.applyFill(inventory, layout.mainFill());
        holder.clearEntries();
        int totalPages = Math.max(1, holder.totalPages());
        int normalizedPage = Math.max(0, Math.min(page, totalPages - 1));
        holder.setPage(normalizedPage);
        int perPage = holder.itemsPerPage();
        int startIndex = normalizedPage * perPage;
        List<Integer> itemSlots = holder.itemSlots();
        List<FlatShopMenuHolder.FlatMenuEntry> entries = holder.entries();
        if (entries.isEmpty()) {
            inventory.setItem(Math.min(13, inventory.getSize() - 1), this.createPlaceholderItem(Material.BARRIER, this.flatMenuMessages.emptyTitle(), this.flatMenuMessages.emptyLore()));
        } else {
            int i = 0;
            while (i < itemSlots.size()) {
                int entryIndex = startIndex + i;
                if (entryIndex >= entries.size()) break;
                int slot = itemSlots.get(i);
                FlatShopMenuHolder.FlatMenuEntry entry = entries.get(entryIndex);
                ItemStack stack = this.createShopMenuItem(entry.category(), entry.item(), islandLevel);
                if (stack != null) {
                    stack = this.applyLevelRequirement(stack, entry.item().requiredIslandLevel(), islandLevel, ignoreIslandRequirements);
                    this.setPersistent(stack, this.itemKey, entry.item().id());
                    this.setPersistent(stack, this.categoryKey, entry.category().id());
                    inventory.setItem(slot, stack);
                    holder.setEntry(slot, entry);
                }
                ++i;
            }
        }
        if (holder.previousSlot() >= 0 && holder.hasPreviousPage() && (previous = this.createPlaceholderItem(Material.ARROW, this.flatMenuMessages.previousTitle(), this.flatMenuMessages.previousLore(normalizedPage))) != null) {
            this.setPersistent(previous, this.actionKey, ACTION_PREVIOUS);
            inventory.setItem(holder.previousSlot(), previous);
        }
        if (holder.nextSlot() >= 0 && holder.hasNextPage() && (next = this.createPlaceholderItem(Material.ARROW, this.flatMenuMessages.nextTitle(), this.flatMenuMessages.nextLore(normalizedPage + 2))) != null) {
            this.setPersistent(next, this.actionKey, ACTION_NEXT);
            inventory.setItem(holder.nextSlot(), next);
        }
        if (holder.nextSlot() >= 0 && holder.previousSlot() >= 0 && (indicatorSlot = holder.previousSlot() + (holder.nextSlot() - holder.previousSlot()) / 2) >= 0 && indicatorSlot < inventory.getSize() && (indicator = this.createPlaceholderItem(Material.PAPER, this.flatMenuMessages.pageIndicatorTitle(normalizedPage + 1, totalPages), this.flatMenuMessages.pageIndicatorLore())) != null) {
            inventory.setItem(indicatorSlot, indicator);
        }
    }

    private List<FlatShopMenuHolder.FlatMenuEntry> buildFlatMenuEntries(ShopMenuLayout layout) {
        ArrayList<FlatShopMenuHolder.FlatMenuEntry> entries = new ArrayList<FlatShopMenuHolder.FlatMenuEntry>();
        for (ShopMenuLayout.Category category : layout.categories()) {
            ArrayList<ShopMenuLayout.Item> sortedItems = new ArrayList<ShopMenuLayout.Item>(category.items());
            sortedItems.sort(Comparator.comparingInt(ShopMenuLayout.Item::slot));
            for (ShopMenuLayout.Item item : sortedItems) {
                entries.add(new FlatShopMenuHolder.FlatMenuEntry(category, item));
            }
        }
        return entries;
    }

    public void openCategoryMenu(Player player, ShopMenuLayout.Category category, int islandLevel, boolean ignoreIslandRequirements) {
        ShopMenuLayout.ItemDecoration backButtonDecoration;
        if (player == null || category == null) {
            return;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        CategoryShopMenuHolder holder = new CategoryShopMenuHolder(player.getUniqueId(), category);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)category.menuSize(), (String)category.menuTitle());
        holder.setInventory(inventory);
        ShopMenuLayout.ItemDecoration fill = category.menuFill() != null ? category.menuFill() : layout.mainFill();
        this.applyFill(inventory, fill);
        if (category.items().isEmpty()) {
            inventory.setItem(Math.min(13, inventory.getSize() - 1), this.createPlaceholderItem(Material.BARRIER, this.categoryMenuMessages.emptyTitle(), this.categoryMenuMessages.emptyLore()));
        } else {
            for (ShopMenuLayout.Item item : category.items()) {
                if (item.slot() < 0 || item.slot() >= inventory.getSize()) {
                    this.plugin.getLogger().warning("Item '" + item.id() + "' in category '" + category.id() + "' has an invalid slot " + item.slot() + ".");
                    continue;
                }
                ItemStack stack = this.createShopMenuItem(category, item, islandLevel);
                if (stack == null) continue;
                stack = this.applyLevelRequirement(stack, item.requiredIslandLevel(), islandLevel, ignoreIslandRequirements);
                this.setPersistent(stack, this.itemKey, item.id());
                inventory.setItem(item.slot(), stack);
            }
        }
        ShopMenuLayout.ItemDecoration itemDecoration = backButtonDecoration = category.backButton() != null ? category.backButton() : layout.defaultBackButton();
        if (backButtonDecoration != null) {
            int backSlot = category.backButtonSlot() != null ? category.backButtonSlot().intValue() : this.clampSlot(layout.defaultBackButtonSlot(), inventory.getSize());
            backButton = this.createItem(backButtonDecoration, Map.of("{category}", category.displayName()));
            if (backButton != null) {
                this.setPersistent(backButton, this.actionKey, ACTION_BACK);
                inventory.setItem(backSlot, backButton);
            }
        } else {
            int backSlot = category.backButtonSlot() != null ? category.backButtonSlot().intValue() : this.clampSlot(layout.defaultBackButtonSlot(), inventory.getSize());
            backButton = this.createPlaceholderItem(Material.ARROW, this.categoryMenuMessages.defaultBackTitle(), this.categoryMenuMessages.defaultBackLore(category.displayName()));
            if (backButton != null) {
                this.setPersistent(backButton, this.actionKey, ACTION_BACK);
                inventory.setItem(backSlot, backButton);
            }
        }
        player.openInventory(inventory);
    }

    public void openQuantityMenu(Player player, ShopMenuLayout.Category category, ShopMenuLayout.Item item, ShopTransactionType type, int playerIslandLevel, boolean ignoreIslandRequirements) {
        if (player == null || category == null || item == null || type == null) {
            return;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        QuantityShopMenuHolder holder = new QuantityShopMenuHolder(player.getUniqueId(), category, item, type);
        String itemName = this.resolveItemName(category, item, playerIslandLevel);
        String titlePrefix = type == ShopTransactionType.BUY ? this.quantityMenuMessages.titlePrefixBuy() : this.quantityMenuMessages.titlePrefixSell();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)27, (String)(titlePrefix + String.valueOf(ChatColor.AQUA) + itemName));
        holder.setInventory(inventory);
        this.applyFill(inventory, layout.mainFill());
        ItemStack preview = this.createItem(item.display(), this.createItemPlaceholders(category, item, playerIslandLevel));
        preview = this.applyLevelRequirement(preview, item.requiredIslandLevel(), playerIslandLevel, ignoreIslandRequirements);
        inventory.setItem(4, preview);
        int baseAmount = Math.max(1, item.amount());
        int[] multipliers = new int[]{1, 2, 4, 8, 16, 32, 64};
        int[] slots = new int[]{9, 10, 11, 12, 13, 14, 15};
        int i = 0;
        while (i < multipliers.length && i < slots.length) {
            int multiplier = multipliers[i];
            int total = this.multiplyAmount(baseAmount, multiplier);
            ItemStack option = this.createQuantityOptionItem(item, type, total);
            if (option != null) {
                this.setPersistent(option, this.quantityKey, total);
                inventory.setItem(slots[i], option);
            }
            ++i;
        }
        ItemStack custom = this.createCustomAmountItem(type);
        this.setPersistent(custom, this.actionKey, ACTION_CUSTOM);
        inventory.setItem(22, custom);
        ShopMenuLayout.ItemDecoration backDecoration = layout.defaultBackButton();
        ItemStack backItem = backDecoration != null ? this.createItem(backDecoration, Map.of("{category}", category.displayName(), "{name}", category.displayName())) : this.createPlaceholderItem(Material.ARROW, this.quantityMenuMessages.backTitle(), this.quantityMenuMessages.backLore(category.displayName()));
        if (backItem != null) {
            this.setPersistent(backItem, this.actionKey, ACTION_BACK);
            inventory.setItem(18, backItem);
        }
        player.openInventory(inventory);
    }

    private void applyFill(Inventory inventory, ShopMenuLayout.ItemDecoration fill) {
        if (fill == null || fill.material() == null || fill.material() == Material.AIR) {
            return;
        }
        ItemStack item = this.createItem(fill, Map.of());
        if (item == null) {
            return;
        }
        int slot = 0;
        while (slot < inventory.getSize()) {
            ItemStack current = inventory.getItem(slot);
            if (current == null || current.getType() == Material.AIR) {
                inventory.setItem(slot, item.clone());
            }
            ++slot;
        }
    }

    private ItemStack createShopMenuItem(ShopMenuLayout.Category category, ShopMenuLayout.Item item, int islandLevel) {
        List<String> extraLore;
        Map<String, String> placeholders = this.createItemPlaceholders(category, item, islandLevel);
        ItemStack stack = this.createItem(item.display(), placeholders);
        if (stack == null) {
            return null;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        meta = this.decorateEnchantments(meta, item.enchantments());
        ShopPrice price = this.resolveDisplayPrice(item);
        double buyPrice = price.buyPrice();
        double sellPrice = price.sellPrice();
        int stackAmount = Math.max(1, Math.min(64, item.material().getMaxStackSize()));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.quantityMenuMessages.instructions());
        if (buyPrice >= 0.0) {
            lore.add(this.quantityMenuMessages.buyLine(this.formatPrice(buyPrice)));
            if (stackAmount > 1) {
                lore.add(this.quantityMenuMessages.buyStackLine(stackAmount, this.formatPrice(this.totalPrice(buyPrice, stackAmount))));
            }
        } else {
            lore.add(this.quantityMenuMessages.buyUnavailable());
        }
        if (sellPrice >= 0.0) {
            if (!lore.isEmpty() && !((String)lore.get(lore.size() - 1)).isEmpty()) {
                lore.add("");
            }
            lore.add(this.quantityMenuMessages.sellLine(this.formatPrice(sellPrice)));
            if (stackAmount > 1) {
                lore.add(this.quantityMenuMessages.sellStackLine(stackAmount, this.formatPrice(this.totalPrice(sellPrice, stackAmount))));
            }
        } else {
            lore.add(this.quantityMenuMessages.sellUnavailable());
        }
        if (!(extraLore = item.display().lore().stream().map(line -> this.applyPlaceholders((String)line, placeholders)).filter(line -> line != null && !line.isEmpty()).toList()).isEmpty()) {
            if (!lore.isEmpty() && !((String)lore.get(lore.size() - 1)).isEmpty()) {
                lore.add("");
            }
            lore.addAll(extraLore);
        }
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    private ItemStack createItem(ShopMenuLayout.ItemDecoration decoration, Map<String, String> placeholders) {
        if (decoration == null || decoration.material() == null || decoration.material() == Material.AIR) {
            return null;
        }
        ItemStack stack = new ItemStack(decoration.material(), Math.max(1, Math.min(64, decoration.amount())));
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            if (decoration.displayName() != null && !decoration.displayName().isEmpty()) {
                meta.setDisplayName(this.applyPlaceholders(decoration.displayName(), placeholders));
            }
            if (!decoration.lore().isEmpty()) {
                List<String> lore = decoration.lore().stream().map(line -> this.applyPlaceholders((String)line, placeholders)).toList();
                meta.setLore(lore);
            }
            stack.setItemMeta(meta);
        }
        return stack;
    }

    private ItemStack applyLevelRequirement(ItemStack item, int requiredLevel, int playerLevel, boolean ignoreIslandRequirements) {
        String last;
        if (ignoreIslandRequirements) {
            return item;
        }
        if (item == null || requiredLevel <= 0 || playerLevel >= requiredLevel) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        List lore = meta.getLore();
        ArrayList<String> updated = new ArrayList<String>();
        if (lore != null) {
            updated.addAll(lore);
        }
        if (!updated.isEmpty() && (last = (String)updated.get(updated.size() - 1)) != null && !last.isEmpty()) {
            updated.add("");
        }
        updated.add(this.quantityMenuMessages.levelRequirement(requiredLevel));
        meta.setLore(updated);
        item.setItemMeta(meta);
        return item;
    }

    private Map<String, String> createCategoryPlaceholders(ShopMenuLayout.Category category) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{category}", this.stripColor(category.displayName()));
        placeholders.put("{name}", category.displayName());
        return placeholders;
    }

    private Map<String, String> createItemPlaceholders(ShopMenuLayout.Category category, ShopMenuLayout.Item item, int islandLevel) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{category}", this.stripColor(category.displayName()));
        placeholders.put("{category_name}", category.displayName());
        placeholders.put("{material}", this.friendlyMaterialName(item.material()));
        placeholders.put("{material_key}", item.material().name());
        placeholders.put("{amount}", Integer.toString(item.amount()));
        placeholders.put("{bulk_amount}", Integer.toString(item.bulkAmount()));
        int stackAmount = Math.max(1, Math.min(64, item.material().getMaxStackSize()));
        placeholders.put("{stack_amount}", Integer.toString(stackAmount));
        placeholders.put("{stack_size}", Integer.toString(stackAmount));
        placeholders.put("{island_level}", Integer.toString(Math.max(0, islandLevel)));
        placeholders.put("{required_island_level}", item.requiredIslandLevel() > 0 ? Integer.toString(item.requiredIslandLevel()) : "");
        EntityType spawnerEntity = item.spawnerEntity();
        if (spawnerEntity != null) {
            placeholders.put("{spawner_entity}", spawnerEntity.name());
            String friendlySpawner = this.friendlyEntityName(spawnerEntity);
            placeholders.put("{spawner_name}", friendlySpawner);
            placeholders.put("{spawner}", friendlySpawner + " Spawner");
        } else {
            placeholders.put("{spawner_entity}", "");
            placeholders.put("{spawner_name}", "");
            placeholders.put("{spawner}", "");
        }
        placeholders.put("{enchantments}", this.formatEnchantments(item.enchantments()));
        ShopPrice price = this.resolveDisplayPrice(item);
        placeholders.put("{buy_price}", this.formatPrice(price.buyPrice()));
        placeholders.put("{sell_price}", this.formatPrice(price.sellPrice()));
        placeholders.put("{buy}", this.formatPrice(price.buyPrice()));
        placeholders.put("{sell}", this.formatPrice(price.sellPrice()));
        placeholders.put("{buy_total}", this.formatPrice(this.totalPrice(price.buyPrice(), item.amount())));
        placeholders.put("{sell_total}", this.formatPrice(this.totalPrice(price.sellPrice(), item.amount())));
        placeholders.put("{buy_bulk_total}", this.formatPrice(this.totalPrice(price.buyPrice(), item.bulkAmount())));
        placeholders.put("{sell_bulk_total}", this.formatPrice(this.totalPrice(price.sellPrice(), item.bulkAmount())));
        placeholders.put("{buy_stack_total}", this.formatPrice(this.totalPrice(price.buyPrice(), stackAmount)));
        placeholders.put("{sell_stack_total}", this.formatPrice(this.totalPrice(price.sellPrice(), stackAmount)));
        return placeholders;
    }

    private ShopPrice resolveDisplayPrice(ShopMenuLayout.Item item) {
        if (item == null) {
            return new ShopPrice(-1.0, -1.0);
        }
        if (item.type() == ShopMenuLayout.ItemType.MATERIAL) {
            return this.pricingManager.getPrice(item.material()).orElse(item.price());
        }
        return item.price();
    }

    private String resolveItemName(ShopMenuLayout.Category category, ShopMenuLayout.Item item, int islandLevel) {
        String displayName;
        if (item == null) {
            return "";
        }
        ShopMenuLayout.ItemDecoration display = item.display();
        String string = displayName = display != null ? display.displayName() : null;
        if (displayName != null && !displayName.isEmpty()) {
            Map<String, String> placeholders = this.createItemPlaceholders(category, item, islandLevel);
            return this.stripColor(this.applyPlaceholders(displayName, placeholders));
        }
        return this.friendlyMaterialName(item.material());
    }

    private ItemStack createPlaceholderItem(Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private int clampSlot(int slot, int inventorySize) {
        if (slot < 0) {
            return 0;
        }
        if (slot >= inventorySize) {
            return inventorySize - 1;
        }
        return slot;
    }

    private ItemStack createQuantityOptionItem(ShopMenuLayout.Item item, ShopTransactionType type, int quantity) {
        if (quantity <= 0) {
            return null;
        }
        Material iconMaterial = item.material() != null && item.material() != Material.AIR ? item.material() : Material.PAPER;
        ItemStack option = new ItemStack(iconMaterial, Math.min(iconMaterial.getMaxStackSize(), Math.max(1, quantity)));
        ItemMeta meta = option.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta = this.decorateEnchantments(meta, item.enchantments());
        meta.setDisplayName(this.quantityMenuMessages.optionTitle(quantity));
        ArrayList<String> lore = new ArrayList<String>();
        ShopPrice currentPrice = this.resolveDisplayPrice(item);
        double unitPrice = type == ShopTransactionType.BUY ? currentPrice.buyPrice() : currentPrice.sellPrice();
        String totalFormatted = unitPrice >= 0.0 ? this.formatPrice(this.totalPrice(unitPrice, quantity)) : this.commonMessages.priceUnavailable();
        lore.addAll(this.quantityMenuMessages.optionLore(type, totalFormatted, quantity));
        meta.setLore(lore);
        option.setItemMeta(meta);
        return option;
    }

    private ItemStack createCustomAmountItem(ShopTransactionType type) {
        ItemStack item = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.quantityMenuMessages.customTitle());
            ArrayList<String> lore = new ArrayList<String>(this.quantityMenuMessages.customLore(type));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemMeta decorateEnchantments(ItemMeta meta, Map<Enchantment, Integer> enchantments) {
        if (meta == null || enchantments == null || enchantments.isEmpty()) {
            return meta;
        }
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                storageMeta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), true);
            }
            return storageMeta;
        }
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
        }
        return meta;
    }

    private String formatEnchantments(Map<Enchantment, Integer> enchantments) {
        if (enchantments == null || enchantments.isEmpty()) {
            return "";
        }
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            String name = this.friendlyEnchantmentName(entry.getKey());
            String level = this.toRomanNumeral(Math.max(1, entry.getValue()));
            parts.add((CallSite)((Object)(name + " " + level)));
        }
        return String.join((CharSequence)", ", parts);
    }

    private String friendlyEnchantmentName(Enchantment enchantment) {
        if (enchantment == null) {
            return "";
        }
        String key = enchantment.getKey().getKey().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = key.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return key;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String toRomanNumeral(int number) {
        if (number <= 0) {
            return Integer.toString(number);
        }
        values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        numerals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        remaining = number;
        builder = new StringBuilder();
        i = 0;
        ** GOTO lbl15
        {
            builder.append(numerals[i]);
            remaining -= values[i];
            do {
                if (remaining >= values[i]) continue block0;
                ++i;
lbl15:
                // 2 sources

            } while (i < values.length && remaining > 0);
        }
        return builder.toString();
    }

    private void setPersistent(ItemStack item, NamespacedKey key, String value) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = CompatibilityUtil.getPersistentDataContainer(meta);
        CompatibilityUtil.set(container, key, PersistentDataType.STRING, value);
        item.setItemMeta(meta);
    }

    private void setPersistent(ItemStack item, NamespacedKey key, int value) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = CompatibilityUtil.getPersistentDataContainer(meta);
        CompatibilityUtil.set(container, key, PersistentDataType.INTEGER, value);
        item.setItemMeta(meta);
    }

    private int multiplyAmount(int base, int multiplier) {
        if (base <= 0 || multiplier <= 0) {
            return 0;
        }
        long result = (long)base * (long)multiplier;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    private String formatPrice(double value) {
        if (value < 0.0) {
            return this.commonMessages.priceUnavailable();
        }
        return this.transactionService.formatCurrency(value);
    }

    private double totalPrice(double unitPrice, int amount) {
        if (unitPrice < 0.0) {
            return -1.0;
        }
        return unitPrice * (double)amount;
    }

    private String applyPlaceholders(String text, Map<String, String> placeholders) {
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String stripColor(String input) {
        return input == null ? "" : ChatColor.stripColor((String)input);
    }

    private String friendlyMaterialName(Material material) {
        String lower = material.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return lower;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private String friendlyEntityName(EntityType entityType) {
        if (entityType == null) {
            return "";
        }
        String lower = entityType.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder builder = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.isEmpty()) {
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    builder.append(part.substring(1));
                }
                builder.append(' ');
            }
            ++n2;
        }
        if (builder.length() == 0) {
            return lower;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }
}

