/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.gui.shop;

import com.skyblockexp.ezshops.gui.shop.AbstractShopMenuHolder;
import com.skyblockexp.ezshops.shop.ShopMenuLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class FlatShopMenuHolder
extends AbstractShopMenuHolder {
    private final List<FlatMenuEntry> entries;
    private final List<Integer> itemSlots;
    private final int previousSlot;
    private final int nextSlot;
    private final Map<Integer, FlatMenuEntry> slotEntries = new HashMap<Integer, FlatMenuEntry>();
    private int page;

    public FlatShopMenuHolder(UUID owner, List<FlatMenuEntry> entries, int inventorySize) {
        super(owner);
        this.entries = List.copyOf(entries);
        if (inventorySize >= 18) {
            this.previousSlot = inventorySize - 9;
            this.nextSlot = inventorySize - 1;
        } else {
            this.previousSlot = -1;
            this.nextSlot = -1;
        }
        ArrayList<Integer> computedSlots = new ArrayList<Integer>();
        int slot = 0;
        while (slot < inventorySize) {
            if (slot != this.previousSlot && slot != this.nextSlot) {
                computedSlots.add(slot);
            }
            ++slot;
        }
        if (computedSlots.isEmpty() && inventorySize > 0) {
            computedSlots.add(0);
        }
        this.itemSlots = List.copyOf(computedSlots);
    }

    public List<FlatMenuEntry> entries() {
        return this.entries;
    }

    public List<Integer> itemSlots() {
        return this.itemSlots;
    }

    public int previousSlot() {
        return this.previousSlot;
    }

    public int nextSlot() {
        return this.nextSlot;
    }

    public int itemsPerPage() {
        return Math.max(1, this.itemSlots.size());
    }

    public int totalPages() {
        int perPage = this.itemsPerPage();
        if (perPage <= 0 || this.entries.isEmpty()) {
            return 1;
        }
        return (this.entries.size() + perPage - 1) / perPage;
    }

    public int page() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = Math.max(0, page);
    }

    public boolean hasPreviousPage() {
        return this.page > 0;
    }

    public boolean hasNextPage() {
        return this.page + 1 < this.totalPages();
    }

    public void clearEntries() {
        this.slotEntries.clear();
    }

    public void setEntry(int slot, FlatMenuEntry entry) {
        if (entry == null) {
            this.slotEntries.remove(slot);
        } else {
            this.slotEntries.put(slot, entry);
        }
    }

    public FlatMenuEntry entryForSlot(int slot) {
        return this.slotEntries.get(slot);
    }

    public record FlatMenuEntry(ShopMenuLayout.Category category, ShopMenuLayout.Item item) {
    }
}

