/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.config;

import com.skyblockexp.ezshops.common.MessageUtil;
import com.skyblockexp.ezshops.shop.ShopSignListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public final class ShopSignConfiguration {
    private static final String DEFAULT_HEADER = "&2[Shop]";
    private static final String DEFAULT_BUY_FORMAT = "&aBuy &7x{amount}";
    private static final String DEFAULT_SELL_FORMAT = "&cSell &7x{amount}";
    private static final String DEFAULT_ITEM_FORMAT = "&b{item}";
    private static final String DEFAULT_PRICE_FORMAT = "&6{price}";
    private static final String DEFAULT_UNAVAILABLE_FORMAT = "&cUnavailable";
    private static final String DEFAULT_HEADER_TOKEN = "[shop]";
    private final Set<String> recognizedHeaders;
    private final String headerText;
    private final String buyFormat;
    private final String sellFormat;
    private final String itemFormat;
    private final String priceFormat;
    private final String unavailableFormat;

    private ShopSignConfiguration(Set<String> recognizedHeaders, String headerText, String buyFormat, String sellFormat, String itemFormat, String priceFormat, String unavailableFormat) {
        this.recognizedHeaders = Collections.unmodifiableSet(recognizedHeaders);
        this.headerText = headerText;
        this.buyFormat = buyFormat;
        this.sellFormat = sellFormat;
        this.itemFormat = itemFormat;
        this.priceFormat = priceFormat;
        this.unavailableFormat = unavailableFormat;
    }

    public static ShopSignConfiguration from(FileConfiguration configuration, Logger logger) {
        String normalizedDefault;
        Objects.requireNonNull(configuration, "configuration");
        Objects.requireNonNull(logger, "logger");
        ConfigurationSection signs = configuration.getConfigurationSection("signs");
        if (signs == null) {
            logger.warning("Missing 'signs' configuration section; using default shop sign formatting.");
            return ShopSignConfiguration.defaults();
        }
        HashSet<String> headerTokens = new HashSet<String>();
        ArrayList<String> configuredHeaders = new ArrayList<String>(signs.getStringList("headers"));
        if (configuredHeaders.isEmpty()) {
            configuredHeaders.add(DEFAULT_HEADER_TOKEN);
        }
        for (String header : configuredHeaders) {
            String normalized = ShopSignConfiguration.normalizeHeader(header);
            if (normalized == null) continue;
            headerTokens.add(normalized);
        }
        ConfigurationSection display = signs.getConfigurationSection("display");
        if (display == null) {
            logger.warning("Missing 'signs.display' section; using default shop sign formatting.");
            return ShopSignConfiguration.defaultsWithHeaders(headerTokens);
        }
        String headerText = ShopSignConfiguration.colorize(display.getString("header", DEFAULT_HEADER));
        String buyFormat = ShopSignConfiguration.colorize(display.getString("buy-format", DEFAULT_BUY_FORMAT));
        String sellFormat = ShopSignConfiguration.colorize(display.getString("sell-format", DEFAULT_SELL_FORMAT));
        String itemFormat = ShopSignConfiguration.colorize(display.getString("item-format", DEFAULT_ITEM_FORMAT));
        String priceFormat = ShopSignConfiguration.colorize(display.getString("price-format", DEFAULT_PRICE_FORMAT));
        String unavailableFormat = ShopSignConfiguration.colorize(display.getString("unavailable-format", DEFAULT_UNAVAILABLE_FORMAT));
        String normalizedHeader = ShopSignConfiguration.normalizeHeader(headerText);
        if (normalizedHeader != null) {
            headerTokens.add(normalizedHeader);
        }
        if (headerTokens.isEmpty() && (normalizedDefault = ShopSignConfiguration.normalizeHeader(DEFAULT_HEADER_TOKEN)) != null) {
            headerTokens.add(normalizedDefault);
        }
        return new ShopSignConfiguration(headerTokens, headerText, buyFormat, sellFormat, itemFormat, priceFormat, unavailableFormat);
    }

    public String headerText() {
        return this.headerText;
    }

    public boolean matchesHeader(String header) {
        String normalized = ShopSignConfiguration.normalizeHeader(header);
        return normalized != null && this.recognizedHeaders.contains(normalized);
    }

    public String formatActionLine(ShopSignListener.SignAction action, int amount) {
        String format = action == ShopSignListener.SignAction.BUY ? this.buyFormat : this.sellFormat;
        return format.replace("{amount}", Integer.toString(Math.max(1, amount)));
    }

    public String formatItemLine(String itemName) {
        return this.itemFormat.replace("{item}", itemName == null ? "" : itemName);
    }

    public String formatPriceLine(String price) {
        return this.priceFormat.replace("{price}", price == null ? "" : price);
    }

    public String unavailableLine() {
        return this.unavailableFormat;
    }

    private static ShopSignConfiguration defaults() {
        HashSet<String> headers = new HashSet<String>();
        String normalizedDefault = ShopSignConfiguration.normalizeHeader(DEFAULT_HEADER_TOKEN);
        if (normalizedDefault != null) {
            headers.add(normalizedDefault);
        }
        return ShopSignConfiguration.defaultsWithHeaders(headers);
    }

    private static ShopSignConfiguration defaultsWithHeaders(Collection<String> headers) {
        String normalizedDefault;
        HashSet<String> normalizedHeaders = new HashSet<String>();
        for (String header : headers) {
            if (header == null) continue;
            normalizedHeaders.add(header);
        }
        String headerText = ShopSignConfiguration.colorize(DEFAULT_HEADER);
        String normalizedHeader = ShopSignConfiguration.normalizeHeader(headerText);
        if (normalizedHeader != null) {
            normalizedHeaders.add(normalizedHeader);
        }
        if (normalizedHeaders.isEmpty() && (normalizedDefault = ShopSignConfiguration.normalizeHeader(DEFAULT_HEADER_TOKEN)) != null) {
            normalizedHeaders.add(normalizedDefault);
        }
        return new ShopSignConfiguration(normalizedHeaders, headerText, ShopSignConfiguration.colorize(DEFAULT_BUY_FORMAT), ShopSignConfiguration.colorize(DEFAULT_SELL_FORMAT), ShopSignConfiguration.colorize(DEFAULT_ITEM_FORMAT), ShopSignConfiguration.colorize(DEFAULT_PRICE_FORMAT), ShopSignConfiguration.colorize(DEFAULT_UNAVAILABLE_FORMAT));
    }

    private static String colorize(String raw) {
        if (raw == null) {
            return "";
        }
        return MessageUtil.translateColors(raw);
    }

    private static String normalizeHeader(String raw) {
        if (raw == null) {
            return null;
        }
        String colorized = ShopSignConfiguration.colorize(raw);
        String stripped = ChatColor.stripColor((String)colorized);
        if (stripped == null) {
            return null;
        }
        String trimmed = stripped.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed.toLowerCase(Locale.ENGLISH);
    }
}

