/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.config;

import com.skyblockexp.ezshops.common.MessageUtil;
import com.skyblockexp.ezshops.playershop.PlayerShopMessages;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class PlayerShopConfiguration {
    private static final String DEFAULT_HEADER = "[playershop]";
    private static final String DEFAULT_AVAILABLE_HEADER = "&2[PlayerShop]";
    private static final String DEFAULT_OUT_OF_STOCK_HEADER = "&c[PlayerShop]";
    private static final String DEFAULT_OWNER_FORMAT = "&7{owner}";
    private static final String DEFAULT_UNKNOWN_OWNER = "Owner";
    private static final String DEFAULT_ITEM_FORMAT = "&b{amount}&7x &b{item}";
    private static final String DEFAULT_PRICE_FORMAT = "&6{price}";
    private static final String DEFAULT_OUT_OF_STOCK_LINE = "&cOut of Stock";
    private final boolean enabled;
    private final Set<String> headerTokens;
    private final boolean requireStockOnCreation;
    private final int minQuantity;
    private final int maxQuantity;
    private final double minPrice;
    private final double maxPrice;
    private final SignFormat signFormat;
    private final PlayerShopMessages messages;

    private PlayerShopConfiguration(boolean enabled, Set<String> headerTokens, boolean requireStockOnCreation, int minQuantity, int maxQuantity, double minPrice, double maxPrice, SignFormat signFormat, PlayerShopMessages messages) {
        this.enabled = enabled;
        this.headerTokens = headerTokens;
        this.requireStockOnCreation = requireStockOnCreation;
        this.minQuantity = minQuantity;
        this.maxQuantity = maxQuantity;
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
        this.signFormat = Objects.requireNonNull(signFormat, "signFormat");
        this.messages = Objects.requireNonNull(messages, "messages");
    }

    public static PlayerShopConfiguration from(FileConfiguration configuration, Logger logger) {
        String lang = configuration.getString("language", "en");
        String langFile = "messages/messages_" + lang + ".yml";
        YamlConfiguration langYaml = YamlConfiguration.loadConfiguration((File)new File(Bukkit.getPluginManager().getPlugin("EzShops").getDataFolder(), langFile));
        ConfigurationSection section = configuration.getConfigurationSection("player-shops");
        if (section == null) {
            return PlayerShopConfiguration.defaults();
        }
        boolean enabled = section.getBoolean("enabled", true);
        List<String> headers = section.getStringList("headers");
        if (headers.isEmpty()) {
            headers = List.of(DEFAULT_HEADER);
        }
        Set<String> normalizedHeaders = new HashSet<String>();
        for (String header : headers) {
            String normalized;
            if (header == null || (normalized = ChatColor.stripColor((String)header).trim().toLowerCase(Locale.US)).isEmpty()) continue;
            normalizedHeaders.add(normalized);
        }
        if (normalizedHeaders.isEmpty()) {
            normalizedHeaders.add(DEFAULT_HEADER);
        }
        normalizedHeaders = Collections.unmodifiableSet(normalizedHeaders);
        boolean requireStock = section.getBoolean("require-stock-on-creation", true);
        int minQuantity = Math.max(1, section.getInt("min-quantity", 1));
        int maxQuantity = Math.max(0, section.getInt("max-quantity", 0));
        if (maxQuantity > 0 && maxQuantity < minQuantity) {
            if (logger != null) {
                logger.log(Level.WARNING, "player-shops.max-quantity is less than min-quantity; using {0}", minQuantity);
            }
            maxQuantity = minQuantity;
        }
        double minPrice = Math.max(0.0, section.getDouble("min-price", 0.0));
        double maxPrice = Math.max(0.0, section.getDouble("max-price", 0.0));
        if (maxPrice > 0.0 && maxPrice < minPrice) {
            if (logger != null) {
                logger.log(Level.WARNING, "player-shops.max-price is less than min-price; using {0}", minPrice);
            }
            maxPrice = minPrice;
        }
        SignFormat signFormat = SignFormat.from(section.getConfigurationSection("sign-format"));
        ConfigurationSection langMessages = langYaml.getConfigurationSection("player-shops.messages");
        PlayerShopMessages messages = langMessages != null ? PlayerShopMessages.from(langMessages) : PlayerShopMessages.from(section.getConfigurationSection("messages"));
        return new PlayerShopConfiguration(enabled, normalizedHeaders, requireStock, minQuantity, maxQuantity, minPrice, maxPrice, signFormat, messages);
    }

    public static PlayerShopConfiguration defaults() {
        return new PlayerShopConfiguration(true, Collections.singleton(DEFAULT_HEADER), true, 1, 0, 0.0, 0.0, SignFormat.defaults(), PlayerShopMessages.defaults());
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean isHeaderToken(String text) {
        if (text == null) {
            return false;
        }
        String normalized = ChatColor.stripColor((String)text).trim().toLowerCase(Locale.US);
        return this.headerTokens.contains(normalized);
    }

    public boolean requireStockOnCreation() {
        return this.requireStockOnCreation;
    }

    public int minQuantity() {
        return this.minQuantity;
    }

    public int maxQuantity() {
        return this.maxQuantity;
    }

    public double minPrice() {
        return this.minPrice;
    }

    public double maxPrice() {
        return this.maxPrice;
    }

    public SignFormat signFormat() {
        return this.signFormat;
    }

    public PlayerShopMessages messages() {
        return this.messages;
    }

    public static final class SignFormat {
        private final String availableHeader;
        private final String outOfStockHeader;
        private final String ownerFormat;
        private final String unknownOwnerName;
        private final String itemFormat;
        private final String priceFormat;
        private final String outOfStockLine;

        private SignFormat(String availableHeader, String outOfStockHeader, String ownerFormat, String unknownOwnerName, String itemFormat, String priceFormat, String outOfStockLine) {
            this.availableHeader = availableHeader;
            this.outOfStockHeader = outOfStockHeader;
            this.ownerFormat = ownerFormat;
            this.unknownOwnerName = unknownOwnerName;
            this.itemFormat = itemFormat;
            this.priceFormat = priceFormat;
            this.outOfStockLine = outOfStockLine;
        }

        public static SignFormat from(ConfigurationSection section) {
            if (section == null) {
                return SignFormat.defaults();
            }
            String availableHeader = SignFormat.translate(section.getString("available-header", PlayerShopConfiguration.DEFAULT_AVAILABLE_HEADER));
            String outOfStockHeader = SignFormat.translate(section.getString("out-of-stock-header", PlayerShopConfiguration.DEFAULT_OUT_OF_STOCK_HEADER));
            String ownerFormat = SignFormat.translate(section.getString("owner-format", PlayerShopConfiguration.DEFAULT_OWNER_FORMAT));
            String unknownOwner = section.getString("unknown-owner-name", PlayerShopConfiguration.DEFAULT_UNKNOWN_OWNER);
            if (unknownOwner == null || unknownOwner.isBlank()) {
                unknownOwner = PlayerShopConfiguration.DEFAULT_UNKNOWN_OWNER;
            }
            String itemFormat = SignFormat.translate(section.getString("item-format", PlayerShopConfiguration.DEFAULT_ITEM_FORMAT));
            String priceFormat = SignFormat.translate(section.getString("price-format", PlayerShopConfiguration.DEFAULT_PRICE_FORMAT));
            String outOfStockLine = SignFormat.translate(section.getString("out-of-stock-line", PlayerShopConfiguration.DEFAULT_OUT_OF_STOCK_LINE));
            return new SignFormat(availableHeader, outOfStockHeader, ownerFormat, unknownOwner, itemFormat, priceFormat, outOfStockLine);
        }

        public static SignFormat defaults() {
            return new SignFormat(SignFormat.translate(PlayerShopConfiguration.DEFAULT_AVAILABLE_HEADER), SignFormat.translate(PlayerShopConfiguration.DEFAULT_OUT_OF_STOCK_HEADER), SignFormat.translate(PlayerShopConfiguration.DEFAULT_OWNER_FORMAT), PlayerShopConfiguration.DEFAULT_UNKNOWN_OWNER, SignFormat.translate(PlayerShopConfiguration.DEFAULT_ITEM_FORMAT), SignFormat.translate(PlayerShopConfiguration.DEFAULT_PRICE_FORMAT), SignFormat.translate(PlayerShopConfiguration.DEFAULT_OUT_OF_STOCK_LINE));
        }

        public String availableHeader() {
            return this.availableHeader;
        }

        public String outOfStockHeader() {
            return this.outOfStockHeader;
        }

        public String unknownOwnerName() {
            return this.unknownOwnerName;
        }

        public String[] formatLines(String ownerName, int amount, String itemName, String priceText, boolean hasStock) {
            Objects.requireNonNull(ownerName, "ownerName");
            String resolvedOwner = SignFormat.replace(this.ownerFormat, ownerName, amount, itemName, priceText);
            String resolvedItem = SignFormat.replace(this.itemFormat, ownerName, amount, itemName, priceText);
            String resolvedPrice = SignFormat.replace(this.priceFormat, ownerName, amount, itemName, priceText);
            String resolvedOutOfStock = SignFormat.replace(this.outOfStockLine, ownerName, amount, itemName, priceText);
            String[] lines = new String[]{hasStock ? this.availableHeader : this.outOfStockHeader, resolvedOwner, resolvedItem, hasStock ? resolvedPrice : resolvedOutOfStock};
            return lines;
        }

        private static String replace(String template, String ownerName, int amount, String itemName, String priceText) {
            String result = template;
            result = result.replace("{owner}", ownerName);
            result = result.replace("{amount}", Integer.toString(amount));
            result = result.replace("{item}", itemName);
            result = result.replace("{price}", priceText);
            return result;
        }

        private static String translate(String value) {
            if (value == null) {
                return "";
            }
            return MessageUtil.translateColors(value);
        }
    }
}

