/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.config;

import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public final class DynamicPricingConfiguration {
    private static final double DEFAULT_STARTING_MULTIPLIER = 1.0;
    private static final double DEFAULT_MIN_MULTIPLIER = 0.5;
    private static final double DEFAULT_MAX_MULTIPLIER = 3.0;
    private static final double DEFAULT_BUY_CHANGE = 0.0;
    private static final double DEFAULT_SELL_CHANGE = 0.0;
    private static final DynamicPricingConfiguration DISABLED = new DynamicPricingConfiguration(false, 1.0, 0.5, 3.0, 0.0, 0.0);
    private static final DynamicPricingConfiguration DEFAULTS = new DynamicPricingConfiguration(true, 1.0, 0.5, 3.0, 0.0, 0.0);
    private final boolean enabled;
    private final double defaultStartingMultiplier;
    private final double defaultMinMultiplier;
    private final double defaultMaxMultiplier;
    private final double defaultBuyChange;
    private final double defaultSellChange;

    private DynamicPricingConfiguration(boolean enabled, double defaultStartingMultiplier, double defaultMinMultiplier, double defaultMaxMultiplier, double defaultBuyChange, double defaultSellChange) {
        this.enabled = enabled;
        this.defaultStartingMultiplier = defaultStartingMultiplier;
        this.defaultMinMultiplier = defaultMinMultiplier;
        this.defaultMaxMultiplier = defaultMaxMultiplier;
        this.defaultBuyChange = defaultBuyChange;
        this.defaultSellChange = defaultSellChange;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public double defaultStartingMultiplier() {
        return this.defaultStartingMultiplier;
    }

    public double defaultMinMultiplier() {
        return this.defaultMinMultiplier;
    }

    public double defaultMaxMultiplier() {
        return this.defaultMaxMultiplier;
    }

    public double defaultBuyChange() {
        return this.defaultBuyChange;
    }

    public double defaultSellChange() {
        return this.defaultSellChange;
    }

    public static DynamicPricingConfiguration disabled() {
        return DISABLED;
    }

    public static DynamicPricingConfiguration defaults() {
        return DEFAULTS;
    }

    public static DynamicPricingConfiguration from(ConfigurationSection root, Logger logger) {
        if (root == null) {
            return DEFAULTS;
        }
        ConfigurationSection section = root.getConfigurationSection("dynamic-pricing");
        if (section == null) {
            return DEFAULTS;
        }
        boolean enabled = section.getBoolean("enabled", true);
        if (!enabled) {
            return DISABLED;
        }
        ConfigurationSection defaultsSection = section.getConfigurationSection("defaults");
        double startingMultiplier = DynamicPricingConfiguration.readDouble(defaultsSection, "starting-multiplier", 1.0, logger);
        double minMultiplier = DynamicPricingConfiguration.readDouble(defaultsSection, "min-multiplier", 0.5, logger);
        double maxMultiplier = DynamicPricingConfiguration.readDouble(defaultsSection, "max-multiplier", 3.0, logger);
        double buyChange = DynamicPricingConfiguration.readDouble(defaultsSection, "buy-change", 0.0, logger);
        double sellChange = DynamicPricingConfiguration.readDouble(defaultsSection, "sell-change", 0.0, logger);
        startingMultiplier = DynamicPricingConfiguration.sanitizePositive(startingMultiplier, 1.0, logger, "starting-multiplier");
        minMultiplier = DynamicPricingConfiguration.sanitizePositive(minMultiplier, 0.5, logger, "min-multiplier");
        maxMultiplier = DynamicPricingConfiguration.sanitizePositive(maxMultiplier, 3.0, logger, "max-multiplier");
        buyChange = DynamicPricingConfiguration.sanitizeNonNegative(buyChange, 0.0, logger, "buy-change");
        sellChange = DynamicPricingConfiguration.sanitizeNonNegative(sellChange, 0.0, logger, "sell-change");
        if (maxMultiplier < minMultiplier) {
            double previousMax = maxMultiplier;
            maxMultiplier = minMultiplier;
            minMultiplier = previousMax;
            logger.warning("dynamic-pricing.defaults.max-multiplier was lower than min-multiplier; the values have been swapped.");
        }
        return new DynamicPricingConfiguration(true, startingMultiplier, minMultiplier, maxMultiplier, buyChange, sellChange);
    }

    private static double readDouble(ConfigurationSection section, String path, double fallback, Logger logger) {
        if (section == null || !section.contains(path)) {
            return fallback;
        }
        Object value = section.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return Double.parseDouble(stringValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.warning("Invalid value for dynamic-pricing.defaults." + path + "; using " + fallback + ".");
        return fallback;
    }

    private static double sanitizePositive(double value, double fallback, Logger logger, String path) {
        if (Double.isNaN(value) || value <= 0.0) {
            logger.warning("Invalid value for dynamic-pricing.defaults." + path + "; using " + fallback + ".");
            return fallback;
        }
        return value;
    }

    private static double sanitizeNonNegative(double value, double fallback, Logger logger, String path) {
        if (Double.isNaN(value) || value < 0.0) {
            logger.warning("Invalid value for dynamic-pricing.defaults." + path + "; using " + fallback + ".");
            return fallback;
        }
        return value;
    }
}

