/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.common;

import com.skyblockexp.ezshops.libs.net.kyori.adventure.text.Component;
import com.skyblockexp.ezshops.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.skyblockexp.ezshops.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public final class MessageUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private static final LegacyComponentSerializer SECTION_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final Pattern MINIMESSAGE_TAG_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*(:.*)?");

    private MessageUtil() {
    }

    public static String translateLegacyColors(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String translateColors(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (MessageUtil.containsMiniMessageTags(text)) {
            try {
                Object component = MINI_MESSAGE.deserialize(text);
                return SECTION_SERIALIZER.serialize((Component)component);
            }
            catch (Exception e) {
                return MessageUtil.translateLegacyColors(text);
            }
        }
        return MessageUtil.translateLegacyColors(text);
    }

    private static boolean containsMiniMessageTags(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        int length = text.length();
        int i = 0;
        while (i < length - 1) {
            String potential;
            int closeIdx;
            if (text.charAt(i) == '<' && (closeIdx = text.indexOf(62, i + 1)) > i + 1 && closeIdx < i + 30 && MINIMESSAGE_TAG_PATTERN.matcher(potential = text.substring(i + 1, closeIdx)).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String stripColors(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        return ChatColor.stripColor((String)text);
    }

    public static Component parseMiniMessage(String miniMessage) {
        if (miniMessage == null || miniMessage.isEmpty()) {
            return Component.empty();
        }
        return MINI_MESSAGE.deserialize(miniMessage);
    }

    public static String serializeToMiniMessage(Component component) {
        if (component == null) {
            return "";
        }
        return (String)MINI_MESSAGE.serialize(component);
    }

    public static Component legacyToComponent(String legacyText) {
        if (legacyText == null || legacyText.isEmpty()) {
            return Component.empty();
        }
        return LEGACY_SERIALIZER.deserialize(legacyText);
    }

    public static String componentToLegacy(Component component) {
        if (component == null) {
            return "";
        }
        return SECTION_SERIALIZER.serialize(component);
    }

    public static String ampersandToSection(String text) {
        return MessageUtil.translateLegacyColors(text);
    }
}

