/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.common;

import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.TileState;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class CompatibilityUtil {
    private static final String SERVER_VERSION = Bukkit.getServer().getVersion();
    private static final String BUKKIT_VERSION = Bukkit.getServer().getBukkitVersion();
    private static Boolean isPaper = null;
    private static Boolean isSpigot = null;
    private static Boolean hasPersistentData = null;
    private static Integer minecraftVersion = null;

    private CompatibilityUtil() {
    }

    public static boolean isPaper() {
        if (isPaper == null) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                isPaper = true;
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("io.papermc.paper.configuration.Configuration");
                    isPaper = true;
                }
                catch (ClassNotFoundException e2) {
                    isPaper = false;
                }
            }
        }
        return isPaper;
    }

    public static boolean isSpigot() {
        if (isSpigot == null) {
            if (CompatibilityUtil.isPaper()) {
                isSpigot = false;
            } else {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    isSpigot = true;
                }
                catch (ClassNotFoundException e) {
                    isSpigot = false;
                }
            }
        }
        return isSpigot;
    }

    public static boolean isBukkit() {
        return !CompatibilityUtil.isPaper() && !CompatibilityUtil.isSpigot();
    }

    public static String getServerType() {
        if (CompatibilityUtil.isPaper()) {
            return "Paper";
        }
        if (CompatibilityUtil.isSpigot()) {
            return "Spigot";
        }
        return "Bukkit";
    }

    public static int getMinecraftVersion() {
        if (minecraftVersion == null) {
            try {
                String[] parts;
                String version = BUKKIT_VERSION;
                if (version.contains("-")) {
                    version = version.substring(0, version.indexOf("-"));
                }
                if ((parts = version.split("\\.")).length >= 2) {
                    minecraftVersion = Integer.parseInt(parts[1]);
                } else if (parts.length == 1 && parts[0].length() > 0) {
                    try {
                        minecraftVersion = Integer.parseInt(parts[0]);
                    }
                    catch (NumberFormatException e) {
                        minecraftVersion = 21;
                    }
                } else {
                    minecraftVersion = 21;
                }
            }
            catch (Exception e) {
                minecraftVersion = 21;
            }
        }
        return minecraftVersion;
    }

    public static boolean hasPersistentDataSupport() {
        if (hasPersistentData == null) {
            try {
                Class.forName("org.bukkit.persistence.PersistentDataContainer");
                hasPersistentData = CompatibilityUtil.getMinecraftVersion() >= 14;
            }
            catch (ClassNotFoundException e) {
                hasPersistentData = false;
            }
        }
        return hasPersistentData;
    }

    public static PersistentDataContainer getPersistentDataContainer(TileState tileState) {
        if (!CompatibilityUtil.hasPersistentDataSupport() || tileState == null) {
            return null;
        }
        try {
            return tileState.getPersistentDataContainer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PersistentDataContainer getPersistentDataContainer(ItemMeta meta) {
        if (!CompatibilityUtil.hasPersistentDataSupport() || meta == null) {
            return null;
        }
        try {
            return meta.getPersistentDataContainer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T, Z> boolean hasKey(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (container == null || key == null || type == null) {
            return false;
        }
        try {
            return container.has(key, type);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T, Z> Z get(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (container == null || key == null || type == null) {
            return null;
        }
        try {
            return (Z)container.get(key, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T, Z> void set(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (container == null || key == null || type == null || value == null) {
            return;
        }
        try {
            container.set(key, type, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void remove(PersistentDataContainer container, NamespacedKey key) {
        if (container == null || key == null) {
            return;
        }
        try {
            container.remove(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    public static String getBukkitVersion() {
        return BUKKIT_VERSION;
    }

    public static NamespacedKey createKey(Plugin plugin, String key) {
        return new NamespacedKey(plugin, key);
    }
}

