/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.bootstrap;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.gui.stock.AllStocksGui;
import com.skyblockexp.ezshops.gui.stock.AllStocksGuiListener;
import com.skyblockexp.ezshops.gui.stock.StockHistoryGui;
import com.skyblockexp.ezshops.gui.stock.StockHistoryGuiListener;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGuiListener;
import com.skyblockexp.ezshops.gui.stock.StockTransactionConfirmGuiListener;
import com.skyblockexp.ezshops.repository.yml.YmlStockMarketRepository;
import com.skyblockexp.ezshops.stock.StockAdminCommand;
import com.skyblockexp.ezshops.stock.StockCommand;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class StockComponent
implements PluginComponent,
TabCompleter {
    private StockOverviewGuiListener stockOverviewGuiListener;
    private EzShopsPlugin plugin;
    private StockMarketManager stockMarketManager;
    private StockMarketConfig stockMarketConfig;
    private StockMarketFrozenStore frozenStore;
    private long cooldownMillis;

    @Override
    public void enable(EzShopsPlugin plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        boolean stockEnabled = true;
        if (config.getConfigurationSection("stock") != null) {
            stockEnabled = config.getBoolean("stock.enabled", true);
        }
        if (!stockEnabled) {
            if (plugin.isDebugMode()) {
                plugin.getLogger().info("Stock features are disabled via config. Skipping stock system initialization.");
            }
            return;
        }
        this.stockMarketConfig = new StockMarketConfig(config);
        YmlStockMarketRepository repository = new YmlStockMarketRepository(plugin.getDataFolder());
        this.frozenStore = new StockMarketFrozenStore(repository);
        this.stockMarketManager = new StockMarketManager();
        this.stockMarketManager.setStockMarketRepository(repository);
        this.stockMarketManager.enablePersistence((Plugin)plugin, 6000L);
        this.cooldownMillis = config.getConfigurationSection("stock") != null ? config.getLong("stock.cooldown-millis", 0L) : 0L;
        this.registerCommand("stock", new StockCommand(plugin, this.stockMarketManager, this.cooldownMillis, this.stockMarketConfig, this.frozenStore));
        this.registerCommand("stockadmin", new StockAdminCommand(this.stockMarketManager, this.frozenStore, this.stockMarketConfig));
        StockOverviewGui stockOverviewGui = new StockOverviewGui(this.stockMarketManager, this.stockMarketConfig, this.frozenStore, new File(plugin.getDataFolder(), "stock-gui.yml"), plugin.isDebugMode());
        this.stockOverviewGuiListener = new StockOverviewGuiListener(this.stockMarketManager, stockOverviewGui);
        plugin.getServer().getPluginManager().registerEvents((Listener)this.stockOverviewGuiListener, (Plugin)plugin);
        File stockGuiConfigFile = new File(plugin.getDataFolder(), "stock-gui.yml");
        AllStocksGuiListener allStocksGuiListener = new AllStocksGuiListener(this.stockMarketManager, this.stockMarketConfig, this.frozenStore, stockGuiConfigFile, stockOverviewGui);
        plugin.getServer().getPluginManager().registerEvents((Listener)allStocksGuiListener, (Plugin)plugin);
        AllStocksGui allStocksGuiForTransactions = new AllStocksGui(this.stockMarketManager, this.stockMarketConfig, this.frozenStore, stockGuiConfigFile);
        allStocksGuiForTransactions.setStockOverviewGui(stockOverviewGui);
        StockTransactionConfirmGuiListener transactionListener = new StockTransactionConfirmGuiListener(this.stockMarketManager, allStocksGuiForTransactions);
        plugin.getServer().getPluginManager().registerEvents((Listener)transactionListener, (Plugin)plugin);
        StockHistoryGuiListener stockHistoryGuiListener = new StockHistoryGuiListener((Plugin)plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)stockHistoryGuiListener, (Plugin)plugin);
        StockHistoryGui.setListener(stockHistoryGuiListener);
    }

    @Override
    public void disable() {
        if (this.stockMarketManager != null) {
            this.stockMarketManager.disablePersistence();
        }
        this.plugin = null;
        this.stockMarketManager = null;
        this.stockMarketConfig = null;
        this.frozenStore = null;
        this.cooldownMillis = 0L;
    }

    private void registerCommand(String name, Object executor) {
        if (this.plugin == null || executor == null) {
            return;
        }
        PluginCommand command = this.plugin.getCommand(name);
        if (command == null) {
            this.plugin.getLogger().severe("Plugin command '" + name + "' is not defined in plugin.yml. EzShops will be unusable.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new IllegalStateException("Missing required command '" + name + "'.");
        }
        if (executor instanceof CommandExecutor) {
            CommandExecutor ce = (CommandExecutor)executor;
            command.setExecutor(ce);
        }
        command.setTabCompleter((TabCompleter)this);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd = command.getName().toLowerCase(Locale.ROOT);
        if (cmd.equals("stock")) {
            if (args.length == 1) {
                return this.filterPrefix(args[0], Arrays.asList("buy", "sell", "overview"));
            }
            if ((args[0].equalsIgnoreCase("buy") || args[0].equalsIgnoreCase("sell")) && args.length == 2) {
                HashSet<String> items = new HashSet<String>();
                for (StockMarketConfig.OverrideItem override : this.stockMarketConfig.getAllOverrides()) {
                    items.add(override.id);
                }
                items.addAll(this.stockMarketManager.getAllProductIds());
                items.removeIf(this.stockMarketConfig::isBlocked);
                items.removeIf(this.frozenStore::isFrozen);
                return this.filterPrefix(args[1], new ArrayList<String>(items));
            }
        } else if (cmd.equals("stockadmin")) {
            if (args.length == 1) {
                return this.filterPrefix(args[0], Arrays.asList("set", "reset", "freeze", "unfreeze", "reload", "listfrozen", "listoverrides"));
            }
            if (Arrays.asList("set", "reset", "freeze", "unfreeze").contains(args[0].toLowerCase(Locale.ROOT)) && args.length == 2) {
                HashSet<String> items = new HashSet<String>();
                items.addAll(this.stockMarketManager.getAllProductIds());
                items.addAll(this.stockMarketConfig.getAllOverrides().stream().map(o -> o.id).toList());
                return this.filterPrefix(args[1], new ArrayList<String>(items));
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterPrefix(String prefix, List<String> options) {
        if (prefix == null || prefix.isEmpty()) {
            return options;
        }
        String lower = prefix.toLowerCase(Locale.ROOT);
        ArrayList<String> result = new ArrayList<String>();
        for (String opt : options) {
            if (!opt.toLowerCase(Locale.ROOT).startsWith(lower)) continue;
            result.add(opt);
        }
        return result;
    }

    public StockMarketManager getStockMarketManager() {
        return this.stockMarketManager;
    }

    public StockMarketConfig getStockMarketConfig() {
        return this.stockMarketConfig;
    }

    public StockMarketFrozenStore getFrozenStore() {
        return this.frozenStore;
    }
}

