/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.bootstrap;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.bootstrap.CoreShopComponent;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.ezshops.config.ShopSignConfiguration;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopSignListener;
import com.skyblockexp.ezshops.shop.ShopTransactionService;
import com.skyblockexp.ezshops.shop.sign.SignShopGenerator;
import com.skyblockexp.ezshops.shop.sign.SignShopScanner;
import com.skyblockexp.ezshops.shop.sign.SignShopSetupCommand;
import com.skyblockexp.ezshops.shop.sign.SignShopSetupMenu;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class SignShopComponent
implements PluginComponent {
    private final CoreShopComponent coreComponent;
    private EzShopsPlugin plugin;
    private ShopSignListener shopSignListener;
    private SignShopGenerator signShopGenerator;
    private SignShopSetupMenu signShopSetupMenu;
    private SignShopScanner signShopScanner;
    private SignShopSetupCommand signShopSetupCommand;

    public SignShopComponent(CoreShopComponent coreComponent) {
        this.coreComponent = coreComponent;
    }

    @Override
    public void enable(EzShopsPlugin plugin) {
        this.plugin = plugin;
        ShopPricingManager pricingManager = this.coreComponent.pricingManager();
        ShopTransactionService transactionService = this.coreComponent.transactionService();
        ShopMessageConfiguration messageConfiguration = this.coreComponent.messageConfiguration();
        if (pricingManager == null || transactionService == null || messageConfiguration == null) {
            throw new IllegalStateException("Core shop component must be enabled before the sign shop component.");
        }
        ShopMessageConfiguration.CommandMessages commandMessages = messageConfiguration.commands();
        ShopMessageConfiguration.SignMessages signMessages = messageConfiguration.signs();
        ShopSignConfiguration signConfiguration = ShopSignConfiguration.from(plugin.getConfig(), plugin.getLogger());
        this.shopSignListener = new ShopSignListener(plugin, pricingManager, transactionService, signConfiguration, signMessages);
        this.signShopGenerator = new SignShopGenerator(plugin, pricingManager, transactionService, signConfiguration);
        this.signShopSetupMenu = new SignShopSetupMenu(plugin, this.signShopGenerator, pricingManager);
        this.signShopScanner = new SignShopScanner(plugin, pricingManager, this.signShopGenerator, signConfiguration);
        this.signShopSetupCommand = new SignShopSetupCommand(this.signShopSetupMenu, this.signShopScanner, commandMessages.signShopScan(), signMessages);
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.shopSignListener, (Plugin)plugin);
        pluginManager.registerEvents((Listener)this.signShopSetupMenu, (Plugin)plugin);
        this.registerCommand("signshop", this.signShopSetupCommand);
    }

    @Override
    public void disable() {
        this.unregisterListener(this.shopSignListener);
        this.unregisterListener(this.signShopSetupMenu);
        this.signShopSetupCommand = null;
        this.signShopScanner = null;
        this.signShopSetupMenu = null;
        this.signShopGenerator = null;
        this.shopSignListener = null;
        this.plugin = null;
    }

    private void registerCommand(String name, CommandExecutor executor) {
        if (executor == null) {
            return;
        }
        PluginCommand command = this.plugin.getCommand(name);
        if (command == null) {
            this.plugin.getLogger().severe("Plugin command '" + name + "' is not defined in plugin.yml. EzShops will be unusable.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new IllegalStateException("Missing required command '" + name + "'.");
        }
        command.setExecutor(executor);
        if (executor instanceof TabCompleter) {
            TabCompleter tabCompleter = (TabCompleter)executor;
            command.setTabCompleter(tabCompleter);
        }
    }

    private void unregisterListener(Listener listener) {
        if (listener != null) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }
}

