/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.api;

import com.skyblockexp.ezshops.stock.StockManager;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;

public class StockAPI {
    private final StockMarketManager stockMarketManager;

    public StockAPI(StockMarketManager stockMarketManager) {
        if (stockMarketManager == null) {
            throw new IllegalArgumentException("StockMarketManager cannot be null");
        }
        this.stockMarketManager = stockMarketManager;
    }

    public double getStockPrice(String productId) {
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        return this.stockMarketManager.getPrice(productId.toUpperCase());
    }

    public void setStockPrice(String productId, double price) {
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        if (price < 0.0) {
            throw new IllegalArgumentException("Price cannot be negative");
        }
        this.stockMarketManager.setPrice(productId.toUpperCase(), price);
    }

    public void updateStockPrice(String productId, int demand) {
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        this.stockMarketManager.updatePrice(productId.toUpperCase(), demand);
    }

    public int getPlayerStockAmount(Player player, String productId) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        return StockManager.getPlayerStockAmount(player, productId.toUpperCase());
    }

    public boolean addPlayerStock(Player player, String productId, int amount) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive");
        }
        return StockManager.addPlayerStock(player, productId.toUpperCase(), amount);
    }

    public boolean removePlayerStock(Player player, String productId, int amount) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        if (productId == null || productId.isEmpty()) {
            throw new IllegalArgumentException("Product ID cannot be null or empty");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive");
        }
        return StockManager.removePlayerStock(player, productId.toUpperCase(), amount);
    }

    public List<String> getPlayerOwnedStocks(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        return StockManager.getPlayerOwnedStocks(player);
    }

    public Set<String> getAllProductIds() {
        return this.stockMarketManager.getAllProductIds();
    }
}

