/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.api;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.api.StockAPI;
import com.skyblockexp.ezshops.bootstrap.StockComponent;
import com.skyblockexp.ezshops.shop.api.ShopPriceService;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EzShopsAPI {
    private static EzShopsAPI instance;
    private final EzShopsPlugin plugin;
    private StockAPI stockAPI;

    private EzShopsAPI(EzShopsPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.initializeAPIs();
    }

    private void initializeAPIs() {
        try {
            StockMarketManager stockManager;
            StockComponent stockComponent = this.plugin.getStockComponent();
            if (stockComponent != null && (stockManager = stockComponent.getStockMarketManager()) != null) {
                this.stockAPI = new StockAPI(stockManager);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize StockAPI: " + e.getMessage());
        }
    }

    public static void initialize(EzShopsPlugin plugin) {
        if (instance != null) {
            throw new IllegalStateException("EzShopsAPI has already been initialized");
        }
        instance = new EzShopsAPI(plugin);
    }

    public static EzShopsAPI getInstance() {
        if (instance == null) {
            throw new IllegalStateException("EzShopsAPI has not been initialized. Make sure EzShops is enabled.");
        }
        return instance;
    }

    public ShopPriceService getShopAPI() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(ShopPriceService.class);
        return provider != null ? (ShopPriceService)provider.getProvider() : null;
    }

    public StockAPI getStockAPI() {
        return this.stockAPI;
    }

    public boolean isStockAPIAvailable() {
        return this.stockAPI != null;
    }

    public EzShopsPlugin getPlugin() {
        return this.plugin;
    }

    public static void shutdown() {
        instance = null;
    }
}

