/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops;

import com.skyblockexp.ezshops.api.EzShopsAPI;
import com.skyblockexp.ezshops.bootstrap.CoreShopComponent;
import com.skyblockexp.ezshops.bootstrap.MetricsComponent;
import com.skyblockexp.ezshops.bootstrap.PlayerShopComponent;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.ezshops.bootstrap.SignShopComponent;
import com.skyblockexp.ezshops.bootstrap.StockComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzShopsPlugin
extends JavaPlugin {
    private static final List<String> DEFAULT_SHOP_RESOURCES = List.of("shop.yml", "stock-gui.yml", "shop/menu.yml", "shop/categories/building.yml", "shop/categories/daily_specials.yml", "shop/categories/decorations.yml", "shop/categories/enchantments.yml", "shop/categories/farming.yml", "shop/categories/fishing.yml", "shop/categories/food.yml", "shop/categories/mining.yml", "shop/categories/mob_drops.yml", "shop/categories/redstone.yml", "shop/categories/spawners.yml", "shop/categories/valuables.yml", "shop/categories/wood.yml", "shop/rotations/daily-specials.yml", "messages/messages_en.yml", "messages/messages_es.yml", "messages/messages_nl.yml", "messages/messages_zh.yml");
    private Economy economy;
    private List<PluginComponent> components;
    private CoreShopComponent coreComponent;
    private StockComponent stockComponent;
    private boolean debugMode;

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault economy provider not found; disabling EzShops.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultResources();
        this.saveDefaultConfig();
        this.debugMode = this.getConfig().getBoolean("debug", false);
        if (this.debugMode) {
            this.getLogger().info("Debug mode is enabled. Verbose logging will be shown.");
        }
        this.coreComponent = new CoreShopComponent(this.economy);
        PlayerShopComponent playerShopComponent = new PlayerShopComponent(this.economy, this.getConfig());
        this.stockComponent = new StockComponent();
        this.components = new ArrayList<PluginComponent>();
        this.components.add(this.coreComponent);
        this.components.add(this.stockComponent);
        this.components.add(playerShopComponent);
        this.components.add(new SignShopComponent(this.coreComponent));
        this.components.add(new MetricsComponent());
        try {
            for (PluginComponent component : this.components) {
                component.enable(this);
            }
        }
        catch (RuntimeException ex) {
            this.getLogger().log(Level.SEVERE, "Failed to enable EzShops component", ex);
            throw ex;
        }
        try {
            EzShopsAPI.initialize(this);
            this.getLogger().info("EzShops API initialized successfully.");
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Failed to initialize EzShops API", ex);
        }
        this.getLogger().info("EzShops plugin enabled.");
    }

    public void onDisable() {
        try {
            EzShopsAPI.shutdown();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error shutting down EzShops API", ex);
        }
        if (this.components != null) {
            ListIterator<PluginComponent> iterator = this.components.listIterator(this.components.size());
            while (iterator.hasPrevious()) {
                PluginComponent component = iterator.previous();
                try {
                    component.disable();
                }
                catch (RuntimeException ex) {
                    this.getLogger().log(Level.SEVERE, "Failed to disable EzShops component " + component.getClass().getSimpleName(), ex);
                }
            }
            this.components = null;
        }
        this.economy = null;
        this.getLogger().info("EzShops plugin disabled.");
    }

    public CoreShopComponent getCoreShopComponent() {
        return this.coreComponent;
    }

    public StockComponent getStockComponent() {
        return this.stockComponent;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            return false;
        }
        this.economy = (Economy)registration.getProvider();
        return this.economy != null;
    }

    private void saveDefaultResources() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.getLogger().warning("Unable to create plugin data folder for default EzShops configuration.");
            return;
        }
        for (String resourcePath : DEFAULT_SHOP_RESOURCES) {
            this.saveResourceIfAbsent(resourcePath);
        }
    }

    private void saveResourceIfAbsent(String resourcePath) {
        File destination = new File(this.getDataFolder(), resourcePath.replace('/', File.separatorChar));
        if (destination.exists()) {
            return;
        }
        File parent = destination.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            this.getLogger().warning("Unable to create directory for default resource: " + parent.getAbsolutePath());
            return;
        }
        try {
            this.saveResource(resourcePath, false);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warning("Missing packaged resource '" + resourcePath + "': " + ex.getMessage());
        }
    }
}

