/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.shop.sign;

import com.skyblockexp.shop.ShopMenuLayout;
import com.skyblockexp.shop.ShopPricingManager;
import com.skyblockexp.shop.ShopSignListener;
import com.skyblockexp.shop.sign.SignShopGenerator;
import com.skyblockexp.shop.sign.SignShopPlan;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SignShopSetupMenu
implements Listener {
    private static final int INVENTORY_SIZE = 45;
    private static final int SLOT_INFO = 4;
    private static final int SLOT_ACTION = 10;
    private static final int SLOT_BACKGROUND = 12;
    private static final int SLOT_DIRECTION = 14;
    private static final int SLOT_SIGN_MATERIAL = 16;
    private static final List<Integer> ITEM_SLOTS = List.of(Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(25));
    private static final int SLOT_HORIZONTAL_SPACING_MINUS = 28;
    private static final int SLOT_HORIZONTAL_SPACING_DISPLAY = 31;
    private static final int SLOT_HORIZONTAL_SPACING_PLUS = 34;
    private static final int SLOT_ROW_COUNT_MINUS = 29;
    private static final int SLOT_ROW_COUNT_DISPLAY = 32;
    private static final int SLOT_ROW_COUNT_PLUS = 33;
    private static final int SLOT_ROW_SPACING_MINUS = 30;
    private static final int SLOT_ROW_SPACING_DISPLAY = 35;
    private static final int SLOT_ROW_SPACING_PLUS = 36;
    private static final int SLOT_CLEAR_ITEMS = 37;
    private static final int SLOT_CONFIRM = 40;
    private static final int CATALOG_INVENTORY_SIZE = 54;
    private static final int CATALOG_ITEMS_PER_PAGE = 45;
    private static final int CATALOG_SLOT_INSTRUCTIONS = 46;
    private static final int CATALOG_SLOT_PAGE_INFO = 48;
    private static final int CATALOG_SLOT_BACK = 49;
    private static final int CATALOG_SLOT_SOURCE_TOGGLE = 50;
    private static final int CATALOG_SLOT_SEARCH = 51;
    private static final int CATALOG_SLOT_PREVIOUS = 45;
    private static final int CATALOG_SLOT_NEXT = 53;
    private final JavaPlugin plugin;
    private final SignShopGenerator generator;
    private final ShopPricingManager pricingManager;
    private final Map<UUID, MenuState> openMenus;
    private static final List<Material> WALL_SIGN_MATERIALS;

    public SignShopSetupMenu(JavaPlugin plugin, SignShopGenerator generator, ShopPricingManager pricingManager) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.generator = Objects.requireNonNull(generator, "generator");
        this.pricingManager = pricingManager;
        this.openMenus = new HashMap<UUID, MenuState>();
    }

    public void open(Player player) {
        if (player == null) {
            return;
        }
        UUID id = player.getUniqueId();
        MenuState state = this.openMenus.computeIfAbsent(id, ignored -> new MenuState());
        state.selectionInventory = null;
        state.selectionEntries = List.of();
        state.selectionPage = 0;
        state.reopenToPlanner = false;
        state.awaitingSearchInput = false;
        state.pendingItemSlot = state.pendingItemSlot < 0 ? -1 : Math.min(state.pendingItemSlot, state.items.size() - 1);
        state.inventory = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)(String.valueOf(ChatColor.GREEN) + "Sign Shop Setup"));
        this.redraw(state);
        player.openInventory(state.inventory);
        if (!state.instructionsShown) {
            state.instructionsShown = true;
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Left-click a slot to browse shop items or right-click to use one from your inventory.");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Look at the block that should sit behind the first sign before clicking Confirm.");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Use the direction toggle to choose whether signs extend left or right from that block.");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Adjust the row and spacing controls to stack signs vertically or add gaps between them.");
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Shift-click filled slots to fine tune their quantities.");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Close the menu to pause setup. Run /signshopsetup again to resume or use /signshopsetup cancel to discard.");
        }
    }

    public boolean cancel(Player player) {
        if (player == null) {
            return false;
        }
        MenuState state = this.openMenus.remove(player.getUniqueId());
        if (state == null) {
            return false;
        }
        state.awaitingSearchInput = false;
        state.selectionInventory = null;
        state.inventory = null;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                player.closeInventory();
            }
        });
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        MenuState state = this.openMenus.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        Inventory topInventory = player.getOpenInventory().getTopInventory();
        Inventory clickedInventory = event.getClickedInventory();
        if (state.selectionInventory != null && topInventory.equals((Object)state.selectionInventory)) {
            if (clickedInventory != null && clickedInventory.equals((Object)state.selectionInventory)) {
                this.handleItemCatalogClick(event, player, state);
            } else {
                event.setCancelled(true);
            }
            return;
        }
        if (state.inventory == null) {
            return;
        }
        if (clickedInventory == null || !clickedInventory.equals((Object)state.inventory)) {
            if (topInventory.equals((Object)state.inventory) && clickedInventory != null) {
                this.handlePlayerInventoryClick(event, player, state);
            }
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= state.inventory.getSize()) {
            return;
        }
        if (slot == 10) {
            state.action = this.toggle(state.action);
            this.redraw(state);
            return;
        }
        if (slot == 12) {
            if (event.getClick().isRightClick()) {
                state.awaitingBackground = false;
                boolean bl = state.keepExistingBackground = !state.keepExistingBackground;
                if (!state.keepExistingBackground && state.background == null) {
                    state.background = SignShopPlan.DEFAULT_BACKGROUND;
                }
                if (state.keepExistingBackground) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Existing backing blocks will be kept when generating the sign shops.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Backing blocks will be replaced with " + this.readable(state.background) + ".");
                }
                this.redraw(state);
            } else {
                state.awaitingBackground = true;
                state.keepExistingBackground = false;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Click a block in your inventory to use it as the background behind each sign.");
            }
            return;
        }
        if (slot == 14) {
            state.direction = this.toggle(state.direction);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sign shops will extend to the " + (state.direction == SignShopPlan.LayoutDirection.RIGHT ? "right" : "left") + ".");
            this.redraw(state);
            return;
        }
        if (slot == 16) {
            state.signMaterial = this.cycleSignMaterial(state.signMaterial, event.getClick() == ClickType.RIGHT ? -1 : 1);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Wall sign material set to " + this.readable(state.signMaterial) + ".");
            this.redraw(state);
            return;
        }
        if (slot == 28) {
            state.spacing = Math.max(0, state.spacing - 1);
            this.redraw(state);
            return;
        }
        if (slot == 34) {
            state.spacing = Math.min(8, state.spacing + 1);
            this.redraw(state);
            return;
        }
        if (slot == 29) {
            state.rows = Math.max(1, state.rows - 1);
            this.redraw(state);
            return;
        }
        if (slot == 33) {
            state.rows = Math.min(ITEM_SLOTS.size(), state.rows + 1);
            this.redraw(state);
            return;
        }
        if (slot == 30) {
            state.rowSpacing = Math.max(0, state.rowSpacing - 1);
            this.redraw(state);
            return;
        }
        if (slot == 36) {
            state.rowSpacing = Math.min(8, state.rowSpacing + 1);
            this.redraw(state);
            return;
        }
        if (slot == 37) {
            for (int i = 0; i < state.items.size(); ++i) {
                state.items.set(i, null);
            }
            state.pendingItemSlot = -1;
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Cleared all planned sign items.");
            this.redraw(state);
            return;
        }
        if (slot == 31 || slot == 32 || slot == 35) {
            return;
        }
        if (slot == 40) {
            this.confirm(player, state);
            return;
        }
        int itemIndex = ITEM_SLOTS.indexOf(slot);
        if (itemIndex >= 0) {
            this.handlePlannerItemSlotClick(event, player, state, itemIndex);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        MenuState state = this.openMenus.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        if (state.selectionInventory != null && state.selectionInventory.equals((Object)event.getInventory())) {
            state.selectionInventory = null;
            state.selectionEntries = List.of();
            state.pendingItemSlot = -1;
            state.awaitingSearchInput = false;
            if (state.reopenToPlanner) {
                state.reopenToPlanner = false;
                return;
            }
            if (state.inventory != null && this.openMenus.containsKey(player.getUniqueId())) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!player.getOpenInventory().getTopInventory().equals((Object)state.inventory) && player.isOnline()) {
                        player.openInventory(state.inventory);
                    }
                });
            }
            return;
        }
        if (state.inventory != null && state.inventory.equals((Object)event.getInventory())) {
            if (state.selectionInventory != null) {
                return;
            }
            state.inventory = null;
            state.awaitingBackground = false;
            state.pendingItemSlot = -1;
            state.reopenToPlanner = false;
            state.awaitingSearchInput = false;
            state.selectionInventory = null;
            state.selectionEntries = List.of();
            state.selectionPage = 0;
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.openMenus.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        MenuState state = this.openMenus.get(player.getUniqueId());
        if (state == null || !state.awaitingSearchInput) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleCatalogSearchInput(player, state, message));
    }

    private void handlePlayerInventoryClick(InventoryClickEvent event, Player player, MenuState state) {
        event.setCancelled(true);
        if (event.getRawSlot() < state.inventory.getSize()) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (state.awaitingBackground) {
            if (!clicked.getType().isBlock()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please choose a block item for the background.");
                return;
            }
            state.background = clicked.getType();
            state.awaitingBackground = false;
            state.keepExistingBackground = false;
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Background block set to " + this.readable(clicked.getType()) + ". Existing backing blocks will be replaced.");
            this.redraw(state);
            return;
        }
        int targetIndex = state.pendingItemSlot;
        if (targetIndex < 0 && (targetIndex = this.firstEmptySlot(state.items)) < 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "All sign item slots are full. Remove one before adding another.");
            return;
        }
        ItemStack sanitized = this.sanitizeItem(clicked);
        if (sanitized == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That item cannot be used for a shop sign.");
            return;
        }
        if (!this.generator.isActionSupported(state.action, sanitized.getType())) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Warning: the shop does not currently have a price configured for that item. The sign will show as unavailable.");
        }
        state.items.set(targetIndex, sanitized);
        state.pendingItemSlot = -1;
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + sanitized.getAmount() + "x " + this.readable(sanitized.getType()) + " to slot " + (targetIndex + 1) + ".");
        this.redraw(state);
    }

    private void handlePlannerItemSlotClick(InventoryClickEvent event, Player player, MenuState state, int itemIndex) {
        ItemStack existing = state.items.get(itemIndex);
        ClickType click = event.getClick();
        if (click == ClickType.SHIFT_LEFT) {
            this.adjustSlotQuantity(player, state, itemIndex, 1);
            return;
        }
        if (click == ClickType.SHIFT_RIGHT) {
            this.adjustSlotQuantity(player, state, itemIndex, -1);
            return;
        }
        if (event.isRightClick()) {
            if (existing != null) {
                state.items.set(itemIndex, null);
                if (state.pendingItemSlot == itemIndex) {
                    state.pendingItemSlot = -1;
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removed the item from slot " + (itemIndex + 1) + ".");
                this.redraw(state);
            } else {
                if (state.pendingItemSlot == itemIndex) {
                    state.pendingItemSlot = -1;
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Cancelled inventory selection for slot " + (itemIndex + 1) + ".");
                } else {
                    state.pendingItemSlot = itemIndex;
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Click an item in your inventory to assign it to slot " + (itemIndex + 1) + ".");
                }
                this.redraw(state);
            }
            return;
        }
        state.pendingItemSlot = itemIndex;
        this.openItemCatalog(player, state);
    }

    private void adjustSlotQuantity(Player player, MenuState state, int itemIndex, int delta) {
        ItemStack existing = state.items.get(itemIndex);
        if (existing == null) {
            return;
        }
        int current = existing.getAmount();
        int updated = Math.max(1, Math.min(64, current + delta));
        if (updated == current) {
            if (updated == 64 && delta > 0) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Slot " + (itemIndex + 1) + " is already at the maximum quantity.");
            } else if (updated == 1 && delta < 0) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Slot " + (itemIndex + 1) + " is already at the minimum quantity.");
            }
            return;
        }
        ItemStack replacement = existing.clone();
        replacement.setAmount(updated);
        state.items.set(itemIndex, replacement);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Adjusted slot " + (itemIndex + 1) + " to " + updated + " items per sign.");
        this.redraw(state);
    }

    private void openItemCatalog(Player player, MenuState state) {
        this.ensureCatalogSource(state);
        state.selectionEntries = this.buildCatalogEntries(state);
        state.selectionPage = 0;
        state.awaitingSearchInput = false;
        state.selectionInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(ChatColor.GREEN) + "Select Sign Item"));
        state.reopenToPlanner = false;
        this.redrawItemCatalog(state);
        player.openInventory(state.selectionInventory);
    }

    private void handleItemCatalogClick(InventoryClickEvent event, Player player, MenuState state) {
        int targetIndex;
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= state.selectionInventory.getSize()) {
            return;
        }
        if (slot != 51 && state.awaitingSearchInput) {
            state.awaitingSearchInput = false;
            this.redrawItemCatalog(state);
        }
        if (slot == 45) {
            if (state.selectionPage > 0) {
                --state.selectionPage;
                this.redrawItemCatalog(state);
            }
            return;
        }
        if (slot == 53) {
            int maxPage = Math.max(0, (state.selectionEntries.size() - 1) / 45);
            if (state.selectionPage < maxPage) {
                ++state.selectionPage;
                this.redrawItemCatalog(state);
            }
            return;
        }
        if (slot == 49) {
            state.pendingItemSlot = -1;
            state.reopenToPlanner = true;
            state.awaitingSearchInput = false;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(state.inventory));
            return;
        }
        if (slot == 50) {
            ItemCatalogSource nextSource = this.nextCatalogSource(state);
            if (nextSource != state.selectionCatalog) {
                state.selectionCatalog = nextSource;
            }
            state.selectionEntries = this.buildCatalogEntries(state);
            state.selectionPage = 0;
            this.redrawItemCatalog(state);
            return;
        }
        if (slot == 51) {
            this.handleCatalogSearchClick(player, state, event.getClick());
            return;
        }
        if (slot == 46 || slot == 48) {
            return;
        }
        if (slot >= 45) {
            return;
        }
        int index = state.selectionPage * 45 + slot;
        if (index < 0 || index >= state.selectionEntries.size()) {
            return;
        }
        CatalogEntry entry = state.selectionEntries.get(index);
        if (entry.type() == CatalogEntryType.CATEGORY) {
            this.handleCategorySelection(player, state, entry);
            return;
        }
        Material material = entry.material();
        if (material == null || material == Material.AIR) {
            return;
        }
        int amount = entry.useConfiguredAmount() ? entry.amount() : this.resolveSelectionAmount(event);
        amount = Math.max(1, Math.min(64, amount));
        ItemStack stack = new ItemStack(material, amount);
        if (!this.generator.isActionSupported(state.action, material)) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Warning: the shop does not currently have a price configured for that item. The sign will show as unavailable.");
        }
        int n = targetIndex = state.pendingItemSlot >= 0 ? state.pendingItemSlot : this.firstEmptySlot(state.items);
        if (targetIndex < 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "All sign item slots are full. Remove one before adding another.");
            return;
        }
        state.items.set(targetIndex, stack);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + amount + "x " + this.readable(material) + " to slot " + (targetIndex + 1) + ".");
        this.redraw(state);
        state.pendingItemSlot = -1;
        state.awaitingSearchInput = false;
        state.reopenToPlanner = true;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(state.inventory));
    }

    private void handleCategorySelection(Player player, MenuState state, CatalogEntry entry) {
        int total;
        int startIndex;
        List<ItemStack> categoryItems = entry.categoryItems();
        if (categoryItems.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No items are configured for that category.");
            return;
        }
        int n = startIndex = state.pendingItemSlot >= 0 ? state.pendingItemSlot : this.firstEmptySlot(state.items);
        if (startIndex < 0 || startIndex >= state.items.size()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "All sign item slots are full. Remove one before adding another.");
            return;
        }
        int placed = 0;
        int target = startIndex;
        for (ItemStack stack : categoryItems) {
            if (target >= state.items.size()) break;
            state.items.set(target, stack.clone());
            ++target;
            ++placed;
        }
        if (placed <= 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No sign item slots were available for that category.");
            return;
        }
        state.pendingItemSlot = -1;
        this.redraw(state);
        String categoryName = entry.categoryName();
        if (categoryName == null || categoryName.isBlank()) {
            categoryName = "category";
        }
        if (placed == (total = categoryItems.size())) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + placed + " item" + (placed == 1 ? "" : "s") + " from " + categoryName + " to the plan.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Added " + placed + " of " + total + " item" + (total == 1 ? "" : "s") + " from " + categoryName + ". Increase rows or clear slots to fit the rest.");
        }
        LinkedHashSet<String> unsupported = new LinkedHashSet<String>();
        for (int i = 0; i < placed; ++i) {
            ItemStack added = categoryItems.get(i);
            if (this.generator.isActionSupported(state.action, added.getType())) continue;
            unsupported.add(this.readable(added.getType()));
        }
        if (!unsupported.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Warning: the shop does not currently have prices for " + String.join((CharSequence)", ", unsupported) + " when " + (state.action == ShopSignListener.SignAction.BUY ? "buying" : "selling") + ".");
        }
        state.awaitingSearchInput = false;
        state.reopenToPlanner = true;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(state.inventory));
    }

    private void handleCatalogSearchClick(Player player, MenuState state, ClickType click) {
        if (click == ClickType.RIGHT || click == ClickType.SHIFT_RIGHT) {
            if (state.selectionSearch == null || state.selectionSearch.isBlank()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Search filter is already cleared.");
            } else {
                state.selectionSearch = null;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Cleared catalog search filter.");
            }
            state.awaitingSearchInput = false;
            state.selectionEntries = this.buildCatalogEntries(state);
            state.selectionPage = 0;
            this.redrawItemCatalog(state);
            return;
        }
        state.awaitingSearchInput = true;
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Type your search in chat to filter catalog items.");
        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Type 'clear' to remove the filter or 'cancel' to keep it.");
        this.redrawItemCatalog(state);
    }

    private void handleCatalogSearchInput(Player player, MenuState state, String message) {
        state.awaitingSearchInput = false;
        String raw = message == null ? "" : message.trim();
        String stripped = ChatColor.stripColor((String)raw);
        if (stripped != null) {
            raw = stripped.trim();
        }
        if (raw.length() > 48) {
            raw = raw.substring(0, 48);
        }
        if (raw.equalsIgnoreCase("cancel")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Search unchanged.");
            this.redrawItemCatalog(state);
            if (state.selectionInventory != null && player.isOnline()) {
                player.openInventory(state.selectionInventory);
            }
            return;
        }
        if (raw.equalsIgnoreCase("clear") || raw.isEmpty()) {
            if (state.selectionSearch == null || state.selectionSearch.isBlank()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Search filter was already cleared.");
            } else {
                state.selectionSearch = null;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Cleared catalog search filter.");
            }
        } else {
            state.selectionSearch = raw;
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Filtering catalog for \"" + raw + "\".");
        }
        state.selectionEntries = this.buildCatalogEntries(state);
        state.selectionPage = 0;
        if (state.selectionEntries.isEmpty() && state.selectionSearch != null && !state.selectionSearch.isBlank()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No items matched that search.");
        }
        this.redrawItemCatalog(state);
        if (state.selectionInventory != null && player.isOnline()) {
            player.openInventory(state.selectionInventory);
        }
    }

    private int resolveSelectionAmount(InventoryClickEvent event) {
        ClickType click = event.getClick();
        if (click == ClickType.RIGHT) {
            return 16;
        }
        if (click == ClickType.SHIFT_LEFT || click == ClickType.SHIFT_RIGHT) {
            return 32;
        }
        if (click == ClickType.MIDDLE || click == ClickType.CONTROL_DROP) {
            return 64;
        }
        if (click == ClickType.DROP) {
            return 8;
        }
        if (click == ClickType.NUMBER_KEY) {
            return Math.min(64, Math.max(1, event.getHotbarButton() + 1));
        }
        return 1;
    }

    private void redrawItemCatalog(MenuState state) {
        int index;
        Inventory catalog = state.selectionInventory;
        if (catalog == null) {
            return;
        }
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.DARK_GRAY), List.of());
        for (int i = 0; i < catalog.getSize(); ++i) {
            catalog.setItem(i, filler);
        }
        int maxIndex = Math.max(0, state.selectionEntries.size() - 1);
        int maxPage = Math.max(0, maxIndex / 45);
        if (state.selectionPage > maxPage) {
            state.selectionPage = maxPage;
        }
        int start = state.selectionPage * 45;
        for (int i = 0; i < 45 && (index = start + i) < state.selectionEntries.size(); ++i) {
            CatalogEntry entry = state.selectionEntries.get(index);
            if (entry == null) continue;
            catalog.setItem(i, this.createCatalogItem(entry, state));
        }
        if (state.selectionEntries.isEmpty()) {
            catalog.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "No matching items", List.of(String.valueOf(ChatColor.YELLOW) + "Adjust your search filter or source.")));
        }
        boolean hasPrevious = state.selectionPage > 0;
        boolean hasNext = state.selectionPage < maxPage;
        catalog.setItem(45, hasPrevious ? this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Previous Page", List.of(String.valueOf(ChatColor.GRAY) + "Go to page " + state.selectionPage + " of " + (maxPage + 1))) : this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "No previous page", List.of()));
        catalog.setItem(53, hasNext ? this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Next Page", List.of(String.valueOf(ChatColor.GRAY) + "Go to page " + (state.selectionPage + 2) + " of " + (maxPage + 1))) : this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "No next page", List.of()));
        catalog.setItem(49, this.createItem(Material.OAK_DOOR, String.valueOf(ChatColor.GOLD) + "Return to planner", List.of(String.valueOf(ChatColor.YELLOW) + "Leave the catalog without picking an item.")));
        catalog.setItem(50, this.createCatalogSourceItem(state));
        catalog.setItem(51, this.createCatalogSearchItem(state));
        catalog.setItem(46, this.createItem(Material.BOOK, String.valueOf(ChatColor.AQUA) + "Selection Controls", List.of(String.valueOf(ChatColor.YELLOW) + "Left-click: quantity 1", String.valueOf(ChatColor.YELLOW) + "Right-click: quantity 16", String.valueOf(ChatColor.YELLOW) + "Shift-click: quantity 32", String.valueOf(ChatColor.YELLOW) + "Middle-click: quantity 64", String.valueOf(ChatColor.YELLOW) + "Number keys: quantity 1-9", String.valueOf(ChatColor.YELLOW) + "Use the search icon to filter items.", String.valueOf(ChatColor.GRAY) + "Adjust in planner with shift-clicks.")));
        catalog.setItem(48, this.createItem(Material.PAPER, String.valueOf(ChatColor.GOLD) + "Page " + (state.selectionPage + 1) + " of " + Math.max(1, maxPage + 1), List.of()));
    }

    private ItemStack createCatalogItem(CatalogEntry entry, MenuState state) {
        if (entry.type() == CatalogEntryType.CATEGORY) {
            int size;
            ItemStack stack;
            ItemMeta meta;
            Material icon = entry.material();
            if (icon == null || icon == Material.AIR) {
                icon = Material.CHEST;
            }
            if ((meta = (stack = new ItemStack(icon)).getItemMeta()) == null) {
                return stack;
            }
            Object displayName = entry.displayName();
            if (displayName == null || ((String)displayName).isBlank()) {
                displayName = String.valueOf(ChatColor.AQUA) + "Use Category";
            }
            meta.setDisplayName((String)displayName);
            ArrayList<String> lore = new ArrayList<String>(entry.extraLore());
            String categoryName = entry.categoryName();
            if (categoryName != null && !categoryName.isBlank()) {
                lore.add(String.valueOf(ChatColor.YELLOW) + "Category: " + categoryName);
            }
            if ((size = entry.categoryItems().size()) > 0) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Contains " + size + " item" + (size == 1 ? "" : "s") + ".");
            }
            meta.setLore(lore);
            meta.addItemFlags(ItemFlag.values());
            stack.setItemMeta(meta);
            return stack;
        }
        Material material = entry.material();
        if (material == null || material == Material.AIR) {
            return new ItemStack(Material.BARRIER);
        }
        ItemStack stack = new ItemStack(material, Math.max(1, Math.min(64, entry.amount())));
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        Object displayName = entry.displayName();
        if (displayName == null || ((String)displayName).isBlank()) {
            displayName = String.valueOf(ChatColor.AQUA) + this.readable(material);
        }
        meta.setDisplayName((String)displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        if (!entry.extraLore().isEmpty()) {
            lore.addAll(entry.extraLore());
        }
        boolean supported = this.generator.isActionSupported(state.action, material);
        if (this.pricingManager != null) {
            this.pricingManager.getPrice(material).ifPresentOrElse(price -> {
                if (state.action == ShopSignListener.SignAction.BUY) {
                    if (price.buyPrice() >= 0.0) {
                        lore.add(String.valueOf(ChatColor.GRAY) + "Buy price configured.");
                    } else {
                        lore.add(String.valueOf(ChatColor.RED) + "Cannot buy from shop.");
                    }
                } else if (price.sellPrice() >= 0.0) {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Sell price configured.");
                } else {
                    lore.add(String.valueOf(ChatColor.RED) + "Cannot sell to shop.");
                }
            }, () -> lore.add(String.valueOf(ChatColor.RED) + "No price configured."));
        } else if (supported) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Price configured for this action.");
        } else {
            lore.add(String.valueOf(ChatColor.RED) + "Price not configured for this action.");
        }
        if (entry.useConfiguredAmount()) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Uses shop amount: " + entry.amount());
            lore.add(String.valueOf(ChatColor.YELLOW) + "Click to add this option.");
            lore.add(String.valueOf(ChatColor.GRAY) + "Adjust quantity later with shift-clicks.");
        } else if (entry.showQuantityShortcuts()) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Left-click: quantity 1");
            lore.add(String.valueOf(ChatColor.YELLOW) + "Right-click: quantity 16");
            lore.add(String.valueOf(ChatColor.YELLOW) + "Shift-click: quantity 32");
            lore.add(String.valueOf(ChatColor.YELLOW) + "Middle-click: quantity 64");
            lore.add(String.valueOf(ChatColor.YELLOW) + "Number keys: quantity 1-9");
            lore.add(String.valueOf(ChatColor.GRAY) + "Adjust in planner with shift-clicks.");
        }
        if (!entry.useConfiguredAmount() && !entry.showQuantityShortcuts()) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "Click to add this item.");
        }
        meta.setLore(lore);
        meta.addItemFlags(ItemFlag.values());
        stack.setItemMeta(meta);
        return stack;
    }

    private ItemStack createCatalogSearchItem(MenuState state) {
        boolean hasQuery;
        boolean awaiting = state.awaitingSearchInput;
        String query = state.selectionSearch;
        boolean bl = hasQuery = query != null && !query.isBlank();
        Material icon = awaiting ? Material.WRITABLE_BOOK : (hasQuery ? Material.NAME_TAG : Material.COMPASS);
        ItemStack stack = new ItemStack(icon);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        if (hasQuery) {
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Filter: " + query)));
        }
        if (awaiting) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Waiting for search text");
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Type your search in chat now.")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Type 'cancel' to keep the current filter.")));
        } else if (hasQuery) {
            Object preview = query;
            if (((String)preview).length() > 24) {
                preview = ((String)preview).substring(0, 24) + "...";
            }
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Search: " + (String)preview);
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click: enter new search")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Right-click: clear search")));
            if (state.selectionEntries.isEmpty()) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "No matches currently shown.")));
            }
        } else {
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Search Catalog");
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click: enter search text")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Right-click: clear search")));
        }
        meta.setLore(lore);
        meta.addItemFlags(ItemFlag.values());
        stack.setItemMeta(meta);
        return stack;
    }

    private ItemStack createCatalogSourceItem(MenuState state) {
        ItemCatalogSource source = this.ensureCatalogSource(state);
        ShopSignListener.SignAction action = state.action;
        return switch (source.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> this.createItem(Material.CHEST, String.valueOf(ChatColor.AQUA) + "Showing all materials", List.of(String.valueOf(ChatColor.YELLOW) + "Click to show only items configured for the current action."));
            case 1 -> this.createItem(Material.ITEM_FRAME, String.valueOf(ChatColor.AQUA) + "Showing shop options", List.of(String.valueOf(ChatColor.YELLOW) + "Click to browse every material."));
            case 0 -> {
                String mode = action == ShopSignListener.SignAction.BUY ? "buy" : "sell";
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.valueOf(ChatColor.YELLOW) + "Click to browse shop options.");
                lore.add(String.valueOf(ChatColor.GRAY) + "Only items priced for " + mode + " are shown.");
                yield this.createItem(Material.EMERALD, String.valueOf(ChatColor.AQUA) + "Showing " + mode + " items", lore);
            }
        };
    }

    private List<CatalogEntry> buildCatalogEntries(MenuState state) {
        List<CatalogEntry> shopEntries;
        if (this.ensureCatalogSource(state) == ItemCatalogSource.SHOP && !(shopEntries = this.buildShopCatalogEntries()).isEmpty()) {
            return this.filterCatalogEntries(state, shopEntries);
        }
        return this.filterCatalogEntries(state, this.buildMaterialCatalogEntries(state));
    }

    private List<CatalogEntry> buildShopCatalogEntries() {
        if (this.pricingManager == null) {
            return List.of();
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        if (layout == null || layout.categories().isEmpty()) {
            return List.of();
        }
        ArrayList<CatalogEntry> entries = new ArrayList<CatalogEntry>();
        for (ShopMenuLayout.Category category : layout.categories()) {
            if (category == null) continue;
            ArrayList<ShopMenuLayout.Item> items = new ArrayList<ShopMenuLayout.Item>(category.items());
            items.sort(Comparator.comparingInt(ShopMenuLayout.Item::slot));
            if (items.isEmpty()) continue;
            String categoryName = this.stripColorOrFallback(category.displayName(), category.id());
            ShopMenuLayout.CategoryRotation rotation = category.rotation();
            String rotationInfo = rotation != null ? rotation.optionId() : null;
            ArrayList<ItemStack> categoryStacks = new ArrayList<ItemStack>();
            ArrayList<CatalogEntry> categoryEntries = new ArrayList<CatalogEntry>();
            for (ShopMenuLayout.Item item : items) {
                Object displayName;
                ItemStack stack;
                Material material;
                if (item == null || (material = item.material()) == null || !material.isItem() || (stack = this.sanitizeItem(new ItemStack(material, Math.max(1, Math.min(64, item.amount()))))) == null) continue;
                categoryStacks.add(stack);
                Object object = displayName = item.display() != null ? item.display().displayName() : null;
                if (displayName == null || ((String)displayName).isBlank()) {
                    displayName = String.valueOf(ChatColor.AQUA) + this.readable(material);
                }
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.valueOf(ChatColor.YELLOW) + "Category: " + categoryName);
                if (rotationInfo != null && !rotationInfo.isEmpty()) {
                    lore.add(String.valueOf(ChatColor.GRAY) + "Rotation option: " + rotationInfo);
                }
                categoryEntries.add(new CatalogEntry(CatalogEntryType.ITEM, material, stack.getAmount(), (String)displayName, lore, true, false, List.of(), null));
            }
            if (categoryEntries.isEmpty()) continue;
            CatalogEntry categoryEntry = this.createCategoryCatalogEntry(categoryName, rotationInfo, categoryStacks);
            entries.add((CatalogEntry)categoryEntries.get(0));
            if (categoryEntry != null) {
                entries.add(categoryEntry);
            }
            for (int i = 1; i < categoryEntries.size(); ++i) {
                entries.add((CatalogEntry)categoryEntries.get(i));
            }
        }
        return List.copyOf(entries);
    }

    private List<CatalogEntry> buildMaterialCatalogEntries(MenuState state) {
        ItemCatalogSource catalogSource = this.ensureCatalogSource(state);
        LinkedHashSet<Object> materials = new LinkedHashSet<Object>();
        if (this.pricingManager != null) {
            Object base;
            if (catalogSource == ItemCatalogSource.ACTION) {
                Object object = base = state.action == ShopSignListener.SignAction.BUY ? this.pricingManager.getBuyableMaterials() : this.pricingManager.getSellableMaterials();
                if (base == null || base.isEmpty()) {
                    base = this.pricingManager.getConfiguredMaterials();
                }
            } else {
                base = this.pricingManager.getConfiguredMaterials();
            }
            if (base != null) {
                Iterator iterator = base.iterator();
                while (iterator.hasNext()) {
                    Material material = (Material)iterator.next();
                    if (material == null || !material.isItem()) continue;
                    materials.add(material);
                }
            }
        }
        if (catalogSource == ItemCatalogSource.ALL || materials.isEmpty()) {
            for (Material material : Material.values()) {
                if (material == null || !material.isItem()) continue;
                materials.add(material);
            }
        }
        ArrayList<Material> sorted = new ArrayList<Material>(materials);
        sorted.sort(Comparator.comparing(Enum::name));
        ArrayList<CatalogEntry> entries = new ArrayList<CatalogEntry>(sorted.size());
        for (Material material : sorted) {
            entries.add(new CatalogEntry(CatalogEntryType.ITEM, material, 1, String.valueOf(ChatColor.AQUA) + this.readable(material), List.of(), false, true, List.of(), null));
        }
        return List.copyOf(entries);
    }

    private CatalogEntry createCategoryCatalogEntry(String categoryName, String rotationInfo, List<ItemStack> categoryStacks) {
        if (categoryStacks == null || categoryStacks.isEmpty()) {
            return null;
        }
        String readableName = categoryName == null || categoryName.isBlank() ? "category" : categoryName;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.YELLOW) + "Click to add the entire category.");
        lore.add(String.valueOf(ChatColor.GRAY) + "Items added: " + categoryStacks.size());
        if (rotationInfo != null && !rotationInfo.isEmpty()) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Rotation option: " + rotationInfo);
        }
        lore.add(String.valueOf(ChatColor.GRAY) + "Replaces planner slots starting here.");
        return new CatalogEntry(CatalogEntryType.CATEGORY, Material.CHEST, 1, String.valueOf(ChatColor.AQUA) + "Use Category: " + readableName, lore, false, false, categoryStacks, readableName);
    }

    private List<CatalogEntry> filterCatalogEntries(MenuState state, List<CatalogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return List.of();
        }
        String query = state.selectionSearch;
        if (query == null || query.isBlank()) {
            return entries;
        }
        String normalized = query.toLowerCase(Locale.ROOT);
        ArrayList<CatalogEntry> filtered = new ArrayList<CatalogEntry>();
        for (CatalogEntry entry : entries) {
            if (entry == null || !this.catalogEntryMatchesQuery(entry, normalized)) continue;
            filtered.add(entry);
        }
        if (filtered.isEmpty()) {
            return List.of();
        }
        return List.copyOf(filtered);
    }

    private boolean catalogEntryMatchesQuery(CatalogEntry entry, String normalizedQuery) {
        String stripped;
        String displayName;
        Material material = entry.material();
        if (material != null) {
            String materialName = material.name().toLowerCase(Locale.ROOT);
            if (materialName.contains(normalizedQuery)) {
                return true;
            }
            String readable = this.readable(material).toLowerCase(Locale.ROOT);
            if (readable.contains(normalizedQuery)) {
                return true;
            }
        }
        if ((displayName = entry.displayName()) != null && (stripped = ChatColor.stripColor((String)displayName)) != null && stripped.toLowerCase(Locale.ROOT).contains(normalizedQuery)) {
            return true;
        }
        for (String line : entry.extraLore()) {
            String stripped2;
            if (line == null || (stripped2 = ChatColor.stripColor((String)line)) == null || !stripped2.toLowerCase(Locale.ROOT).contains(normalizedQuery)) continue;
            return true;
        }
        return false;
    }

    private ItemCatalogSource nextCatalogSource(MenuState state) {
        ItemCatalogSource current = this.ensureCatalogSource(state);
        for (int i = 0; i < ItemCatalogSource.values().length; ++i) {
            if (!this.isCatalogSourceAvailable(current = current.next())) continue;
            return current;
        }
        return state.selectionCatalog;
    }

    private ItemCatalogSource ensureCatalogSource(MenuState state) {
        if (state.selectionCatalog == null) {
            state.selectionCatalog = this.determineInitialCatalogSource();
        }
        return state.selectionCatalog;
    }

    private ItemCatalogSource determineInitialCatalogSource() {
        ShopMenuLayout layout;
        if (this.pricingManager != null && (layout = this.pricingManager.getMenuLayout()) != null) {
            for (ShopMenuLayout.Category category : layout.categories()) {
                List<ShopMenuLayout.Item> items;
                if (category == null || (items = category.items()) == null || items.isEmpty()) continue;
                return ItemCatalogSource.SHOP;
            }
        }
        return ItemCatalogSource.ACTION;
    }

    private boolean isCatalogSourceAvailable(ItemCatalogSource source) {
        if (source != ItemCatalogSource.SHOP) {
            return true;
        }
        if (this.pricingManager == null) {
            return false;
        }
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        if (layout == null) {
            return false;
        }
        for (ShopMenuLayout.Category category : layout.categories()) {
            if (category == null) continue;
            for (ShopMenuLayout.Item item : category.items()) {
                Material material;
                if (item == null || (material = item.material()) == null || !material.isItem()) continue;
                return true;
            }
        }
        return false;
    }

    private String stripColorOrFallback(String text, String fallback) {
        String stripped;
        if (text != null && !text.isBlank() && (stripped = ChatColor.stripColor((String)text)) != null && !stripped.isBlank()) {
            return stripped;
        }
        return fallback == null ? "" : fallback;
    }

    private void confirm(Player player, MenuState state) {
        Material backgroundMaterial = state.keepExistingBackground ? null : (state.background == null ? SignShopPlan.DEFAULT_BACKGROUND : state.background);
        SignShopPlan plan = new SignShopPlan(state.items, backgroundMaterial, state.signMaterial, state.spacing, state.rows, state.rowSpacing, state.action, state.direction);
        if (plan.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Add at least one item before generating sign shops.");
            return;
        }
        SignShopGenerator.GenerationResult result = this.generator.generate(player, plan);
        player.sendMessage(String.valueOf(result.success() ? ChatColor.GREEN : ChatColor.RED) + result.message());
        if (result.success()) {
            this.openMenus.remove(player.getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.closeInventory());
        }
    }

    private void redraw(MenuState state) {
        int i;
        Inventory inventory = state.inventory;
        inventory.clear();
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.DARK_GRAY), List.of());
        for (i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, filler);
        }
        inventory.setItem(4, this.createItem(Material.WRITABLE_BOOK, String.valueOf(ChatColor.GOLD) + "Sign Shop Planner", List.of(String.valueOf(ChatColor.YELLOW) + "Left-click slots to browse the catalog.", String.valueOf(ChatColor.YELLOW) + "Right-click slots to use items from your inventory.", String.valueOf(ChatColor.YELLOW) + "Shift-click filled slots to tweak quantities.", String.valueOf(ChatColor.YELLOW) + "Adjust spacing and rows to tune the final layout.")));
        inventory.setItem(10, this.createActionItem(state.action));
        inventory.setItem(12, this.createBackgroundItem(state.background, state.awaitingBackground, state.keepExistingBackground));
        inventory.setItem(14, this.createDirectionItem(state.direction));
        inventory.setItem(16, this.createSignMaterialItem(state.signMaterial));
        for (i = 0; i < ITEM_SLOTS.size(); ++i) {
            ItemStack display;
            ItemStack planned = state.items.get(i);
            int slot = ITEM_SLOTS.get(i);
            if (planned == null) {
                display = state.pendingItemSlot == i ? this.createItem(Material.GLOWSTONE_DUST, String.valueOf(ChatColor.GOLD) + "Awaiting inventory item", List.of(String.valueOf(ChatColor.YELLOW) + "Click an item in your inventory.", String.valueOf(ChatColor.YELLOW) + "Left-click here to open the catalog instead.", String.valueOf(ChatColor.YELLOW) + "Right-click to cancel.")) : this.createItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, String.valueOf(ChatColor.GRAY) + "Empty Slot", List.of(String.valueOf(ChatColor.YELLOW) + "Left-click: open catalog", String.valueOf(ChatColor.YELLOW) + "Right-click: use inventory item"));
            } else {
                display = planned.clone();
                ItemMeta meta = display.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.AQUA) + this.readable(planned.getType()));
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Quantity: " + planned.getAmount())));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click: change item")));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Right-click: clear slot")));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Shift-click: adjust quantity")));
                if (!this.generator.isActionSupported(state.action, planned.getType())) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Price missing for this action.")));
                }
                meta.setLore(lore);
                meta.addItemFlags(ItemFlag.values());
                display.setItemMeta(meta);
            }
            inventory.setItem(slot, display);
        }
        inventory.setItem(28, this.createItem(Material.REDSTONE_TORCH, String.valueOf(ChatColor.RED) + "Decrease horizontal gap", List.of(String.valueOf(ChatColor.YELLOW) + "Current spacing: " + state.spacing)));
        inventory.setItem(34, this.createItem(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "Increase horizontal gap", List.of(String.valueOf(ChatColor.YELLOW) + "Current spacing: " + state.spacing)));
        inventory.setItem(31, this.createItem(Material.CLOCK, String.valueOf(ChatColor.GOLD) + "Horizontal Spacing", List.of(String.valueOf(ChatColor.YELLOW) + "Gap between backing blocks: " + state.spacing + " block(s)")));
        inventory.setItem(29, this.createItem(Material.RED_CARPET, String.valueOf(ChatColor.RED) + "Fewer rows", List.of(String.valueOf(ChatColor.YELLOW) + "Rows planned: " + state.rows)));
        inventory.setItem(33, this.createItem(Material.LIME_CARPET, String.valueOf(ChatColor.GREEN) + "More rows", List.of(String.valueOf(ChatColor.YELLOW) + "Rows planned: " + state.rows)));
        inventory.setItem(32, this.createItem(Material.OAK_SIGN, String.valueOf(ChatColor.GOLD) + "Row Count", List.of(String.valueOf(ChatColor.YELLOW) + "Total rows generated: " + state.rows)));
        inventory.setItem(30, this.createItem(Material.REPEATER, String.valueOf(ChatColor.RED) + "Lower vertical gap", List.of(String.valueOf(ChatColor.YELLOW) + "Current vertical spacing: " + state.rowSpacing)));
        inventory.setItem(36, this.createItem(Material.SLIME_BALL, String.valueOf(ChatColor.GREEN) + "Raise vertical gap", List.of(String.valueOf(ChatColor.YELLOW) + "Current vertical spacing: " + state.rowSpacing)));
        inventory.setItem(35, this.createItem(Material.SCAFFOLDING, String.valueOf(ChatColor.GOLD) + "Vertical Spacing", List.of(String.valueOf(ChatColor.YELLOW) + "Blocks between rows: " + state.rowSpacing + " block(s)")));
        inventory.setItem(37, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Clear planned items", List.of(String.valueOf(ChatColor.YELLOW) + "Removes all configured sign entries")));
        inventory.setItem(40, this.createItem(Material.LIME_CONCRETE, String.valueOf(ChatColor.GREEN) + "Confirm & Generate", List.of(String.valueOf(ChatColor.YELLOW) + "Uses the block you are looking at", String.valueOf(ChatColor.YELLOW) + "for the first backing block.")));
    }

    private ItemStack createActionItem(ShopSignListener.SignAction action) {
        if (action == ShopSignListener.SignAction.SELL) {
            return this.createItem(Material.REDSTONE, String.valueOf(ChatColor.RED) + "Mode: Sell", List.of(String.valueOf(ChatColor.YELLOW) + "Players sell items to the shop."));
        }
        return this.createItem(Material.EMERALD, String.valueOf(ChatColor.GREEN) + "Mode: Buy", List.of(String.valueOf(ChatColor.YELLOW) + "Players buy items from the shop."));
    }

    private ItemStack createDirectionItem(SignShopPlan.LayoutDirection direction) {
        boolean right = direction == SignShopPlan.LayoutDirection.RIGHT;
        return this.createItem(right ? Material.COMPASS : Material.ARROW, String.valueOf(ChatColor.AQUA) + "Direction: " + (right ? "Right" : "Left"), List.of(String.valueOf(ChatColor.YELLOW) + "Determines which side future signs use.", String.valueOf(ChatColor.YELLOW) + "Click to toggle between left/right."));
    }

    private ItemStack createSignMaterialItem(Material signMaterial) {
        Material wallMaterial = signMaterial == null ? Material.OAK_WALL_SIGN : signMaterial;
        Material displayMaterial = this.resolveDisplaySignMaterial(wallMaterial);
        ItemStack stack = new ItemStack(displayMaterial);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Wall Sign: " + this.readable(wallMaterial));
        meta.setLore(List.of(String.valueOf(ChatColor.YELLOW) + "Left-click: next sign type", String.valueOf(ChatColor.YELLOW) + "Right-click: previous sign type"));
        meta.addItemFlags(ItemFlag.values());
        stack.setItemMeta(meta);
        return stack;
    }

    private Material resolveDisplaySignMaterial(Material wallMaterial) {
        String candidateName;
        Material candidate;
        if (!Tag.WALL_SIGNS.isTagged((Keyed)wallMaterial)) {
            return Material.OAK_SIGN;
        }
        String name = wallMaterial.name();
        if (name.endsWith("_WALL_SIGN") && (candidate = Material.getMaterial((String)(candidateName = name.substring(0, name.length() - "_WALL_SIGN".length()) + "_SIGN"))) != null && candidate.isItem()) {
            return candidate;
        }
        return Material.OAK_SIGN;
    }

    private ItemStack createBackgroundItem(Material background, boolean awaitingSelection, boolean keepExisting) {
        if (awaitingSelection) {
            return this.createItem(Material.GLOWSTONE_DUST, String.valueOf(ChatColor.GOLD) + "Select a background block", List.of(String.valueOf(ChatColor.YELLOW) + "Click a block in your inventory"));
        }
        if (keepExisting) {
            return this.createItem(Material.LIME_DYE, String.valueOf(ChatColor.AQUA) + "Keep Existing Background", List.of(String.valueOf(ChatColor.YELLOW) + "Right-click: toggle keep/replace", String.valueOf(ChatColor.YELLOW) + "Left-click then pick a block", String.valueOf(ChatColor.GRAY) + "Existing backing blocks will remain unchanged."));
        }
        Material displayMaterial = background == null ? SignShopPlan.DEFAULT_BACKGROUND : background;
        ItemStack stack = new ItemStack(displayMaterial);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Background: " + this.readable(displayMaterial));
        meta.setLore(List.of(String.valueOf(ChatColor.YELLOW) + "Right-click: toggle keep/replace", String.valueOf(ChatColor.YELLOW) + "Left-click then pick a block", String.valueOf(ChatColor.GRAY) + "Backing blocks will be replaced with this material."));
        meta.addItemFlags(ItemFlag.values());
        stack.setItemMeta(meta);
        return stack;
    }

    private int firstEmptySlot(List<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i) != null) continue;
            return i;
        }
        return -1;
    }

    private ItemStack sanitizeItem(ItemStack original) {
        if (original == null || original.getType() == Material.AIR) {
            return null;
        }
        ItemStack sanitized = original.clone();
        sanitized.setAmount(Math.max(1, Math.min(64, sanitized.getAmount())));
        return sanitized;
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack stack = new ItemStack(material);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(name);
        if (lore != null && !lore.isEmpty()) {
            meta.setLore(lore);
        }
        meta.addItemFlags(ItemFlag.values());
        stack.setItemMeta(meta);
        return stack;
    }

    private ShopSignListener.SignAction toggle(ShopSignListener.SignAction action) {
        return action == ShopSignListener.SignAction.BUY ? ShopSignListener.SignAction.SELL : ShopSignListener.SignAction.BUY;
    }

    private SignShopPlan.LayoutDirection toggle(SignShopPlan.LayoutDirection direction) {
        return direction == SignShopPlan.LayoutDirection.RIGHT ? SignShopPlan.LayoutDirection.LEFT : SignShopPlan.LayoutDirection.RIGHT;
    }

    private Material cycleSignMaterial(Material current, int delta) {
        int next;
        int index;
        if (WALL_SIGN_MATERIALS.isEmpty()) {
            return Material.OAK_WALL_SIGN;
        }
        int n = index = current == null ? -1 : WALL_SIGN_MATERIALS.indexOf(current);
        if (index < 0) {
            index = 0;
        }
        if ((next = (index + delta) % WALL_SIGN_MATERIALS.size()) < 0) {
            next += WALL_SIGN_MATERIALS.size();
        }
        return WALL_SIGN_MATERIALS.get(next);
    }

    private String readable(Material material) {
        String name = material.name().toLowerCase().replace('_', ' ');
        String[] parts = name.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(' ');
        }
        if (builder.length() == 0) {
            return name;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    static {
        ArrayList<Material> materials = new ArrayList<Material>(Tag.WALL_SIGNS.getValues());
        materials.sort(Comparator.comparing(Enum::name));
        WALL_SIGN_MATERIALS = List.copyOf(materials);
    }

    private static final class MenuState {
        private Inventory inventory;
        private final List<ItemStack> items = new ArrayList<ItemStack>();
        private Material background;
        private boolean keepExistingBackground;
        private Material signMaterial;
        private int spacing;
        private int rows;
        private int rowSpacing;
        private ShopSignListener.SignAction action;
        private SignShopPlan.LayoutDirection direction;
        private boolean awaitingBackground;
        private int pendingItemSlot;
        private Inventory selectionInventory;
        private List<CatalogEntry> selectionEntries;
        private int selectionPage;
        private ItemCatalogSource selectionCatalog;
        private boolean reopenToPlanner;
        private boolean awaitingSearchInput;
        private String selectionSearch;
        private boolean instructionsShown;

        private MenuState() {
            for (int i = 0; i < ITEM_SLOTS.size(); ++i) {
                this.items.add(null);
            }
            this.background = SignShopPlan.DEFAULT_BACKGROUND;
            this.keepExistingBackground = false;
            this.signMaterial = Material.OAK_WALL_SIGN;
            this.spacing = 1;
            this.rows = 1;
            this.rowSpacing = 1;
            this.action = ShopSignListener.SignAction.BUY;
            this.direction = SignShopPlan.LayoutDirection.RIGHT;
            this.awaitingBackground = false;
            this.pendingItemSlot = -1;
            this.selectionInventory = null;
            this.selectionEntries = List.of();
            this.selectionPage = 0;
            this.selectionCatalog = null;
            this.reopenToPlanner = false;
            this.awaitingSearchInput = false;
            this.selectionSearch = null;
            this.instructionsShown = false;
        }
    }

    private static enum ItemCatalogSource {
        ACTION,
        SHOP,
        ALL;


        private ItemCatalogSource next() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> SHOP;
                case 1 -> ALL;
                case 2 -> ACTION;
            };
        }
    }

    private static final class CatalogEntry {
        private final CatalogEntryType type;
        private final Material material;
        private final int amount;
        private final String displayName;
        private final List<String> extraLore;
        private final boolean useConfiguredAmount;
        private final boolean showQuantityShortcuts;
        private final List<ItemStack> categoryItems;
        private final String categoryName;

        private CatalogEntry(CatalogEntryType type, Material material, int amount, String displayName, List<String> extraLore, boolean useConfiguredAmount, boolean showQuantityShortcuts, List<ItemStack> categoryItems, String categoryName) {
            this.type = Objects.requireNonNull(type, "type");
            this.material = material;
            this.amount = Math.max(1, Math.min(64, amount));
            this.displayName = displayName;
            this.extraLore = extraLore == null ? List.of() : List.copyOf(extraLore);
            this.useConfiguredAmount = useConfiguredAmount;
            this.showQuantityShortcuts = showQuantityShortcuts;
            this.categoryItems = CatalogEntry.sanitizeCategoryItems(categoryItems);
            this.categoryName = categoryName;
        }

        private CatalogEntryType type() {
            return this.type;
        }

        private Material material() {
            return this.material;
        }

        private int amount() {
            return this.amount;
        }

        private String displayName() {
            return this.displayName;
        }

        private List<String> extraLore() {
            return this.extraLore;
        }

        private boolean useConfiguredAmount() {
            return this.useConfiguredAmount;
        }

        private boolean showQuantityShortcuts() {
            return this.showQuantityShortcuts;
        }

        private List<ItemStack> categoryItems() {
            return this.categoryItems;
        }

        private String categoryName() {
            return this.categoryName;
        }

        private static List<ItemStack> sanitizeCategoryItems(List<ItemStack> items) {
            if (items == null || items.isEmpty()) {
                return List.of();
            }
            ArrayList<ItemStack> sanitized = new ArrayList<ItemStack>();
            for (ItemStack item : items) {
                if (item == null || item.getType() == Material.AIR) continue;
                ItemStack clone = item.clone();
                clone.setAmount(Math.max(1, Math.min(64, clone.getAmount())));
                sanitized.add(clone);
            }
            return List.copyOf(sanitized);
        }
    }

    private static enum CatalogEntryType {
        ITEM,
        CATEGORY;

    }
}

