/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.shop.sign;

import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.shop.ShopSignListener;
import com.skyblockexp.shop.ShopTransactionService;
import com.skyblockexp.shop.sign.SignShopScanner;
import com.skyblockexp.shop.sign.SignShopSetupMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class SignShopSetupCommand
implements CommandExecutor,
TabCompleter {
    public static final String PERMISSION = "ezshops.shop.sign.setup";
    private static final int DEFAULT_RADIUS = 8;
    private static final int MIN_RADIUS = 1;
    private static final int MAX_RADIUS = 12;
    private static final int MAX_PREVIEW = 10;
    private final SignShopSetupMenu menu;
    private final SignShopScanner scanner;
    private final ShopMessageConfiguration.CommandMessages.SignShopScanCommandMessages messages;
    private final ShopMessageConfiguration.SignMessages signMessages;

    public SignShopSetupCommand(SignShopSetupMenu menu, SignShopScanner scanner, ShopMessageConfiguration.CommandMessages.SignShopScanCommandMessages messages, ShopMessageConfiguration.SignMessages signMessages) {
        this.menu = menu;
        this.scanner = scanner;
        this.messages = Objects.requireNonNull(messages, "messages");
        this.signMessages = Objects.requireNonNull(signMessages, "signMessages");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            if (args != null && args.length > 0) {
                sender.sendMessage(this.messages.playersOnly());
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            }
            return true;
        }
        Player player = (Player)sender;
        if (args != null && args.length > 0) {
            String subcommand;
            switch (subcommand = args[0].toLowerCase(Locale.ENGLISH)) {
                case "scan": {
                    this.handleScan(player, label, args);
                    break;
                }
                case "confirm": {
                    this.handleConfirm(player);
                    break;
                }
                case "cancel": {
                    this.handleCancel(player);
                    break;
                }
                default: {
                    player.sendMessage(this.messages.unknown(label));
                }
            }
            return true;
        }
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use the sign shop setup menu.");
            return true;
        }
        if (this.menu == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The sign shop setup menu is currently unavailable.");
            return true;
        }
        this.menu.open(player);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            if (player.hasPermission("ezshops.shop.sign.scan")) {
                options.add("scan");
                options.add("confirm");
                options.add("cancel");
            }
            return this.filter(options, args[0]);
        }
        if (args.length == 2 && "scan".equalsIgnoreCase(args[0]) && player.hasPermission("ezshops.shop.sign.scan")) {
            return this.filter(List.of("5", "8", "10", Integer.toString(8)), args[1]);
        }
        return Collections.emptyList();
    }

    private void handleScan(Player player, String label, String[] args) {
        int remaining;
        if (this.scanner == null) {
            player.sendMessage(this.messages.scannerUnavailable());
            return;
        }
        if (!player.hasPermission("ezshops.shop.sign.scan")) {
            player.sendMessage(this.messages.noPermission());
            return;
        }
        int radius = 8;
        if (args.length >= 2) {
            try {
                radius = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                player.sendMessage(this.messages.invalidRadius(1, 12));
                return;
            }
        }
        if (radius < 1 || radius > 12) {
            player.sendMessage(this.messages.invalidRadius(1, 12));
            return;
        }
        SignShopScanner.ScanResult result = this.scanner.scan(player, radius);
        if (result.isEmpty()) {
            player.sendMessage(this.messages.noSigns(radius));
            return;
        }
        if (result.overwritten()) {
            player.sendMessage(this.messages.pendingReplaced());
        }
        player.sendMessage(this.messages.found(result.signs().size(), radius));
        int shown = 0;
        for (SignShopScanner.DetectedSign detected : result.signs()) {
            if (shown >= 10) break;
            String actionLabel = detected.action() == ShopSignListener.SignAction.BUY ? this.signMessages.actionLabelBuy() : this.signMessages.actionLabelSell();
            Location location = detected.location();
            String itemName = ShopTransactionService.friendlyMaterialName(detected.material());
            player.sendMessage(this.messages.entry(actionLabel, detected.amount(), itemName, location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            ++shown;
        }
        if ((remaining = result.signs().size() - shown) > 0) {
            player.sendMessage(this.messages.more(remaining));
        }
        if (result.limited()) {
            player.sendMessage(this.messages.limit(64));
        }
        player.sendMessage(this.messages.confirmHint(label));
    }

    private void handleConfirm(Player player) {
        if (this.scanner == null) {
            player.sendMessage(this.messages.scannerUnavailable());
            return;
        }
        if (!player.hasPermission("ezshops.shop.sign.scan")) {
            player.sendMessage(this.messages.noPermission());
            return;
        }
        SignShopScanner.ConfirmationResult result = this.scanner.confirm(player);
        switch (result.status()) {
            case NO_PENDING: {
                player.sendMessage(this.messages.noPending());
                break;
            }
            case EXPIRED: {
                player.sendMessage(this.messages.expired());
                break;
            }
            case SUCCESS: {
                player.sendMessage(this.messages.converted(result.converted()));
                break;
            }
            case PARTIAL: {
                player.sendMessage(this.messages.convertedPartial(result.converted(), result.failed()));
                break;
            }
            case NONE: {
                player.sendMessage(this.messages.convertedNone());
            }
        }
    }

    private void handleCancel(Player player) {
        boolean menuCancelled;
        boolean bl = menuCancelled = this.menu != null && this.menu.cancel(player);
        if (menuCancelled) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Closed the sign shop planner.");
        }
        if (this.scanner == null) {
            if (!menuCancelled) {
                player.sendMessage(this.messages.scannerUnavailable());
            }
            return;
        }
        if (!player.hasPermission("ezshops.shop.sign.scan")) {
            player.sendMessage(this.messages.noPermission());
            return;
        }
        if (this.scanner.cancel(player)) {
            player.sendMessage(this.messages.cancelled());
        } else {
            player.sendMessage(this.messages.noPending());
        }
    }

    private List<String> filter(List<String> options, String token) {
        if (options.isEmpty()) {
            return Collections.emptyList();
        }
        if (token == null || token.isEmpty()) {
            return options;
        }
        String lower = token.toLowerCase(Locale.ENGLISH);
        ArrayList<String> matches = new ArrayList<String>();
        for (String option : options) {
            if (!option.toLowerCase(Locale.ENGLISH).startsWith(lower)) continue;
            matches.add(option);
        }
        return matches;
    }
}

