/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.shop.sign;

import com.skyblockexp.shop.ShopPricingManager;
import com.skyblockexp.shop.ShopSignConfiguration;
import com.skyblockexp.shop.ShopSignListener;
import com.skyblockexp.shop.ShopTransactionService;
import com.skyblockexp.shop.sign.SignShopGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SignShopScanner {
    public static final String PERMISSION = "ezshops.shop.sign.scan";
    public static final int MAX_RESULTS = 64;
    private static final long PENDING_EXPIRY_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private final ShopPricingManager pricingManager;
    private final SignShopGenerator generator;
    private final ShopSignConfiguration signConfiguration;
    private final NamespacedKey actionKey;
    private final NamespacedKey materialKey;
    private final NamespacedKey amountKey;
    private final Map<UUID, PendingScan> pendingScans = new HashMap<UUID, PendingScan>();

    public SignShopScanner(JavaPlugin plugin, ShopPricingManager pricingManager, SignShopGenerator generator, ShopSignConfiguration signConfiguration) {
        this.pricingManager = Objects.requireNonNull(pricingManager, "pricingManager");
        this.generator = Objects.requireNonNull(generator, "generator");
        this.signConfiguration = Objects.requireNonNull(signConfiguration, "signConfiguration");
        this.actionKey = new NamespacedKey((Plugin)plugin, "shop_sign_action");
        this.materialKey = new NamespacedKey((Plugin)plugin, "shop_sign_material");
        this.amountKey = new NamespacedKey((Plugin)plugin, "shop_sign_amount");
    }

    public ScanResult scan(Player player, int radius) {
        if (player == null || radius <= 0) {
            return ScanResult.empty();
        }
        Location center = player.getLocation();
        World world = center.getWorld();
        if (world == null) {
            return ScanResult.empty();
        }
        Map<String, Material> materialLookup = this.buildMaterialLookup();
        ArrayList<DetectedSign> detected = new ArrayList<DetectedSign>();
        boolean limited = false;
        int originX = center.getBlockX();
        int originY = center.getBlockY();
        int originZ = center.getBlockZ();
        int minY = Math.max(world.getMinHeight(), originY - radius);
        int maxY = Math.min(world.getMaxHeight() - 1, originY + radius);
        block0: for (int x = originX - radius; x <= originX + radius; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = originZ - radius; z <= originZ + radius; ++z) {
                    DetectedSign candidate;
                    Sign sign;
                    Block block = world.getBlockAt(x, y, z);
                    BlockState state = block.getState();
                    if (!(state instanceof Sign) || this.isEzShopsSign(sign = (Sign)state) || (candidate = this.detectSign(sign, materialLookup)) == null || !this.generator.isActionSupported(candidate.action(), candidate.material())) continue;
                    detected.add(candidate);
                    if (detected.size() < 64) continue;
                    limited = true;
                    break block0;
                }
            }
        }
        if (detected.isEmpty()) {
            return ScanResult.empty();
        }
        PendingScan pending = new PendingScan(List.copyOf(detected));
        PendingScan previous = this.pendingScans.put(player.getUniqueId(), pending);
        boolean overwritten = previous != null;
        return new ScanResult(pending.signs(), overwritten, limited);
    }

    public ConfirmationResult confirm(Player player) {
        if (player == null) {
            return ConfirmationResult.nonePending();
        }
        PendingScan pending = this.pendingScans.remove(player.getUniqueId());
        if (pending == null) {
            return ConfirmationResult.nonePending();
        }
        if (pending.isExpired()) {
            return ConfirmationResult.expired();
        }
        int converted = 0;
        int failed = 0;
        for (DetectedSign detected : pending.signs()) {
            if (this.convertSign(detected)) {
                ++converted;
                continue;
            }
            ++failed;
        }
        if (converted <= 0 && failed <= 0) {
            return ConfirmationResult.noneConverted();
        }
        if (converted > 0 && failed == 0) {
            return ConfirmationResult.success(converted);
        }
        if (converted > 0) {
            return ConfirmationResult.partial(converted, failed);
        }
        return ConfirmationResult.noneConverted();
    }

    public boolean cancel(Player player) {
        if (player == null) {
            return false;
        }
        return this.pendingScans.remove(player.getUniqueId()) != null;
    }

    private boolean convertSign(DetectedSign detected) {
        int chunkZ;
        Location location = detected.location();
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        int chunkX = location.getBlockX() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = location.getBlockZ() >> 4)) {
            return false;
        }
        Block block = world.getBlockAt(location);
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        if (!this.generator.isActionSupported(detected.action(), detected.material())) {
            return false;
        }
        int amount = Math.max(1, detected.amount());
        return this.generator.formatExistingSign(sign, detected.action(), detected.material(), amount);
    }

    private boolean isEzShopsSign(Sign sign) {
        PersistentDataContainer container = sign.getPersistentDataContainer();
        return container.has(this.actionKey, PersistentDataType.STRING) || container.has(this.materialKey, PersistentDataType.STRING) || container.has(this.amountKey, PersistentDataType.INTEGER);
    }

    private DetectedSign detectSign(Sign sign, Map<String, Material> materialLookup) {
        String[] lines = new String[4];
        for (int i = 0; i < 4; ++i) {
            lines[i] = this.strip(sign.getLine(i));
        }
        if (!this.isLikelyShopSign(lines)) {
            return null;
        }
        ShopSignListener.SignAction action = this.detectAction(lines);
        if (action == null) {
            return null;
        }
        Material material = this.detectMaterial(lines, materialLookup);
        if (material == null) {
            return null;
        }
        int amount = this.detectAmount(lines);
        if (amount <= 0) {
            amount = 1;
        }
        return new DetectedSign(sign.getLocation(), action, material, amount);
    }

    private Map<String, Material> buildMaterialLookup() {
        Set<Material> configured = this.pricingManager.getConfiguredMaterials();
        HashMap<String, Material> lookup = new HashMap<String, Material>(configured.size() * 2);
        for (Material material : configured) {
            this.addMaterialKey(lookup, material.name(), material);
            String friendly = ShopTransactionService.friendlyMaterialName(material);
            this.addMaterialKey(lookup, friendly, material);
        }
        return lookup;
    }

    private void addMaterialKey(Map<String, Material> lookup, String key, Material material) {
        String normalized = this.normalizeMaterialKey(key);
        if (!normalized.isEmpty()) {
            lookup.putIfAbsent(normalized, material);
        }
    }

    private Material detectMaterial(String[] lines, Map<String, Material> lookup) {
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || line.isEmpty()) continue;
            Material direct = this.matchConfiguredMaterial(line);
            if (direct != null) {
                return direct;
            }
            String normalized = this.normalizeMaterialKey(line);
            Material viaLookup = lookup.get(normalized);
            if (viaLookup != null) {
                return viaLookup;
            }
            Material fromTokens = this.detectMaterialFromTokens(line, lookup);
            if (fromTokens == null) continue;
            return fromTokens;
        }
        return null;
    }

    private Material detectMaterialFromTokens(String line, Map<String, Material> lookup) {
        String[] tokens = line.split("[^A-Za-z0-9]+");
        for (int start = 0; start < tokens.length; ++start) {
            String token = tokens[start];
            if (token == null || token.isEmpty()) continue;
            Material direct = this.matchConfiguredMaterial(token);
            if (direct != null) {
                return direct;
            }
            Object combined = token;
            for (int end = start + 1; end < tokens.length; ++end) {
                String part = tokens[end];
                if (part == null || part.isEmpty()) continue;
                direct = this.matchConfiguredMaterial((String)(combined = (String)combined + "_" + part));
                if (direct != null) {
                    return direct;
                }
                String normalized = this.normalizeMaterialKey((String)combined);
                Material viaLookup = lookup.get(normalized);
                if (viaLookup == null) continue;
                return viaLookup;
            }
        }
        return null;
    }

    private Material matchConfiguredMaterial(String token) {
        if (token == null || token.isBlank()) {
            return null;
        }
        Material material = Material.matchMaterial((String)token, (boolean)false);
        if (material != null && this.pricingManager.isConfigured(material)) {
            return material;
        }
        String normalized = token.replace(' ', '_');
        material = Material.matchMaterial((String)normalized, (boolean)false);
        if (material != null && this.pricingManager.isConfigured(material)) {
            return material;
        }
        normalized = token.replace('_', ' ');
        material = Material.matchMaterial((String)normalized, (boolean)false);
        if (material != null && this.pricingManager.isConfigured(material)) {
            return material;
        }
        normalized = token.toUpperCase(Locale.ENGLISH);
        material = Material.matchMaterial((String)normalized, (boolean)false);
        if (material != null && this.pricingManager.isConfigured(material)) {
            return material;
        }
        normalized = token.toLowerCase(Locale.ENGLISH).replace(' ', '_');
        material = Material.matchMaterial((String)normalized, (boolean)false);
        if (material != null && this.pricingManager.isConfigured(material)) {
            return material;
        }
        return null;
    }

    private ShopSignListener.SignAction detectAction(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            ShopSignListener.SignAction action = this.parseActionToken(lines[i]);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    private ShopSignListener.SignAction parseActionToken(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        String normalized = raw.trim().toLowerCase(Locale.ENGLISH);
        if (normalized.contains("buy") || normalized.startsWith("[buy")) {
            return ShopSignListener.SignAction.BUY;
        }
        if (normalized.contains("sell") || normalized.startsWith("[sell")) {
            return ShopSignListener.SignAction.SELL;
        }
        if (normalized.equals("b") || normalized.startsWith("b ")) {
            return ShopSignListener.SignAction.BUY;
        }
        if (normalized.equals("s") || normalized.startsWith("s ")) {
            return ShopSignListener.SignAction.SELL;
        }
        return null;
    }

    private int detectAmount(String[] lines) {
        int amount = -1;
        for (int i = lines.length - 1; i >= 1; --i) {
            int value;
            String normalized;
            String line = lines[i];
            if (line == null || line.isBlank() || this.containsPriceIndicator(normalized = line.toLowerCase(Locale.ENGLISH)) || (value = this.extractFirstInteger(normalized)) <= 0) continue;
            if (normalized.contains("x")) {
                return value;
            }
            if (value <= 64) {
                return value;
            }
            if (amount >= 0) continue;
            amount = value;
        }
        return amount;
    }

    private boolean containsPriceIndicator(String line) {
        return line.contains("$") || line.contains("\u20ac") || line.contains(":") || line.contains("buy") || line.contains("sell") || line.contains("price") || line.startsWith("b ") || line.startsWith("s ");
    }

    private int extractFirstInteger(String line) {
        StringBuilder digits = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isDigit(c)) {
                digits.append(c);
                continue;
            }
            if (digits.length() > 0) break;
        }
        if (digits.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(digits.toString());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isLikelyShopSign(String[] lines) {
        if (lines == null || lines.length == 0) {
            return false;
        }
        boolean keywordDetected = false;
        for (String line : lines) {
            if (line == null || line.isBlank()) continue;
            if (this.signConfiguration.matchesHeader(line)) {
                return true;
            }
            String normalized = line.trim().toLowerCase(Locale.ENGLISH);
            if (keywordDetected || !normalized.contains("shop") && !normalized.contains("buy") && !normalized.contains("sell")) continue;
            keywordDetected = true;
        }
        return keywordDetected;
    }

    private String strip(String line) {
        if (line == null) {
            return null;
        }
        return ChatColor.stripColor((String)line);
    }

    private String normalizeMaterialKey(String raw) {
        if (raw == null) {
            return "";
        }
        String stripped = ChatColor.stripColor((String)raw);
        if (stripped == null) {
            return "";
        }
        String lower = stripped.toLowerCase(Locale.ENGLISH);
        StringBuilder builder = new StringBuilder(lower.length());
        boolean underscore = false;
        for (int i = 0; i < lower.length(); ++i) {
            char c = lower.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                builder.append(c);
                underscore = false;
                continue;
            }
            if (underscore || builder.length() <= 0) continue;
            builder.append('_');
            underscore = true;
        }
        for (int length = builder.length(); length > 0 && builder.charAt(length - 1) == '_'; --length) {
            builder.deleteCharAt(length - 1);
        }
        if (builder.length() == 0) {
            return "";
        }
        return builder.toString();
    }

    public record ScanResult(List<DetectedSign> signs, boolean overwritten, boolean limited) {
        private static final ScanResult EMPTY = new ScanResult(List.of(), false, false);

        public static ScanResult empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this.signs == null || this.signs.isEmpty();
        }
    }

    public record DetectedSign(Location location, ShopSignListener.SignAction action, Material material, int amount) {
    }

    private static final class PendingScan {
        private final List<DetectedSign> signs;
        private final long createdAt;

        private PendingScan(List<DetectedSign> signs) {
            this.signs = signs;
            this.createdAt = System.currentTimeMillis();
        }

        private boolean isExpired() {
            return System.currentTimeMillis() - this.createdAt > PENDING_EXPIRY_MILLIS;
        }

        private List<DetectedSign> signs() {
            return this.signs;
        }
    }

    public record ConfirmationResult(ConfirmationStatus status, int converted, int failed) {
        private static final ConfirmationResult NONE = new ConfirmationResult(ConfirmationStatus.NO_PENDING, 0, 0);
        private static final ConfirmationResult EXPIRED_RESULT = new ConfirmationResult(ConfirmationStatus.EXPIRED, 0, 0);
        private static final ConfirmationResult NONE_CONVERTED = new ConfirmationResult(ConfirmationStatus.NONE, 0, 0);

        public static ConfirmationResult nonePending() {
            return NONE;
        }

        public static ConfirmationResult expired() {
            return EXPIRED_RESULT;
        }

        public static ConfirmationResult noneConverted() {
            return NONE_CONVERTED;
        }

        public static ConfirmationResult success(int converted) {
            return new ConfirmationResult(ConfirmationStatus.SUCCESS, converted, 0);
        }

        public static ConfirmationResult partial(int converted, int failed) {
            return new ConfirmationResult(ConfirmationStatus.PARTIAL, converted, failed);
        }
    }

    public static enum ConfirmationStatus {
        SUCCESS,
        PARTIAL,
        NONE,
        EXPIRED,
        NO_PENDING;

    }
}

