/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.shop;

import com.skyblockexp.common.util.EconomyUtils;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.shop.ShopPrice;
import com.skyblockexp.shop.ShopPricingManager;
import com.skyblockexp.shop.ShopSignConfiguration;
import com.skyblockexp.shop.ShopTransactionResult;
import com.skyblockexp.shop.ShopTransactionService;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopSignListener
implements Listener {
    public static final String PERMISSION_CREATE = "ezshops.shop.sign.create";
    private final JavaPlugin plugin;
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final NamespacedKey actionKey;
    private final NamespacedKey materialKey;
    private final NamespacedKey amountKey;
    private final ShopSignConfiguration signConfiguration;
    private final ShopMessageConfiguration.SignMessages signMessages;

    public ShopSignListener(JavaPlugin plugin, ShopPricingManager pricingManager, ShopTransactionService transactionService, ShopSignConfiguration signConfiguration, ShopMessageConfiguration.SignMessages signMessages) {
        this.plugin = plugin;
        this.pricingManager = pricingManager;
        this.transactionService = transactionService;
        this.actionKey = new NamespacedKey((Plugin)plugin, "shop_sign_action");
        this.materialKey = new NamespacedKey((Plugin)plugin, "shop_sign_material");
        this.amountKey = new NamespacedKey((Plugin)plugin, "shop_sign_amount");
        this.signConfiguration = signConfiguration;
        this.signMessages = signMessages;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        double unitPrice;
        Material material;
        String rawHeader = this.serializeLine(event.getLine(0));
        if (!this.signConfiguration.matchesHeader(rawHeader)) {
            return;
        }
        Player player = event.getPlayer();
        if (player != null && !player.hasPermission(PERMISSION_CREATE)) {
            player.sendMessage(this.signMessages.noPermission());
            this.clearShopHeader(event);
            return;
        }
        SignAction action = SignAction.from(this.serializeLine(event.getLine(1)));
        if (action == null) {
            if (player != null) {
                player.sendMessage(this.signMessages.invalidAction());
            }
            this.clearShopHeader(event);
            return;
        }
        String materialToken = this.serializeLine(event.getLine(2));
        Material material2 = material = materialToken == null ? null : Material.matchMaterial((String)materialToken, (boolean)false);
        if (material == null) {
            if (player != null) {
                player.sendMessage(this.signMessages.unknownItem(materialToken));
            }
            this.clearShopHeader(event);
            return;
        }
        int amount = this.parseAmount(this.serializeLine(event.getLine(3)));
        if (amount <= 0) {
            if (player != null) {
                player.sendMessage(this.signMessages.invalidAmount());
            }
            this.clearShopHeader(event);
            return;
        }
        Optional<ShopPrice> priceLookup = this.pricingManager.getPrice(material);
        if (priceLookup.isEmpty()) {
            if (player != null) {
                player.sendMessage(this.signMessages.notConfigured());
            }
            this.clearShopHeader(event);
            return;
        }
        ShopPrice price = priceLookup.get();
        double d = unitPrice = action == SignAction.BUY ? price.buyPrice() : price.sellPrice();
        if (unitPrice < 0.0) {
            if (player != null) {
                String verb = action == SignAction.BUY ? this.signMessages.actionVerbBuy() : this.signMessages.actionVerbSell();
                player.sendMessage(this.signMessages.notAvailable(verb));
            }
            this.clearShopHeader(event);
            return;
        }
        double totalPrice = EconomyUtils.normalizeCurrency(unitPrice * (double)amount);
        this.updateEventLines(event, action, material, amount, totalPrice);
        Block block = event.getBlock();
        if (block != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.storeSignData(block, action, material, amount));
        }
        if (player != null) {
            player.sendMessage(this.signMessages.ready(this.resolveActionLabel(action), amount, ShopTransactionService.friendlyMaterialName(material)));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        BlockState blockState;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !((blockState = block.getState()) instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        if (!this.signConfiguration.matchesHeader(ChatColor.stripColor((String)sign.getLine(0)))) {
            return;
        }
        PersistentDataContainer container = sign.getPersistentDataContainer();
        SignAction action = this.readAction(container);
        Material material = this.readMaterial(container);
        int amount = this.readAmount(container);
        if (action == null || material == null || amount <= 0) {
            event.getPlayer().sendMessage(this.signMessages.malformed());
            return;
        }
        ShopTransactionResult result = action == SignAction.BUY ? this.transactionService.buy(event.getPlayer(), material, amount) : this.transactionService.sell(event.getPlayer(), material, amount);
        event.getPlayer().sendMessage(result.message());
        Optional<ShopPrice> priceLookup = this.pricingManager.getPrice(material);
        double totalPrice = -1.0;
        if (priceLookup.isPresent()) {
            double unitPrice;
            ShopPrice price = priceLookup.get();
            double d = unitPrice = action == SignAction.BUY ? price.buyPrice() : price.sellPrice();
            if (unitPrice >= 0.0) {
                totalPrice = EconomyUtils.normalizeCurrency(unitPrice * (double)amount);
            }
        }
        this.updateSignDisplay(sign, action, material, amount, totalPrice);
        this.storeSignData(block, action, material, amount);
    }

    private void storeSignData(Block block, SignAction action, Material material, int amount) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        PersistentDataContainer container = sign.getPersistentDataContainer();
        container.set(this.actionKey, PersistentDataType.STRING, (Object)action.name());
        container.set(this.materialKey, PersistentDataType.STRING, (Object)material.name());
        container.set(this.amountKey, PersistentDataType.INTEGER, (Object)Math.max(1, amount));
        sign.update(true);
    }

    private void updateEventLines(SignChangeEvent event, SignAction action, Material material, int amount, double totalPrice) {
        event.setLine(0, this.signConfiguration.headerText());
        event.setLine(1, this.formatActionLine(action, amount));
        event.setLine(2, this.signConfiguration.formatItemLine(ShopTransactionService.friendlyMaterialName(material)));
        if (totalPrice < 0.0) {
            event.setLine(3, this.signConfiguration.unavailableLine());
        } else {
            event.setLine(3, this.signConfiguration.formatPriceLine(this.transactionService.formatCurrency(totalPrice)));
        }
    }

    private void updateSignDisplay(Sign sign, SignAction action, Material material, int amount, double totalPrice) {
        sign.setLine(0, this.signConfiguration.headerText());
        sign.setLine(1, this.formatActionLine(action, amount));
        sign.setLine(2, this.signConfiguration.formatItemLine(ShopTransactionService.friendlyMaterialName(material)));
        if (totalPrice < 0.0) {
            sign.setLine(3, this.signConfiguration.unavailableLine());
        } else {
            sign.setLine(3, this.signConfiguration.formatPriceLine(this.transactionService.formatCurrency(totalPrice)));
        }
        sign.update(true);
    }

    private void clearShopHeader(SignChangeEvent event) {
        event.setLine(0, "");
    }

    private String resolveActionLabel(SignAction action) {
        return action == SignAction.BUY ? this.signMessages.actionLabelBuy() : this.signMessages.actionLabelSell();
    }

    private String formatActionLine(SignAction action, int amount) {
        return this.signConfiguration.formatActionLine(action, amount);
    }

    private SignAction readAction(PersistentDataContainer container) {
        String stored = (String)container.get(this.actionKey, PersistentDataType.STRING);
        if (stored == null) {
            return null;
        }
        try {
            return SignAction.valueOf(stored);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private Material readMaterial(PersistentDataContainer container) {
        String stored = (String)container.get(this.materialKey, PersistentDataType.STRING);
        if (stored == null) {
            return null;
        }
        return Material.matchMaterial((String)stored, (boolean)false);
    }

    private int readAmount(PersistentDataContainer container) {
        Integer stored = (Integer)container.get(this.amountKey, PersistentDataType.INTEGER);
        return stored == null ? -1 : stored;
    }

    private String serializeLine(String line) {
        if (line == null) {
            return null;
        }
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)line));
    }

    private int parseAmount(String raw) {
        if (raw == null || raw.isBlank()) {
            return 1;
        }
        try {
            return Integer.parseInt(raw.trim());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static enum SignAction {
        BUY,
        SELL;


        private static SignAction from(String raw) {
            String normalized;
            if (raw == null || raw.isBlank()) {
                return null;
            }
            return switch (normalized = raw.trim().toLowerCase(Locale.ENGLISH)) {
                case "buy" -> BUY;
                case "sell" -> SELL;
                default -> null;
            };
        }
    }
}

