/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.shop;

import com.skyblockexp.shop.ShopMenuLayout;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ShopRotationOption {
    private final String id;
    private final ShopMenuLayout.ItemDecoration iconOverride;
    private final String menuTitleOverride;
    private final Map<String, Map<String, Object>> itemOverrides;
    private final double weight;

    public ShopRotationOption(String id, ShopMenuLayout.ItemDecoration iconOverride, String menuTitleOverride, Map<String, Map<String, Object>> itemOverrides, double weight) {
        this.id = Objects.requireNonNull(id, "id");
        this.iconOverride = iconOverride;
        this.menuTitleOverride = menuTitleOverride;
        this.itemOverrides = this.toImmutable(itemOverrides);
        this.weight = Math.max(0.0, weight);
    }

    public String id() {
        return this.id;
    }

    public ShopMenuLayout.ItemDecoration iconOverride() {
        return this.iconOverride;
    }

    public String menuTitleOverride() {
        return this.menuTitleOverride;
    }

    public Map<String, Map<String, Object>> itemOverrides() {
        return this.itemOverrides;
    }

    public double weight() {
        return this.weight;
    }

    private Map<String, Map<String, Object>> toImmutable(Map<String, Map<String, Object>> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Map<String, Object>> copy = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : source.entrySet()) {
            copy.put(entry.getKey(), this.deepCopy(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    private Map<String, Object> deepCopy(Map<String, Object> source) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map nested = (Map)value;
                copy.put(entry.getKey(), this.deepCopy(nested));
                continue;
            }
            copy.put(entry.getKey(), value);
        }
        return Collections.unmodifiableMap(copy);
    }
}

