/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.playershop.bootstrap;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.playershop.PlayerShopCommand;
import com.skyblockexp.playershop.PlayerShopConfiguration;
import com.skyblockexp.playershop.PlayerShopListener;
import com.skyblockexp.playershop.PlayerShopManager;
import com.skyblockexp.playershop.PlayerShopMessages;
import com.skyblockexp.playershop.PlayerShopSetupMenu;
import java.util.Objects;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class PlayerShopComponent
implements PluginComponent {
    private static final String COMMAND_NAME = "playershop";
    private final Economy economy;
    private final FileConfiguration configurationSource;
    private EzShopsPlugin plugin;
    private PlayerShopConfiguration configuration;
    private PlayerShopManager manager;
    private PlayerShopListener listener;
    private PlayerShopSetupMenu setupMenu;
    private PlayerShopCommand command;
    private PluginCommand pluginCommand;
    private boolean enabled;
    private String disabledMessage;

    public PlayerShopComponent(Economy economy, FileConfiguration configurationSource) {
        this.economy = Objects.requireNonNull(economy, "economy");
        this.configurationSource = Objects.requireNonNull(configurationSource, "configurationSource");
    }

    @Override
    public void enable(EzShopsPlugin plugin) {
        this.plugin = plugin;
        this.configuration = PlayerShopConfiguration.from(this.configurationSource, plugin.getLogger());
        PlayerShopMessages messages = this.configuration.messages();
        this.disabledMessage = messages.commandDisabled();
        this.pluginCommand = this.requireCommand(plugin, COMMAND_NAME);
        if (!this.configuration.enabled()) {
            this.registerFallbackCommand(this.pluginCommand);
            plugin.getLogger().info("Player shops are disabled via configuration.");
            this.enabled = false;
            return;
        }
        this.manager = new PlayerShopManager(plugin, this.economy, this.configuration);
        this.manager.enable();
        this.listener = new PlayerShopListener(this.manager, this.configuration);
        this.setupMenu = new PlayerShopSetupMenu(plugin, this.manager, this.configuration);
        this.command = new PlayerShopCommand(this.manager, this.setupMenu, messages);
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.listener, (Plugin)plugin);
        pluginManager.registerEvents((Listener)this.setupMenu, (Plugin)plugin);
        this.pluginCommand.setExecutor((CommandExecutor)this.command);
        this.pluginCommand.setTabCompleter(null);
        this.enabled = true;
    }

    @Override
    public void disable() {
        if (this.manager != null) {
            this.manager.disable();
            this.manager = null;
        }
        this.unregisterListener(this.listener);
        this.listener = null;
        this.unregisterListener(this.setupMenu);
        this.setupMenu = null;
        this.command = null;
        this.enabled = false;
        if (this.pluginCommand != null) {
            this.pluginCommand.setExecutor(null);
            this.pluginCommand.setTabCompleter(null);
            this.pluginCommand = null;
        }
        this.plugin = null;
        this.configuration = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String disabledCommandMessage() {
        if (this.disabledMessage != null && !this.disabledMessage.isBlank()) {
            return this.disabledMessage;
        }
        return PlayerShopConfiguration.defaults().messages().commandDisabled();
    }

    private PluginCommand requireCommand(EzShopsPlugin plugin, String name) {
        PluginCommand command = plugin.getCommand(name);
        if (command == null) {
            plugin.getLogger().severe("Plugin command '" + name + "' is not defined in plugin.yml. EzShops will be unusable.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            throw new IllegalStateException("Missing required command '" + name + "'.");
        }
        return command;
    }

    private void registerFallbackCommand(PluginCommand command) {
        DisabledCommandExecutor executor = new DisabledCommandExecutor(this.disabledCommandMessage());
        command.setExecutor((CommandExecutor)executor);
        command.setTabCompleter(null);
    }

    private void unregisterListener(Listener listener) {
        if (listener != null) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    private static final class DisabledCommandExecutor
    implements CommandExecutor {
        private final String message;

        private DisabledCommandExecutor(String message) {
            this.message = message;
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (this.message != null && !this.message.isBlank()) {
                sender.sendMessage(this.message);
            }
            return true;
        }
    }
}

