/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.playershop;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public record PlayerShopSetup(int quantity, double price, ItemStack itemTemplate) {
    private final ItemStack itemTemplate;

    public PlayerShopSetup(int quantity, double price, ItemStack itemTemplate) {
        if (quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater than zero");
        }
        if (price <= 0.0) {
            throw new IllegalArgumentException("price must be greater than zero");
        }
        itemTemplate = this.sanitizeTemplate(itemTemplate);
        this.quantity = quantity;
        this.price = price;
        this.itemTemplate = itemTemplate;
    }

    public ItemStack itemTemplate() {
        return this.itemTemplate == null ? null : this.itemTemplate.clone();
    }

    private ItemStack sanitizeTemplate(ItemStack template) {
        if (template == null || template.getType() == Material.AIR) {
            return null;
        }
        ItemStack clone = template.clone();
        clone.setAmount(Math.max(1, clone.getAmount()));
        return clone;
    }
}

