/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.playershop;

import com.skyblockexp.playershop.PlayerShopManager;
import com.skyblockexp.playershop.PlayerShopMessages;
import com.skyblockexp.playershop.PlayerShopSetupMenu;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PlayerShopCommand
implements CommandExecutor {
    private final PlayerShopManager manager;
    private final PlayerShopSetupMenu menu;
    private final PlayerShopMessages messages;

    public PlayerShopCommand(PlayerShopManager manager, PlayerShopSetupMenu menu, PlayerShopMessages messages) {
        this.manager = manager;
        this.menu = menu;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.commandPlayersOnly());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("ezshops.playershop.create")) {
            player.sendMessage(this.messages.noPermissionCreate());
            return true;
        }
        if (this.manager == null || this.menu == null) {
            player.sendMessage(this.messages.commandDisabled());
            return true;
        }
        this.menu.open(player);
        return true;
    }
}

