/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.gui;

import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.gui.IslandLevelProvider;
import com.skyblockexp.gui.shop.AbstractShopMenuHolder;
import com.skyblockexp.gui.shop.CategoryShopMenuHolder;
import com.skyblockexp.gui.shop.FlatShopMenuHolder;
import com.skyblockexp.gui.shop.MainShopMenuHolder;
import com.skyblockexp.gui.shop.QuantityShopMenuHolder;
import com.skyblockexp.gui.shop.ShopInventoryComposer;
import com.skyblockexp.gui.shop.ShopTransactionType;
import com.skyblockexp.shop.ShopMenuLayout;
import com.skyblockexp.shop.ShopPricingManager;
import com.skyblockexp.shop.ShopTransactionResult;
import com.skyblockexp.shop.ShopTransactionService;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopMenu
implements Listener {
    private final JavaPlugin plugin;
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final IslandLevelProvider islandLevelProvider;
    private final boolean ignoreIslandRequirements;
    private final DisplayMode displayMode;
    private final NamespacedKey categoryKey;
    private final NamespacedKey itemKey;
    private final NamespacedKey actionKey;
    private final NamespacedKey quantityKey;
    private final ShopInventoryComposer inventoryComposer;
    private final ConcurrentMap<UUID, PendingTransaction> pendingCustomInputs;
    private final ShopMessageConfiguration.GuiMessages guiMessages;
    private final ShopMessageConfiguration.TransactionMessages.RestrictionMessages restrictionMessages;

    public ShopMenu(JavaPlugin plugin, ShopPricingManager pricingManager, ShopTransactionService transactionService, IslandLevelProvider islandLevelProvider, boolean ignoreIslandRequirements, ShopMessageConfiguration.GuiMessages guiMessages, ShopMessageConfiguration.TransactionMessages.RestrictionMessages restrictionMessages) {
        this(plugin, pricingManager, transactionService, islandLevelProvider, ignoreIslandRequirements, DisplayMode.CATEGORIES, guiMessages, restrictionMessages);
    }

    public ShopMenu(JavaPlugin plugin, ShopPricingManager pricingManager, ShopTransactionService transactionService, IslandLevelProvider islandLevelProvider, boolean ignoreIslandRequirements, DisplayMode displayMode, ShopMessageConfiguration.GuiMessages guiMessages, ShopMessageConfiguration.TransactionMessages.RestrictionMessages restrictionMessages) {
        this.plugin = plugin;
        this.pricingManager = pricingManager;
        this.transactionService = transactionService;
        this.islandLevelProvider = islandLevelProvider != null ? islandLevelProvider : player -> 0;
        this.ignoreIslandRequirements = ignoreIslandRequirements;
        this.displayMode = displayMode == null ? DisplayMode.CATEGORIES : displayMode;
        this.guiMessages = guiMessages;
        this.restrictionMessages = restrictionMessages;
        this.categoryKey = new NamespacedKey((Plugin)plugin, "shop_category");
        this.itemKey = new NamespacedKey((Plugin)plugin, "shop_item");
        this.actionKey = new NamespacedKey((Plugin)plugin, "shop_action");
        this.quantityKey = new NamespacedKey((Plugin)plugin, "shop_quantity");
        this.inventoryComposer = new ShopInventoryComposer(plugin, pricingManager, transactionService, this.categoryKey, this.itemKey, this.actionKey, this.quantityKey, guiMessages);
        this.pendingCustomInputs = new ConcurrentHashMap<UUID, PendingTransaction>();
    }

    public void openMainMenu(Player player) {
        if (this.displayMode == DisplayMode.FLAT_LIST) {
            int islandLevel = this.resolvePlayerIslandLevel(player);
            this.inventoryComposer.openFlatMenu(player, islandLevel, this.ignoreIslandRequirements);
        } else {
            this.inventoryComposer.openMainMenu(player);
        }
    }

    public void refreshViewers() {
        Runnable refreshTask = () -> {
            ShopMenuLayout layout = this.pricingManager.getMenuLayout();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                int islandLevel;
                ShopMenuLayout.Item item;
                ShopMenuLayout.Category category;
                AbstractShopMenuHolder holder;
                InventoryHolder patt0$temp;
                Inventory topInventory;
                InventoryView view = player.getOpenInventory();
                if (view == null || (topInventory = view.getTopInventory()) == null || !((patt0$temp = topInventory.getHolder()) instanceof AbstractShopMenuHolder) || !(holder = (AbstractShopMenuHolder)patt0$temp).owner().equals(player.getUniqueId())) continue;
                if (holder instanceof FlatShopMenuHolder) {
                    int islandLevel2 = this.resolvePlayerIslandLevel(player);
                    this.inventoryComposer.openFlatMenu(player, islandLevel2, this.ignoreIslandRequirements);
                    continue;
                }
                if (holder instanceof MainShopMenuHolder) {
                    this.openMainMenu(player);
                    continue;
                }
                if (holder instanceof CategoryShopMenuHolder) {
                    CategoryShopMenuHolder categoryHolder = (CategoryShopMenuHolder)holder;
                    category = this.findCategoryById(layout, categoryHolder.category().id());
                    if (category != null) {
                        int islandLevel3 = this.resolvePlayerIslandLevel(player);
                        this.inventoryComposer.openCategoryMenu(player, category, islandLevel3, this.ignoreIslandRequirements);
                        continue;
                    }
                    this.openMainMenu(player);
                    continue;
                }
                if (!(holder instanceof QuantityShopMenuHolder)) continue;
                QuantityShopMenuHolder quantityHolder = (QuantityShopMenuHolder)holder;
                category = this.findCategoryById(layout, quantityHolder.category().id());
                ShopMenuLayout.Item item2 = item = category != null ? this.findItemById(category, quantityHolder.item().id()) : null;
                if (category != null && item != null) {
                    islandLevel = this.resolvePlayerIslandLevel(player);
                    this.inventoryComposer.openQuantityMenu(player, category, item, quantityHolder.type(), islandLevel, this.ignoreIslandRequirements);
                    continue;
                }
                if (category != null) {
                    islandLevel = this.resolvePlayerIslandLevel(player);
                    this.inventoryComposer.openCategoryMenu(player, category, islandLevel, this.ignoreIslandRequirements);
                    continue;
                }
                this.openMainMenu(player);
            }
        };
        if (Bukkit.isPrimaryThread()) {
            refreshTask.run();
        } else {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, refreshTask);
        }
    }

    private void openCategory(Player player, ShopMenuLayout.Category category) {
        int islandLevel = this.resolvePlayerIslandLevel(player);
        this.inventoryComposer.openCategoryMenu(player, category, islandLevel, this.ignoreIslandRequirements);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory topInventory = event.getView().getTopInventory();
        InventoryHolder inventoryHolder = topInventory.getHolder();
        if (!(inventoryHolder instanceof AbstractShopMenuHolder)) {
            return;
        }
        AbstractShopMenuHolder holder = (AbstractShopMenuHolder)inventoryHolder;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!holder.owner().equals(player.getUniqueId())) {
            return;
        }
        if (event.getClickedInventory() == null || event.getClickedInventory().getHolder() != holder) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (holder instanceof MainShopMenuHolder) {
            String categoryId = (String)container.get(this.categoryKey, PersistentDataType.STRING);
            if (categoryId != null) {
                this.handleCategoryClick((Player)event.getWhoClicked(), categoryId);
            }
            return;
        }
        if (holder instanceof QuantityShopMenuHolder) {
            QuantityShopMenuHolder quantityHolder = (QuantityShopMenuHolder)holder;
            this.handleQuantityMenuClick(player, quantityHolder, container);
            return;
        }
        if (holder instanceof FlatShopMenuHolder) {
            FlatShopMenuHolder flatHolder = (FlatShopMenuHolder)holder;
            this.handleFlatMenuClick(player, event, flatHolder, container);
            return;
        }
        if (!(holder instanceof CategoryShopMenuHolder)) {
            return;
        }
        CategoryShopMenuHolder categoryHolder = (CategoryShopMenuHolder)holder;
        String action = (String)container.get(this.actionKey, PersistentDataType.STRING);
        if ("back".equalsIgnoreCase(action)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.openMainMenu((Player)event.getWhoClicked()));
            return;
        }
        String itemId = (String)container.get(this.itemKey, PersistentDataType.STRING);
        if (itemId == null) {
            return;
        }
        ShopMenuLayout.Item item = categoryHolder.findItem(itemId);
        if (item == null) {
            ((Player)event.getWhoClicked()).sendMessage(this.guiMessages.common().entryUnavailable());
            return;
        }
        this.handleItemClick(player, categoryHolder.category(), item, event.getClick());
    }

    private void handleFlatMenuClick(Player player, InventoryClickEvent event, FlatShopMenuHolder holder, PersistentDataContainer container) {
        String action = (String)container.get(this.actionKey, PersistentDataType.STRING);
        if ("previous".equalsIgnoreCase(action)) {
            if (holder.hasPreviousPage()) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.inventoryComposer.populateFlatMenu(holder, holder.page() - 1, this.resolvePlayerIslandLevel(player), this.ignoreIslandRequirements));
            }
            return;
        }
        if ("next".equalsIgnoreCase(action)) {
            if (holder.hasNextPage()) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.inventoryComposer.populateFlatMenu(holder, holder.page() + 1, this.resolvePlayerIslandLevel(player), this.ignoreIslandRequirements));
            }
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= holder.getInventory().getSize()) {
            return;
        }
        FlatShopMenuHolder.FlatMenuEntry entry = holder.entryForSlot(slot);
        if (entry == null) {
            return;
        }
        this.handleItemClick(player, entry.category(), entry.item(), event.getClick());
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        PendingTransaction pending = (PendingTransaction)this.pendingCustomInputs.get(playerId);
        if (pending == null) {
            return;
        }
        event.setCancelled(true);
        this.pendingCustomInputs.remove(playerId);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleCustomTransactionInput(event.getPlayer(), pending, event.getMessage()));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.pendingCustomInputs.remove(event.getPlayer().getUniqueId());
    }

    private void handleCategoryClick(Player player, String categoryId) {
        ShopMenuLayout layout = this.pricingManager.getMenuLayout();
        for (ShopMenuLayout.Category category : layout.categories()) {
            if (!category.id().equalsIgnoreCase(categoryId)) continue;
            if (category.command() != null && !category.command().isEmpty()) {
                String commandToRun = category.command().replace("{player}", player.getName());
                player.closeInventory();
                this.plugin.getServer().dispatchCommand((CommandSender)player, commandToRun);
            } else {
                this.openCategory(player, category);
            }
            return;
        }
        player.sendMessage(this.guiMessages.common().categoryUnavailable());
    }

    private void handleQuantityMenuClick(Player player, QuantityShopMenuHolder holder, PersistentDataContainer container) {
        String action = (String)container.get(this.actionKey, PersistentDataType.STRING);
        if ("back".equalsIgnoreCase(action)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.openCategory(player, holder.category()));
            return;
        }
        if ("custom".equalsIgnoreCase(action)) {
            this.startCustomInput(player, holder);
            return;
        }
        Integer quantity = (Integer)container.get(this.quantityKey, PersistentDataType.INTEGER);
        if (quantity == null) {
            return;
        }
        this.processTransaction(player, holder, quantity);
    }

    private void handleItemClick(Player player, ShopMenuLayout.Category category, ShopMenuLayout.Item item, ClickType click) {
        boolean isSellClick;
        int playerIslandLevel = this.resolvePlayerIslandLevel(player);
        if (!this.hasRequiredIslandLevel(playerIslandLevel, item)) {
            int required = Math.max(1, item.requiredIslandLevel());
            player.sendMessage(this.guiMessages.common().islandLevelRequired(required));
            return;
        }
        boolean isBuyClick = click == ClickType.LEFT || click == ClickType.SHIFT_LEFT;
        boolean bl = isSellClick = click == ClickType.RIGHT || click == ClickType.SHIFT_RIGHT;
        if (!isBuyClick && !isSellClick) {
            return;
        }
        if (isBuyClick) {
            if (!item.price().canBuy()) {
                player.sendMessage(this.guiMessages.common().itemCannotBePurchased());
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.openQuantityMenu(player, category, item, ShopTransactionType.BUY));
            return;
        }
        if (item.type() != ShopMenuLayout.ItemType.MATERIAL || !item.price().canSell()) {
            player.sendMessage(this.guiMessages.common().itemCannotBeSold());
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.openQuantityMenu(player, category, item, ShopTransactionType.SELL));
    }

    private void openQuantityMenu(Player player, ShopMenuLayout.Category category, ShopMenuLayout.Item item, ShopTransactionType type) {
        if (player == null || category == null || item == null) {
            return;
        }
        int playerIslandLevel = this.resolvePlayerIslandLevel(player);
        this.openQuantityMenu(player, category, item, type, playerIslandLevel);
    }

    private void openQuantityMenu(Player player, ShopMenuLayout.Category category, ShopMenuLayout.Item item, ShopTransactionType type, int playerIslandLevel) {
        if (player == null || category == null || item == null) {
            return;
        }
        if (!this.hasRequiredIslandLevel(playerIslandLevel, item)) {
            int required = Math.max(1, item.requiredIslandLevel());
            player.sendMessage(this.guiMessages.common().islandLevelRequired(required));
            return;
        }
        if (!(type != ShopTransactionType.SELL || item.type() == ShopMenuLayout.ItemType.MATERIAL && item.price().canSell())) {
            player.sendMessage(this.guiMessages.common().itemCannotBeSold());
            return;
        }
        this.inventoryComposer.openQuantityMenu(player, category, item, type, playerIslandLevel, this.ignoreIslandRequirements);
    }

    private void startCustomInput(Player player, QuantityShopMenuHolder holder) {
        if (player == null || holder == null) {
            return;
        }
        this.pendingCustomInputs.put(player.getUniqueId(), new PendingTransaction(holder.category(), holder.item(), holder.type()));
        player.closeInventory();
        player.sendMessage(this.guiMessages.customInput().prompt(holder.type()));
    }

    private void handleCustomTransactionInput(Player player, PendingTransaction pending, String message) {
        int amount;
        String trimmed;
        if (player == null || pending == null) {
            return;
        }
        String string = trimmed = message == null ? "" : message.trim();
        if (trimmed.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.guiMessages.customInput().cancelled());
            this.openQuantityMenu(player, pending.category(), pending.item(), pending.type());
            return;
        }
        try {
            amount = Integer.parseInt(trimmed);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(this.guiMessages.customInput().invalidNumber());
            this.openQuantityMenu(player, pending.category(), pending.item(), pending.type());
            return;
        }
        if (amount <= 0) {
            player.sendMessage(this.guiMessages.customInput().amountPositive());
            this.openQuantityMenu(player, pending.category(), pending.item(), pending.type());
            return;
        }
        ShopTransactionResult result = this.processTransaction(player, new QuantityShopMenuHolder(player.getUniqueId(), pending.category(), pending.item(), pending.type()), amount);
        if (result == null || !result.success()) {
            this.openQuantityMenu(player, pending.category(), pending.item(), pending.type());
        }
    }

    private ShopMenuLayout.Category findCategoryById(ShopMenuLayout layout, String categoryId) {
        if (layout == null || categoryId == null) {
            return null;
        }
        for (ShopMenuLayout.Category category : layout.categories()) {
            if (!category.id().equalsIgnoreCase(categoryId)) continue;
            return category;
        }
        return null;
    }

    private ShopMenuLayout.Item findItemById(ShopMenuLayout.Category category, String itemId) {
        if (category == null || itemId == null) {
            return null;
        }
        for (ShopMenuLayout.Item item : category.items()) {
            if (!item.id().equalsIgnoreCase(itemId)) continue;
            return item;
        }
        return null;
    }

    private ShopTransactionResult processTransaction(Player player, QuantityShopMenuHolder holder, int amount) {
        if (holder == null || amount <= 0) {
            return null;
        }
        ShopMenuLayout.Item item = holder.item();
        int normalized = this.normalizeQuantity(item, holder.type(), amount);
        ShopTransactionResult result = this.executeTransaction(player, item, holder.type(), normalized);
        if (result == null) {
            return null;
        }
        if (result.message() != null && !result.message().isEmpty()) {
            player.sendMessage(result.message());
        }
        if (result.success()) {
            this.refreshQuantityMenu(player, holder);
        }
        return result;
    }

    private void refreshQuantityMenu(Player player, QuantityShopMenuHolder holder) {
        if (player == null || holder == null) {
            return;
        }
        ShopMenuLayout.Category category = holder.category();
        ShopMenuLayout.Item item = holder.item();
        if (category == null || item == null) {
            return;
        }
        int islandLevel = this.resolvePlayerIslandLevel(player);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.openQuantityMenu(player, category, item, holder.type(), islandLevel));
    }

    private int normalizeQuantity(ShopMenuLayout.Item item, ShopTransactionType type, int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (type == ShopTransactionType.SELL || item == null) {
            return amount;
        }
        return Math.max(1, amount);
    }

    private ShopTransactionResult executeTransaction(Player player, ShopMenuLayout.Item item, ShopTransactionType type, int amount) {
        if (item == null || player == null || amount <= 0) {
            return null;
        }
        if (type == ShopTransactionType.SELL) {
            if (item.type() != ShopMenuLayout.ItemType.MATERIAL) {
                return ShopTransactionResult.failure(this.guiMessages.common().itemCannotBeSold());
            }
            return this.transactionService.sell(player, item.material(), amount);
        }
        return switch (item.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ShopMenuLayout.ItemType.MATERIAL -> this.transactionService.buy(player, item.material(), amount);
            case ShopMenuLayout.ItemType.MINION_HEAD -> ShopTransactionResult.failure(this.restrictionMessages.minionHeadCrateOnly());
            case ShopMenuLayout.ItemType.MINION_CRATE_KEY -> this.transactionService.buyMinionCrateKey(player, item.price().buyPrice(), amount);
            case ShopMenuLayout.ItemType.VOTE_CRATE_KEY -> this.transactionService.buyVoteCrateKey(player, item.price().buyPrice(), amount);
            case ShopMenuLayout.ItemType.SPAWNER -> this.transactionService.buySpawner(player, item.spawnerEntity(), item.price().buyPrice(), amount);
            case ShopMenuLayout.ItemType.ENCHANTED_BOOK -> this.transactionService.buyEnchantedBook(player, item, amount);
        };
    }

    private int resolvePlayerIslandLevel(Player player) {
        if (player == null) {
            return 0;
        }
        try {
            return Math.max(0, this.islandLevelProvider.getIslandLevel(player));
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Unable to determine island level for " + player.getName() + ": " + ex.getMessage());
            return 0;
        }
    }

    private boolean hasRequiredIslandLevel(int playerIslandLevel, ShopMenuLayout.Item item) {
        if (item == null) {
            return true;
        }
        if (this.ignoreIslandRequirements) {
            return true;
        }
        int required = Math.max(0, item.requiredIslandLevel());
        if (required <= 0) {
            return true;
        }
        return playerIslandLevel >= required;
    }

    public static enum DisplayMode {
        CATEGORIES,
        FLAT_LIST;

    }

    private record PendingTransaction(ShopMenuLayout.Category category, ShopMenuLayout.Item item, ShopTransactionType type) {
    }
}

