/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class StockMarketManager {
    private final Map<String, Double> prices = new HashMap<String, Double>();
    private final Random random = new Random();
    private static final double BASE_PRICE = 100.0;
    private static final double MAX_CHANGE = 0.1;
    private StockMarketFrozenStore frozenStore;

    public Set<String> getAllProductIds() {
        return this.prices.keySet();
    }

    public double getPrice(String productId) {
        return this.prices.getOrDefault(productId, 100.0);
    }

    public void setFrozenStore(StockMarketFrozenStore frozenStore) {
        this.frozenStore = frozenStore;
    }

    public void updatePrice(String productId, int demand) {
        if (this.frozenStore != null && this.frozenStore.isFrozen(productId)) {
            return;
        }
        double current = this.getPrice(productId);
        double change = (double)demand * 0.02 + (this.random.nextDouble() * 2.0 - 1.0) * 0.1;
        double newPrice = Math.max(1.0, current * (1.0 + change));
        this.prices.put(productId, newPrice);
    }

    public void setPrice(String productId, double price) {
        this.prices.put(productId, Math.max(1.0, price));
    }
}

