/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class StockMarketFrozenStore {
    private final File file;
    private final Map<String, FrozenMeta> frozen;

    public StockMarketFrozenStore(File dataFolder) {
        this.file = new File(dataFolder, "stock-frozen.yml");
        this.frozen = new HashMap<String, FrozenMeta>();
        this.load();
    }

    public synchronized void load() {
        this.frozen.clear();
        if (!this.file.exists()) {
            return;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.file);
        List list = yaml.getMapList("frozen");
        for (Map entry : list) {
            long when;
            String id = Objects.toString(entry.get("id"), null);
            String by = Objects.toString(entry.get("by"), "?");
            Object v = entry.get("when");
            if (v instanceof Number) {
                Number n = (Number)v;
                v0 = n.longValue();
            } else {
                v0 = when = 0L;
            }
            if (id == null) continue;
            this.frozen.put(id.toUpperCase(), new FrozenMeta(id, by, when));
        }
    }

    public synchronized void save() {
        YamlConfiguration yaml = new YamlConfiguration();
        ArrayList list = new ArrayList();
        for (FrozenMeta meta : this.frozen.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", meta.id);
            map.put("by", meta.by);
            map.put("when", meta.when);
            list.add(map);
        }
        yaml.set("frozen", list);
        try {
            yaml.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void freeze(String id, String by) {
        this.frozen.put(id.toUpperCase(), new FrozenMeta(id.toUpperCase(), by, System.currentTimeMillis()));
        this.save();
    }

    public synchronized void unfreeze(String id) {
        this.frozen.remove(id.toUpperCase());
        this.save();
    }

    public synchronized boolean isFrozen(String id) {
        return this.frozen.containsKey(id.toUpperCase());
    }

    public synchronized Collection<FrozenMeta> getAllFrozenMeta() {
        return Collections.unmodifiableCollection(this.frozen.values());
    }

    public synchronized Set<String> getAllFrozen() {
        return Collections.unmodifiableSet(new HashSet<String>(this.frozen.keySet()));
    }

    public static class FrozenMeta {
        public final String id;
        public final String by;
        public final long when;

        public FrozenMeta(String id, String by, long when) {
            this.id = id;
            this.by = by;
            this.when = when;
        }
    }
}

