/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class StockMarketConfig {
    private final Set<String> blocked = new HashSet<String>();
    private final Map<String, OverrideItem> overrides = new HashMap<String, OverrideItem>();

    public StockMarketConfig(FileConfiguration config) {
        ConfigurationSection stockSection = config.getConfigurationSection("stock");
        if (stockSection != null) {
            List overrideList;
            List blockedList = stockSection.getStringList("blocked");
            if (blockedList != null) {
                for (String s : blockedList) {
                    this.blocked.add(s.toUpperCase(Locale.ROOT));
                }
            }
            if ((overrideList = stockSection.getList("overrides")) != null) {
                for (Object obj : overrideList) {
                    Double basePrice;
                    if (!(obj instanceof Map)) continue;
                    Map map = (Map)obj;
                    String id = Objects.toString(map.get("id"), null);
                    String display = Objects.toString(map.get("display"), null);
                    Object v = map.get("base-price");
                    if (v instanceof Number) {
                        Number n = (Number)v;
                        v0 = n.doubleValue();
                    } else {
                        v0 = basePrice = null;
                    }
                    if (id == null || display == null || basePrice == null) continue;
                    this.overrides.put(id.toUpperCase(Locale.ROOT), new OverrideItem(id, display, basePrice));
                }
            }
        }
    }

    public boolean isBlocked(String id) {
        return this.blocked.contains(id.toUpperCase(Locale.ROOT));
    }

    public OverrideItem getOverride(String id) {
        return this.overrides.get(id.toUpperCase(Locale.ROOT));
    }

    public Collection<OverrideItem> getAllOverrides() {
        return this.overrides.values();
    }

    public static class OverrideItem {
        public final String id;
        public final String display;
        public final double basePrice;

        public OverrideItem(String id, String display, double basePrice) {
            this.id = id;
            this.display = display;
            this.basePrice = basePrice;
        }
    }
}

