/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.bootstrap.CoreShopComponent;
import com.skyblockexp.ezshops.stock.StockMarketConfig;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StockCommand
implements CommandExecutor {
    private final EzShopsPlugin plugin;
    private final StockMarketManager stockMarketManager;
    private final StockMarketConfig stockMarketConfig;
    private final StockMarketFrozenStore frozenStore;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final long cooldownMillis;

    public StockCommand(EzShopsPlugin plugin, StockMarketManager stockMarketManager, long cooldownMillis, StockMarketConfig stockMarketConfig, StockMarketFrozenStore frozenStore) {
        this.plugin = plugin;
        this.stockMarketManager = stockMarketManager;
        this.cooldownMillis = cooldownMillis;
        this.stockMarketConfig = stockMarketConfig;
        this.frozenStore = frozenStore;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock <buy|sell|overview> ...");
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("overview")) {
            if (!sender.hasPermission("ezshops.stock.overview")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view the stock market.");
                return true;
            }
            this.handleOverview(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can buy or sell stocks.");
            return true;
        }
        Player player = (Player)sender;
        if (sub.equals("buy") || sub.equals("sell")) {
            int amount;
            if (!player.hasPermission("ezshops.stock." + sub)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to " + sub + " stocks.");
                return true;
            }
            if (!this.checkCooldown(player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait before trading stocks again.");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock " + sub + " <item> <amount>");
                return true;
            }
            String item = args[1].toUpperCase(Locale.ROOT);
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount.");
                return true;
            }
            if (amount <= 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be positive.");
                return true;
            }
            if (this.stockMarketConfig.isBlocked(item)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item is blocked from stock trading.");
                return true;
            }
            if (this.frozenStore.isFrozen(item)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item is currently frozen and cannot be traded.");
                return true;
            }
            Material mat = Material.matchMaterial((String)item);
            if (mat == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown item: " + item);
                return true;
            }
            if (sub.equals("buy")) {
                this.stockMarketManager.updatePrice(mat.name(), amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought " + amount + " of " + mat.name() + " at " + this.stockMarketManager.getPrice(mat.name()) + " each.");
            } else {
                this.stockMarketManager.updatePrice(mat.name(), -amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sold " + amount + " of " + mat.name() + " at " + this.stockMarketManager.getPrice(mat.name()) + " each.");
            }
            this.setCooldown(player);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock <buy|sell|overview> ...");
        return true;
    }

    private void handleOverview(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Stock Market Overview ---");
        HashSet<String> shown = new HashSet<String>();
        for (StockMarketConfig.OverrideItem override : this.stockMarketConfig.getAllOverrides()) {
            double price = this.stockMarketManager.getPrice(override.id);
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + override.display + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.GREEN) + price);
            shown.add(override.id.toUpperCase(Locale.ROOT));
        }
        CoreShopComponent coreShop = this.plugin.getCoreShopComponent();
        if (coreShop != null && coreShop.pricingManager() != null) {
            for (Material mat : coreShop.pricingManager().getConfiguredMaterials()) {
                String id = mat.name();
                if (shown.contains(id) || this.stockMarketConfig.isBlocked(id)) continue;
                double price = this.stockMarketManager.getPrice(id);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + id + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.GREEN) + price);
                shown.add(id);
            }
        }
        for (String productId : this.stockMarketManager.getAllProductIds()) {
            if (shown.contains(productId.toUpperCase(Locale.ROOT)) || this.stockMarketConfig.isBlocked(productId) || this.stockMarketConfig.getOverride(productId) != null) continue;
            double price = this.stockMarketManager.getPrice(productId);
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + productId + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.GREEN) + price);
        }
    }

    private boolean checkCooldown(Player player) {
        if (this.cooldownMillis <= 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        Long last = this.cooldowns.get(player.getUniqueId());
        return last == null || now - last >= this.cooldownMillis;
    }

    private void setCooldown(Player player) {
        if (this.cooldownMillis > 0L) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }
}

