/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.bootstrap;

import com.skyblockexp.command.PriceCommand;
import com.skyblockexp.command.SellHandCommand;
import com.skyblockexp.command.SellInventoryCommand;
import com.skyblockexp.command.ShopCommand;
import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.gui.IslandLevelProvider;
import com.skyblockexp.gui.ShopMenu;
import com.skyblockexp.shop.DynamicPricingConfiguration;
import com.skyblockexp.shop.ShopPriceLookupService;
import com.skyblockexp.shop.ShopPricingManager;
import com.skyblockexp.shop.ShopRotationManager;
import com.skyblockexp.shop.ShopTransactionService;
import com.skyblockexp.shop.api.ShopPriceService;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;

public final class CoreShopComponent
implements PluginComponent {
    private final Economy economy;
    private EzShopsPlugin plugin;
    private ShopMessageConfiguration messageConfiguration;
    private ShopPricingManager pricingManager;
    private ShopTransactionService transactionService;
    private ShopMenu shopMenu;
    private ShopRotationManager rotationManager;
    private ShopCommand shopCommand;
    private SellHandCommand sellHandCommand;
    private SellInventoryCommand sellInventoryCommand;
    private PriceCommand priceCommand;
    private ShopPriceService shopPriceService;
    private IslandLevelProvider islandLevelProvider;
    private boolean ignoreIslandRequirements;

    public int getCategoryCount() {
        if (this.pricingManager == null || this.pricingManager.getMenuLayout() == null) {
            return 0;
        }
        return this.pricingManager.getMenuLayout().categories().size();
    }

    public CoreShopComponent(Economy economy) {
        this.economy = economy;
    }

    @Override
    public void enable(EzShopsPlugin plugin) {
        this.plugin = plugin;
        DynamicPricingConfiguration dynamicPricingConfiguration = DynamicPricingConfiguration.from((ConfigurationSection)plugin.getConfig(), plugin.getLogger());
        this.messageConfiguration = ShopMessageConfiguration.load(plugin);
        ShopMessageConfiguration.CommandMessages commandMessages = this.messageConfiguration.commands();
        ShopMessageConfiguration.TransactionMessages transactionMessages = this.messageConfiguration.transactions();
        ShopMessageConfiguration.GuiMessages guiMessages = this.messageConfiguration.gui();
        this.pricingManager = new ShopPricingManager(plugin, dynamicPricingConfiguration);
        this.transactionService = new ShopTransactionService(this.pricingManager, this.economy, transactionMessages);
        ServicesManager servicesManager = plugin.getServer().getServicesManager();
        this.shopPriceService = new ShopPriceLookupService(this.pricingManager, plugin.getLogger());
        servicesManager.register(ShopPriceService.class, (Object)this.shopPriceService, (Plugin)plugin, ServicePriority.Normal);
        this.islandLevelProvider = this.createIslandLevelProvider(plugin);
        boolean bl = this.ignoreIslandRequirements = this.islandLevelProvider == null;
        if (this.ignoreIslandRequirements) {
            plugin.getLogger().info("No island level provider detected; island-level shop requirements will be ignored until one is available.");
        }
        boolean categoriesEnabled = plugin.getConfig().getBoolean("categories.enabled", true);
        boolean singleListWhenDisabled = plugin.getConfig().getBoolean("categories.single-list-when-disabled", false);
        if (categoriesEnabled) {
            this.shopMenu = new ShopMenu(plugin, this.pricingManager, this.transactionService, this.islandLevelProvider, this.ignoreIslandRequirements, ShopMenu.DisplayMode.CATEGORIES, guiMessages, transactionMessages.restrictions());
        } else if (singleListWhenDisabled) {
            this.shopMenu = new ShopMenu(plugin, this.pricingManager, this.transactionService, this.islandLevelProvider, this.ignoreIslandRequirements, ShopMenu.DisplayMode.FLAT_LIST, guiMessages, transactionMessages.restrictions());
            plugin.getLogger().info("Shop categories are disabled; displaying all items in a single list.");
        } else {
            this.shopMenu = null;
            plugin.getLogger().info("Shop categories are disabled; the /shop menu will be unavailable.");
        }
        this.rotationManager = new ShopRotationManager(plugin, this.pricingManager, this.shopMenu);
        this.rotationManager.enable();
        this.shopCommand = new ShopCommand(this.pricingManager, this.transactionService, this.shopMenu, commandMessages.shop(), transactionMessages.errors(), transactionMessages.restrictions());
        this.sellHandCommand = new SellHandCommand(this.transactionService, commandMessages.sellHand());
        this.sellInventoryCommand = new SellInventoryCommand(this.transactionService, commandMessages.sellInventory());
        this.priceCommand = new PriceCommand(this.pricingManager, this.transactionService, commandMessages.price());
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        this.registerListener(pluginManager, this.shopMenu);
        this.registerCommand("shop", this.shopCommand);
        this.registerCommand("sellhand", this.sellHandCommand);
        this.registerCommand("sellinventory", this.sellInventoryCommand);
        this.registerCommand("price", this.priceCommand);
    }

    @Override
    public void disable() {
        if (this.rotationManager != null) {
            this.rotationManager.disable();
            this.rotationManager = null;
        }
        this.unregisterListener(this.shopMenu);
        if (this.plugin != null) {
            ServicesManager servicesManager = this.plugin.getServer().getServicesManager();
            if (this.shopPriceService != null) {
                servicesManager.unregister(ShopPriceService.class, (Object)this.shopPriceService);
                this.shopPriceService = null;
            }
        } else {
            this.shopPriceService = null;
        }
        this.shopCommand = null;
        this.sellHandCommand = null;
        this.sellInventoryCommand = null;
        this.priceCommand = null;
        this.shopMenu = null;
        this.transactionService = null;
        this.pricingManager = null;
        this.messageConfiguration = null;
        this.islandLevelProvider = null;
        this.ignoreIslandRequirements = false;
        this.plugin = null;
    }

    public ShopPricingManager pricingManager() {
        return this.pricingManager;
    }

    public ShopTransactionService transactionService() {
        return this.transactionService;
    }

    public ShopMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public IslandLevelProvider islandLevelProvider() {
        return this.islandLevelProvider;
    }

    public boolean ignoreIslandRequirements() {
        return this.ignoreIslandRequirements;
    }

    private void registerListener(PluginManager pluginManager, Listener listener) {
        if (listener != null) {
            pluginManager.registerEvents(listener, (Plugin)this.plugin);
        }
    }

    private void unregisterListener(Listener listener) {
        if (listener != null) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    private void registerCommand(String name, CommandExecutor executor) {
        if (executor == null) {
            return;
        }
        PluginCommand command = this.plugin.getCommand(name);
        if (command == null) {
            this.plugin.getLogger().severe("Plugin command '" + name + "' is not defined in plugin.yml. EzShops will be unusable.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            throw new IllegalStateException("Missing required command '" + name + "'.");
        }
        command.setExecutor(executor);
        if (executor instanceof TabCompleter) {
            TabCompleter tabCompleter = (TabCompleter)executor;
            command.setTabCompleter(tabCompleter);
        }
    }

    private IslandLevelProvider createIslandLevelProvider(EzShopsPlugin plugin) {
        Plugin skyblock = plugin.getServer().getPluginManager().getPlugin("SkyblockExperience");
        if (skyblock != null) {
            try {
                return new SkyblockIslandLevelProvider(skyblock);
            }
            catch (ReflectiveOperationException ex) {
                plugin.getLogger().warning("Failed to initialize Skyblock island level integration: " + ex.getMessage());
            }
        }
        return null;
    }

    private static final class SkyblockIslandLevelProvider
    implements IslandLevelProvider {
        private final Plugin skyblockPlugin;
        private final Method getIslandManagerMethod;
        private final Method getDefaultIslandMethod;
        private final Method levelMethod;

        private SkyblockIslandLevelProvider(Plugin skyblockPlugin) throws ReflectiveOperationException {
            this.skyblockPlugin = skyblockPlugin;
            Class pluginClass = skyblockPlugin.getClass();
            this.getIslandManagerMethod = pluginClass.getMethod("getIslandManager", new Class[0]);
            ClassLoader loader = skyblockPlugin.getClass().getClassLoader();
            Class<?> islandManagerClass = Class.forName("com.skyblockexp.island.IslandManager", true, loader);
            this.getDefaultIslandMethod = islandManagerClass.getMethod("getDefaultIsland", UUID.class);
            Class<?> islandDataClass = Class.forName("com.skyblockexp.island.IslandManager$IslandData", true, loader);
            this.levelMethod = islandDataClass.getMethod("level", new Class[0]);
        }

        @Override
        public int getIslandLevel(Player player) {
            try {
                Object islandManager = this.getIslandManagerMethod.invoke((Object)this.skyblockPlugin, new Object[0]);
                if (islandManager == null) {
                    return 0;
                }
                Object optional = this.getDefaultIslandMethod.invoke(islandManager, player.getUniqueId());
                if (optional instanceof Optional) {
                    Object islandData;
                    Object level;
                    Optional islandOptional = (Optional)optional;
                    if (islandOptional.isPresent() && (level = this.levelMethod.invoke(islandData = islandOptional.get(), new Object[0])) instanceof Number) {
                        Number number = (Number)level;
                        return number.intValue();
                    }
                    return 0;
                }
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
            return 0;
        }
    }
}

