/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops;

import com.skyblockexp.ezshops.bootstrap.CoreShopComponent;
import com.skyblockexp.ezshops.bootstrap.MetricsComponent;
import com.skyblockexp.ezshops.bootstrap.PluginComponent;
import com.skyblockexp.ezshops.bootstrap.SignShopComponent;
import com.skyblockexp.ezshops.stock.StockAdminCommand;
import com.skyblockexp.ezshops.stock.StockCommand;
import com.skyblockexp.ezshops.stock.StockMarketConfig;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManagerHolder;
import com.skyblockexp.ezshops.update.SpigotUpdateChecker;
import com.skyblockexp.playershop.bootstrap.PlayerShopComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzShopsPlugin
extends JavaPlugin {
    private static final int SPIGOT_RESOURCE_ID = 129780;
    private StockMarketConfig stockMarketConfig;
    private StockMarketFrozenStore stockMarketFrozenStore;
    private Economy economy;
    private List<PluginComponent> components;
    private CoreShopComponent coreShopComponent;
    private static final List<String> DEFAULT_SHOP_RESOURCES = List.of("shop.yml", "shop/menu.yml", "shop/categories/building.yml", "shop/categories/daily_specials.yml", "shop/categories/decorations.yml", "shop/categories/enchantments.yml", "shop/categories/farming.yml", "shop/categories/fishing.yml", "shop/categories/food.yml", "shop/categories/mining.yml", "shop/categories/mob_drops.yml", "shop/categories/redstone.yml", "shop/categories/spawners.yml", "shop/categories/valuables.yml", "shop/categories/wood.yml", "shop/rotations/daily-specials.yml", "messages/messages_en.yml", "messages/messages_es.yml", "messages/messages_nl.yml", "messages/messages_zh.yml");

    public void onEnable() {
        this.stockMarketConfig = new StockMarketConfig(this.getConfig());
        this.stockMarketFrozenStore = new StockMarketFrozenStore(this.getDataFolder());
        long stockCooldownMillis = this.getConfig().getLong("stock.cooldown-millis", 10000L);
        this.getCommand("stock").setExecutor((CommandExecutor)new StockCommand(this, StockMarketManagerHolder.get(), stockCooldownMillis, this.stockMarketConfig, this.stockMarketFrozenStore));
        this.getCommand("stockadmin").setExecutor((CommandExecutor)new StockAdminCommand(StockMarketManagerHolder.get(), this.stockMarketFrozenStore, this.stockMarketConfig));
        StockMarketManagerHolder.get().setFrozenStore(this.stockMarketFrozenStore);
        this.getLogger().info("Enabling EzShops...");
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault economy provider not found; disabling EzShops.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Vault economy provider detected: " + (this.economy != null ? this.economy.getName() : "Unknown"));
        this.saveDefaultResources();
        this.saveDefaultConfig();
        int missingFiles = 0;
        for (String string : DEFAULT_SHOP_RESOURCES) {
            File file = new File(this.getDataFolder(), string.replace('/', File.separatorChar));
            if (file.exists()) continue;
            this.getLogger().warning("Missing config/resource: " + string);
            ++missingFiles;
        }
        if (missingFiles == 0) {
            this.getLogger().info("All default config and resource files present.");
        } else {
            this.getLogger().warning(missingFiles + " config/resource files missing. Please check your setup.");
        }
        this.coreShopComponent = new CoreShopComponent(this.economy);
        PlayerShopComponent playerShopComponent = new PlayerShopComponent(this.economy, this.getConfig());
        this.components = new ArrayList<PluginComponent>();
        this.components.add(this.coreShopComponent);
        this.components.add(playerShopComponent);
        this.components.add(new SignShopComponent(this.coreShopComponent));
        this.components.add(new MetricsComponent());
        this.getLogger().info("[EzShops] Initializing components: " + this.components.size());
        try {
            for (PluginComponent component : this.components) {
                this.getLogger().info("[EzShops] Enabling component: " + component.getClass().getSimpleName());
                component.enable(this);
            }
        }
        catch (RuntimeException runtimeException) {
            this.getLogger().log(Level.SEVERE, "Failed to enable EzShops component", runtimeException);
            throw runtimeException;
        }
        int n = this.coreShopComponent.getCategoryCount();
        this.getLogger().info("Loaded shop categories: " + n);
        new SpigotUpdateChecker(this, 129780).checkForUpdates();
        this.getLogger().info("EzShops plugin enabled successfully.");
    }

    public void onDisable() {
        if (this.components != null) {
            ListIterator<PluginComponent> iterator = this.components.listIterator(this.components.size());
            while (iterator.hasPrevious()) {
                PluginComponent component = iterator.previous();
                try {
                    component.disable();
                }
                catch (RuntimeException ex) {
                    this.getLogger().log(Level.SEVERE, "Failed to disable EzShops component " + component.getClass().getSimpleName(), ex);
                }
            }
            this.components = null;
        }
        this.economy = null;
        this.getLogger().info("EzShops plugin disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            return false;
        }
        this.economy = (Economy)registration.getProvider();
        return this.economy != null;
    }

    private void saveDefaultResources() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.getLogger().warning("Unable to create plugin data folder for default EzShops configuration.");
            return;
        }
        for (String resourcePath : DEFAULT_SHOP_RESOURCES) {
            this.saveResourceIfAbsent(resourcePath);
        }
    }

    private void saveResourceIfAbsent(String resourcePath) {
        File destination = new File(this.getDataFolder(), resourcePath.replace('/', File.separatorChar));
        if (destination.exists()) {
            return;
        }
        File parent = destination.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            this.getLogger().warning("Unable to create directory for default resource: " + parent.getAbsolutePath());
            return;
        }
        try {
            this.saveResource(resourcePath, false);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warning("Missing packaged resource '" + resourcePath + "': " + ex.getMessage());
        }
    }

    public CoreShopComponent getCoreShopComponent() {
        return this.coreShopComponent;
    }
}

