/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.command;

import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.shop.ShopTransactionResult;
import com.skyblockexp.shop.ShopTransactionService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SellHandCommand
implements CommandExecutor {
    private final ShopTransactionService transactionService;
    private final ShopMessageConfiguration.CommandMessages.SellHandCommandMessages messages;

    public SellHandCommand(ShopTransactionService transactionService, ShopMessageConfiguration.CommandMessages.SellHandCommandMessages messages) {
        this.transactionService = transactionService;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.playersOnly());
            return true;
        }
        Player player = (Player)sender;
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType() == Material.AIR || handItem.getAmount() <= 0) {
            player.sendMessage(this.messages.mustHoldItem());
            return true;
        }
        ShopTransactionResult result = this.transactionService.sell(player, handItem.getType(), handItem.getAmount());
        player.sendMessage(result.message());
        return true;
    }
}

