/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.island.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;

public interface GeneratorUpgradeService {
    public int getMaxLevel();

    public GeneratorUpgradeLevel getLevel(int var1);

    public GeneratorUpgradeLevel getNextLevel(int var1);

    public Material chooseMaterial(int var1);

    public Material chooseMaterial(int var1, double var2);

    public static final class WeightedMaterial {
        private final Material material;
        private final double weight;

        public WeightedMaterial(Material material, double weight) {
            this.material = Objects.requireNonNull(material, "material");
            this.weight = weight;
        }

        public Material material() {
            return this.material;
        }

        public double weight() {
            return this.weight;
        }

        public String toString() {
            return this.material.name().toLowerCase(Locale.ROOT) + ":" + this.weight;
        }
    }

    public static final class GeneratorUpgradeLevel {
        private final int level;
        private final double cost;
        private final List<WeightedMaterial> materials;

        public GeneratorUpgradeLevel(int level, double cost, List<WeightedMaterial> materials) {
            this.level = Math.max(1, level);
            this.cost = Math.max(0.0, cost);
            this.materials = Collections.unmodifiableList(new ArrayList<WeightedMaterial>(materials));
        }

        public int level() {
            return this.level;
        }

        public double cost() {
            return this.cost;
        }

        public List<WeightedMaterial> materials() {
            return this.materials;
        }

        public double totalWeight() {
            return this.materials.stream().mapToDouble(WeightedMaterial::weight).sum();
        }

        public double weightFor(Material material) {
            if (material == null) {
                return Double.MAX_VALUE;
            }
            return this.materials.stream().filter(entry -> entry.material() == material).mapToDouble(WeightedMaterial::weight).findFirst().orElse(Double.MAX_VALUE);
        }

        public Material choose(Random random, Material fallback) {
            Objects.requireNonNull(random, "random");
            if (this.materials.isEmpty()) {
                return fallback == null ? Material.COBBLESTONE : fallback;
            }
            double total = this.totalWeight();
            if (total <= 0.0) {
                return fallback == null ? Material.COBBLESTONE : fallback;
            }
            double target = random.nextDouble(total);
            double cumulative = 0.0;
            for (WeightedMaterial material : this.materials) {
                if (!(target <= (cumulative += material.weight()))) continue;
                return material.material();
            }
            return this.materials.get(this.materials.size() - 1).material();
        }
    }
}

