/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators.upgrade;

import com.skyblockexp.island.upgrade.GeneratorUpgradeService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractGeneratorUpgradeService
implements GeneratorUpgradeService {
    private final JavaPlugin plugin;
    private final List<GeneratorUpgradeService.GeneratorUpgradeLevel> levels;
    private final Random random = new Random();

    protected AbstractGeneratorUpgradeService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.levels = Collections.unmodifiableList(this.loadLevelsFromFile());
    }

    @Override
    public int getMaxLevel() {
        return this.levels.isEmpty() ? 0 : this.levels.size();
    }

    @Override
    public GeneratorUpgradeService.GeneratorUpgradeLevel getLevel(int level) {
        if (this.levels.isEmpty()) {
            return this.defaultFallbackLevel();
        }
        int index = Math.max(1, Math.min(level, this.levels.size())) - 1;
        return this.levels.get(index);
    }

    @Override
    public GeneratorUpgradeService.GeneratorUpgradeLevel getNextLevel(int level) {
        if (this.levels.isEmpty() || level >= this.levels.size()) {
            return null;
        }
        return this.levels.get(Math.max(0, level));
    }

    @Override
    public Material chooseMaterial(int level) {
        return this.chooseMaterial(level, 1.0);
    }

    @Override
    public Material chooseMaterial(int level, double qualityMultiplier) {
        GeneratorUpgradeService.GeneratorUpgradeLevel generatorLevel = this.getLevel(level);
        if (qualityMultiplier <= 1.0) {
            return generatorLevel.choose(this.random, this.getFallbackMaterial());
        }
        double sanitizedMultiplier = Double.isNaN(qualityMultiplier) || Double.isInfinite(qualityMultiplier) ? 1.0 : Math.max(1.0, qualityMultiplier);
        int guaranteedRolls = Math.max(1, (int)Math.floor(sanitizedMultiplier));
        double fractional = sanitizedMultiplier - (double)guaranteedRolls;
        int attempts = guaranteedRolls;
        if (fractional > 1.0E-6 && this.random.nextDouble() < fractional) {
            ++attempts;
        }
        Material chosen = generatorLevel.choose(this.random, this.getFallbackMaterial());
        double chosenWeight = generatorLevel.weightFor(chosen);
        for (int index = 1; index < attempts; ++index) {
            Material candidate = generatorLevel.choose(this.random, this.getFallbackMaterial());
            double candidateWeight = generatorLevel.weightFor(candidate);
            if (!(candidateWeight < chosenWeight)) continue;
            chosen = candidate;
            chosenWeight = candidateWeight;
        }
        return chosen;
    }

    protected abstract String getConfigPath();

    protected abstract String getUpgradeDisplayName();

    protected abstract Material getFallbackMaterial();

    protected abstract List<GeneratorUpgradeService.GeneratorUpgradeLevel> createDefaultLevels();

    protected final GeneratorUpgradeService.GeneratorUpgradeLevel createLevel(int level, double cost, Material fallback, Object ... entries) {
        List<GeneratorUpgradeService.WeightedMaterial> materials = this.buildWeightedMaterials(entries);
        if (materials.isEmpty()) {
            materials.add(new GeneratorUpgradeService.WeightedMaterial(fallback, 1.0));
        }
        return new GeneratorUpgradeService.GeneratorUpgradeLevel(level, cost, materials);
    }

    protected final List<GeneratorUpgradeService.WeightedMaterial> buildWeightedMaterials(Object ... entries) {
        ArrayList<GeneratorUpgradeService.WeightedMaterial> materials = new ArrayList<GeneratorUpgradeService.WeightedMaterial>();
        if (entries == null) {
            return materials;
        }
        int index = 0;
        while (index + 1 < entries.length) {
            Object nameEntry = entries[index];
            Object weightEntry = entries[index + 1];
            if (nameEntry instanceof String) {
                Material material;
                double weight;
                if (weightEntry instanceof Number) {
                    Number number = (Number)weightEntry;
                    v0 = number.doubleValue();
                } else {
                    v0 = weight = 0.0;
                }
                if (!(weight <= 0.0) && (material = Material.matchMaterial((String)((String)nameEntry))) != null) {
                    materials.add(new GeneratorUpgradeService.WeightedMaterial(material, weight));
                }
            }
            index += 2;
        }
        return materials;
    }

    protected final Material resolveMaterial(String name, Material fallback) {
        Material resolved = Material.matchMaterial((String)name);
        return resolved != null ? resolved : fallback;
    }

    private List<GeneratorUpgradeService.GeneratorUpgradeLevel> loadLevelsFromFile() {
        ArrayList<GeneratorUpgradeService.GeneratorUpgradeLevel> parsed = new ArrayList<GeneratorUpgradeService.GeneratorUpgradeLevel>();
        String fileName = this.getConfigFileName();
        File file = new File(this.plugin.getDataFolder(), "../resources/" + fileName);
        if (!file.exists()) {
            file = new File(this.plugin.getDataFolder().getParentFile(), "resources/" + fileName);
        }
        if (!file.exists()) {
            file = new File(this.plugin.getDataFolder(), fileName);
        }
        if (!file.exists()) {
            this.getLogger().warning("Could not find " + fileName + " for " + this.getUpgradeDisplayName() + ". Using defaults.");
            parsed.addAll(this.createDefaultLevels());
            return parsed;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        List rawLevels = config.getList("levels");
        if (rawLevels != null) {
            for (int index = 0; index < rawLevels.size(); ++index) {
                List<GeneratorUpgradeService.WeightedMaterial> materials;
                double cost;
                Object raw = rawLevels.get(index);
                if (raw instanceof Map) {
                    Map map = (Map)raw;
                    cost = this.parseCost(map.get("cost"), index);
                    materials = this.parseMaterials(map.get("blocks"), index);
                    if (!materials.isEmpty()) {
                        parsed.add(new GeneratorUpgradeService.GeneratorUpgradeLevel(parsed.size() + 1, cost, materials));
                        continue;
                    }
                    this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (index + 1) + " does not define any valid blocks.");
                    continue;
                }
                if (raw instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)raw;
                    cost = section.getDouble("cost", 0.0);
                    materials = this.parseMaterials(section.get("blocks"), index);
                    if (!materials.isEmpty()) {
                        parsed.add(new GeneratorUpgradeService.GeneratorUpgradeLevel(parsed.size() + 1, Math.max(0.0, cost), materials));
                        continue;
                    }
                    this.getLogger().warning(this.capitalizeUpgradeName() + " level " + section.getName() + " does not define any valid blocks.");
                    continue;
                }
                this.getLogger().warning(this.capitalizeUpgradeName() + " level entry at index " + index + " must be a map.");
            }
        }
        if (parsed.isEmpty()) {
            this.getLogger().warning("No " + this.getUpgradeDisplayName() + " levels configured. Falling back to defaults.");
            parsed.addAll(this.createDefaultLevels());
        }
        return parsed;
    }

    protected abstract String getConfigFileName();

    private GeneratorUpgradeService.GeneratorUpgradeLevel defaultFallbackLevel() {
        return new GeneratorUpgradeService.GeneratorUpgradeLevel(1, 0.0, List.of(new GeneratorUpgradeService.WeightedMaterial(this.getFallbackMaterial(), 1.0)));
    }

    private double parseCost(Object value, int index) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return Math.max(0.0, number.doubleValue());
        }
        if (value != null) {
            try {
                return Math.max(0.0, Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException ex) {
                this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (index + 1) + " has an invalid cost value: " + String.valueOf(value));
            }
        }
        return 0.0;
    }

    private List<GeneratorUpgradeService.WeightedMaterial> parseMaterials(Object rawBlocks, int index) {
        ArrayList<GeneratorUpgradeService.WeightedMaterial> materials = new ArrayList<GeneratorUpgradeService.WeightedMaterial>();
        if (rawBlocks instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)rawBlocks;
            for (String key : section.getKeys(false)) {
                Object raw = section.get(key);
                this.parseMaterialEntry(materials, index, key, raw);
            }
            return materials;
        }
        if (rawBlocks instanceof Map) {
            Map map = (Map)rawBlocks;
            for (Map.Entry entry : map.entrySet()) {
                String key = Objects.toString(entry.getKey(), "");
                this.parseMaterialEntry(materials, index, key, entry.getValue());
            }
            return materials;
        }
        if (rawBlocks != null) {
            this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (index + 1) + " defines blocks in an unsupported format.");
        }
        return materials;
    }

    private void parseMaterialEntry(List<GeneratorUpgradeService.WeightedMaterial> materials, int levelIndex, String key, Object rawValue) {
        Material material = Material.matchMaterial((String)key);
        if (material == null) {
            this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (levelIndex + 1) + " references unknown material '" + key + "'.");
            return;
        }
        double weight = this.parseWeight(rawValue, levelIndex, material);
        if (weight <= 0.0) {
            this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (levelIndex + 1) + " material '" + key + "' must have a positive weight.");
            return;
        }
        materials.add(new GeneratorUpgradeService.WeightedMaterial(material, weight));
    }

    private double parseWeight(Object value, int levelIndex, Material material) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value != null) {
            try {
                return Double.parseDouble(value.toString());
            }
            catch (NumberFormatException ex) {
                this.getLogger().warning(this.capitalizeUpgradeName() + " level " + (levelIndex + 1) + " material '" + material.name().toLowerCase(Locale.ROOT) + "' has invalid weight " + String.valueOf(value));
            }
        }
        return 0.0;
    }

    private Logger getLogger() {
        return this.plugin.getLogger();
    }

    private String capitalizeUpgradeName() {
        String name = this.getUpgradeDisplayName();
        if (name == null || name.isBlank()) {
            return "Generator upgrade";
        }
        String trimmed = name.trim();
        return Character.toUpperCase(trimmed.charAt(0)) + trimmed.substring(1);
    }
}

