/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators.listener;

import com.skyblockexp.island.upgrade.BasaltGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.CobbleGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.ObsidianGeneratorUpgradeService;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class CobbleGeneratorListener
implements Listener {
    private final CobbleGeneratorUpgradeService cobbleUpgradeService;
    private final BasaltGeneratorUpgradeService basaltUpgradeService;
    private final ObsidianGeneratorUpgradeService obsidianUpgradeService;
    private final boolean debugEnabled;

    public CobbleGeneratorListener(CobbleGeneratorUpgradeService cobbleUpgradeService, BasaltGeneratorUpgradeService basaltUpgradeService, ObsidianGeneratorUpgradeService obsidianUpgradeService, FileConfiguration config) {
        this.cobbleUpgradeService = cobbleUpgradeService;
        this.basaltUpgradeService = basaltUpgradeService;
        this.obsidianUpgradeService = obsidianUpgradeService;
        this.debugEnabled = config.getBoolean("debug", false);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        Block block;
        boolean hasIslandSupport;
        Object island;
        Object specializationManager;
        block52: {
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] BlockFormEvent fired: block=" + String.valueOf(event.getBlock()) + ", newType=" + String.valueOf(event.getNewState().getType()) + ", cancelled=" + event.isCancelled());
            }
            Object skyblock = this.resolveSkyblock();
            Object islandManager = null;
            specializationManager = null;
            island = null;
            hasIslandSupport = false;
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] resolveSkyblock() returned: " + (skyblock != null ? skyblock.getClass().getName() : "null"));
            }
            if (skyblock != null) {
                try {
                    Method getIslandManager = skyblock.getClass().getMethod("getIslandManager", new Class[0]);
                    islandManager = getIslandManager.invoke(skyblock, new Object[0]);
                    Method getSpecializationManager = skyblock.getClass().getMethod("getSpecializationManager", new Class[0]);
                    specializationManager = getSpecializationManager.invoke(skyblock, new Object[0]);
                    if (this.debugEnabled) {
                        Bukkit.getLogger().info("[EzGenerators] Resolved managers: islandManager=" + (islandManager != null) + ", specializationManager=" + (specializationManager != null));
                    }
                }
                catch (Exception e) {
                    if (this.debugEnabled) {
                        Bukkit.getLogger().warning("[EzGenerators] Failed to resolve Skyblock managers: " + e.getMessage());
                    }
                    islandManager = null;
                }
            }
            block = event.getBlock();
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] Block world: " + block.getWorld().getName() + ", block location: " + String.valueOf(block.getLocation()));
            }
            if (islandManager != null) {
                try {
                    Method isIslandWorld = islandManager.getClass().getMethod("isIslandWorld", World.class);
                    boolean isIsland = (Boolean)isIslandWorld.invoke(islandManager, block.getWorld());
                    if (!isIsland) break block52;
                    Method getIslandAt = islandManager.getClass().getMethod("getIslandAt", Location.class);
                    island = getIslandAt.invoke(islandManager, block.getLocation());
                    boolean bl = hasIslandSupport = island != null;
                    if (this.debugEnabled) {
                        Bukkit.getLogger().info("[EzGenerators] Island support: " + hasIslandSupport + ", island=" + String.valueOf(island != null ? island : "none"));
                    }
                    break block52;
                }
                catch (Exception e) {
                    if (this.debugEnabled) {
                        Bukkit.getLogger().warning("[EzGenerators] Reflection error in islandManager: " + e.getMessage());
                    }
                    break block52;
                }
            }
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] No island support for world: " + block.getWorld().getName());
            }
        }
        Material newType = event.getNewState().getType();
        Material basalt = Material.matchMaterial((String)"BASALT");
        if (this.debugEnabled) {
            Bukkit.getLogger().info("[EzGenerators] Deciding replacement for newType=" + String.valueOf(newType) + ", isCobbleOrStone=" + this.isCobbleOrStone(newType));
        }
        if (this.isCobbleOrStone(newType)) {
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] Handling cobble/stone block at " + String.valueOf(block.getLocation()));
            }
            if (hasIslandSupport && island != null) {
                double multiplier;
                int level;
                block53: {
                    level = 1;
                    multiplier = 1.0;
                    try {
                        Method getGeneratorLevel = island.getClass().getMethod("generatorLevel", new Class[0]);
                        Object lvlObj = getGeneratorLevel.invoke(island, new Object[0]);
                        if (lvlObj instanceof Integer) {
                            level = (Integer)lvlObj;
                        }
                        multiplier = this.resolveMultiplierReflect(island, specializationManager, "COBBLESTONE");
                    }
                    catch (Exception e) {
                        if (!this.debugEnabled) break block53;
                        Bukkit.getLogger().warning("[EzGenerators] Reflection error getting generatorLevel: " + e.getMessage());
                    }
                }
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] IslandData: generatorLevel=" + level + ", multiplier=" + multiplier);
                }
                Material replacement = this.cobbleUpgradeService.chooseMaterial(level, multiplier);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Island) Replacing " + String.valueOf(newType) + " with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (level=" + level + ", multiplier=" + multiplier + ")");
                }
                event.getNewState().setType(replacement);
            } else {
                int level = this.getHighestNearbyGeneratorLevel(event.getBlock(), "COBBLESTONE");
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] No island, using highest nearby generator level: " + level);
                }
                Material replacement = this.cobbleUpgradeService.chooseMaterial(level, 1.0);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Nearby) Replacing " + String.valueOf(newType) + " with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (highestLevel=" + level + ")");
                }
                event.getNewState().setType(replacement);
            }
        } else if (basalt != null && newType == basalt && this.basaltUpgradeService != null) {
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] Handling BASALT block at " + String.valueOf(block.getLocation()));
            }
            if (hasIslandSupport && island != null) {
                double multiplier;
                int level;
                block54: {
                    level = 1;
                    multiplier = 1.0;
                    try {
                        Method getBasaltGeneratorLevel = island.getClass().getMethod("basaltGeneratorLevel", new Class[0]);
                        Object lvlObj = getBasaltGeneratorLevel.invoke(island, new Object[0]);
                        if (lvlObj instanceof Integer) {
                            level = (Integer)lvlObj;
                        }
                        multiplier = this.resolveMultiplierReflect(island, specializationManager, "BASALT");
                    }
                    catch (Exception e) {
                        if (!this.debugEnabled) break block54;
                        Bukkit.getLogger().warning("[EzGenerators] Reflection error getting basaltGeneratorLevel: " + e.getMessage());
                    }
                }
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] IslandData: basaltGeneratorLevel=" + level + ", multiplier=" + multiplier);
                }
                Material replacement = this.basaltUpgradeService.chooseMaterial(level, multiplier);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Island) Replacing BASALT with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (level=" + level + ", multiplier=" + multiplier + ")");
                }
                event.getNewState().setType(replacement);
            } else {
                int level = this.getHighestNearbyGeneratorLevel(event.getBlock(), "BASALT");
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] No island, using highest nearby basalt generator level: " + level);
                }
                Material replacement = this.basaltUpgradeService.chooseMaterial(level, 1.0);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Nearby) Replacing BASALT with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (highestLevel=" + level + ")");
                }
                event.getNewState().setType(replacement);
            }
        } else if (newType == Material.OBSIDIAN && this.obsidianUpgradeService != null) {
            if (this.debugEnabled) {
                Bukkit.getLogger().info("[EzGenerators] Handling OBSIDIAN block at " + String.valueOf(block.getLocation()));
            }
            if (hasIslandSupport && island != null) {
                double multiplier;
                int level;
                block55: {
                    level = 1;
                    multiplier = 1.0;
                    try {
                        Method getObsidianGeneratorLevel = island.getClass().getMethod("obsidianGeneratorLevel", new Class[0]);
                        Object lvlObj = getObsidianGeneratorLevel.invoke(island, new Object[0]);
                        if (lvlObj instanceof Integer) {
                            level = (Integer)lvlObj;
                        }
                        multiplier = this.resolveMultiplierReflect(island, specializationManager, "OBSIDIAN");
                    }
                    catch (Exception e) {
                        if (!this.debugEnabled) break block55;
                        Bukkit.getLogger().warning("[EzGenerators] Reflection error getting obsidianGeneratorLevel: " + e.getMessage());
                    }
                }
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] IslandData: obsidianGeneratorLevel=" + level + ", multiplier=" + multiplier);
                }
                Material replacement = this.obsidianUpgradeService.chooseMaterial(level, multiplier);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Island) Replacing OBSIDIAN with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (level=" + level + ", multiplier=" + multiplier + ")");
                }
                event.getNewState().setType(replacement);
            } else {
                int level = this.getHighestNearbyGeneratorLevel(event.getBlock(), "OBSIDIAN");
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] No island, using highest nearby obsidian generator level: " + level);
                }
                Material replacement = this.obsidianUpgradeService.chooseMaterial(level, 1.0);
                if (this.debugEnabled) {
                    Bukkit.getLogger().info("[EzGenerators] (Nearby) Replacing OBSIDIAN with " + String.valueOf(replacement) + " at " + String.valueOf(block.getLocation()) + " (highestLevel=" + level + ")");
                }
                event.getNewState().setType(replacement);
            }
        } else if (this.debugEnabled) {
            Bukkit.getLogger().info("[EzGenerators] No replacement logic for newType=" + String.valueOf(newType));
        }
    }

    private int getHighestNearbyGeneratorLevel(Block block, String type) {
        int radius = 5;
        int yRadius = 2;
        int highest = 1;
        HashMap<Player, Integer> levelCache = new HashMap<Player, Integer>();
        for (Entity entity : block.getWorld().getNearbyEntities(block.getLocation(), (double)radius, (double)yRadius, (double)radius)) {
            int level;
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            Integer cached = (Integer)levelCache.get(player);
            if (cached != null) {
                level = cached;
            } else {
                String metaKey;
                level = 1;
                switch (type) {
                    case "COBBLESTONE": {
                        String string = "cobblegen_level";
                        break;
                    }
                    case "BASALT": {
                        String string = "basaltgen_level";
                        break;
                    }
                    case "OBSIDIAN": {
                        String string = "obsidiangen_level";
                        break;
                    }
                    default: {
                        String string = metaKey = null;
                    }
                }
                if (metaKey != null && player.hasMetadata(metaKey)) {
                    level = ((MetadataValue)player.getMetadata(metaKey).get(0)).asInt();
                }
                levelCache.put(player, level);
            }
            if (level <= highest) continue;
            highest = level;
        }
        return highest;
    }

    private double resolveMultiplierReflect(Object island, Object specializationManager, String type) {
        if (specializationManager == null || island == null) {
            return 1.0;
        }
        try {
            Method getMultiplier = specializationManager.getClass().getMethod("getGeneratorRerollMultiplier", island.getClass(), String.class);
            Object result = getMultiplier.invoke(specializationManager, island, type);
            if (result instanceof Double) {
                Double d = (Double)result;
                return d <= 0.0 ? 1.0 : d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0;
    }

    private Object resolveSkyblock() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("SkyblockExperience");
        if (plugin == null || !plugin.isEnabled()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("com.skyblockexp.SkyblockExperiencePlugin");
            if (clazz.isInstance(plugin)) {
                return plugin;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private boolean isCobbleOrStone(Material material) {
        return material == Material.COBBLESTONE || material == Material.STONE;
    }
}

