/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators.command;

import com.skyblockexp.ezgenerators.command.PlayerGeneratorData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerGeneratorDataFile
implements PlayerGeneratorData {
    private final File file;
    private final YamlConfiguration config;
    private final Map<UUID, Map<String, Integer>> cache = new HashMap<UUID, Map<String, Integer>>();

    public PlayerGeneratorDataFile(File dataFile) {
        this.file = dataFile;
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadAll();
    }

    private void loadAll() {
        for (String uuidStr : this.config.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(uuidStr);
            }
            catch (Exception e) {
                continue;
            }
            HashMap<String, Integer> levels = new HashMap<String, Integer>();
            for (String type : this.config.getConfigurationSection(uuidStr).getKeys(false)) {
                int lvl = this.config.getInt(uuidStr + "." + type, 1);
                levels.put(type, lvl);
            }
            this.cache.put(uuid, levels);
        }
    }

    @Override
    public int getLevel(UUID uuid, String type) {
        return this.cache.getOrDefault(uuid, Map.of()).getOrDefault(type, 1);
    }

    @Override
    public void setLevel(UUID uuid, String type, int level) {
        this.cache.computeIfAbsent(uuid, k -> new HashMap()).put(type, level);
        this.config.set(uuid.toString() + "." + type, (Object)level);
        this.save();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reload() {
        this.cache.clear();
        try {
            this.config.load(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadAll();
    }
}

