/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators.command;

import com.skyblockexp.ezgenerators.command.PlayerGeneratorData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class MySQLGeneratorData
implements PlayerGeneratorData {
    private final String url;
    private final String user;
    private final String pass;
    private final String table;

    public MySQLGeneratorData(String host, int port, String database, String user, String pass, String table) {
        this.url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&autoReconnect=true";
        this.user = user;
        this.pass = pass;
        this.table = table;
        this.createTableIfNotExists();
    }

    private void createTableIfNotExists() {
        try (Connection conn = DriverManager.getConnection(this.url, this.user, this.pass);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.table + " (uuid VARCHAR(36) NOT NULL,type VARCHAR(16) NOT NULL,level INT NOT NULL,PRIMARY KEY (uuid, type))");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLevel(UUID uuid, String type) {
        try (Connection conn = DriverManager.getConnection(this.url, this.user, this.pass);
             PreparedStatement ps = conn.prepareStatement("SELECT level FROM " + this.table + " WHERE uuid=? AND type=?");){
            ps.setString(1, uuid.toString());
            ps.setString(2, type);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 1;
                int n = rs.getInt("level");
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public void setLevel(UUID uuid, String type, int level) {
        CompletableFuture.runAsync(() -> {
            try (Connection conn = DriverManager.getConnection(this.url, this.user, this.pass);
                 PreparedStatement ps = conn.prepareStatement("REPLACE INTO " + this.table + " (uuid, type, level) VALUES (?, ?, ?)");){
                ps.setString(1, uuid.toString());
                ps.setString(2, type);
                ps.setInt(3, level);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }
}

