/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators.command;

import com.skyblockexp.ezgenerators.EzGeneratorsPlugin;
import com.skyblockexp.ezgenerators.command.PlayerGeneratorData;
import com.skyblockexp.island.upgrade.BasaltGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.CobbleGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.GeneratorUpgradeService;
import com.skyblockexp.island.upgrade.ObsidianGeneratorUpgradeService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GeneratorCommand
implements CommandExecutor,
Listener {
    private final NamespacedKey menuKey;
    private final NamespacedKey typeKey;
    private final EzGeneratorsPlugin plugin;
    private final CobbleGeneratorUpgradeService cobbleService;
    private final BasaltGeneratorUpgradeService basaltService;
    private final ObsidianGeneratorUpgradeService obsidianService;
    private final PlayerGeneratorData playerData;

    private void updatePlayerGeneratorMetadata(Player player) {
        player.setMetadata("cobblegen_level", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this.playerData.getLevel(player.getUniqueId(), "cobble")));
        player.setMetadata("basaltgen_level", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this.playerData.getLevel(player.getUniqueId(), "basalt")));
        player.setMetadata("obsidiangen_level", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this.playerData.getLevel(player.getUniqueId(), "obsidian")));
    }

    private Economy getEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return null;
        }
        try {
            return this.plugin.getServer().getServicesManager().getRegistration(Economy.class) != null ? (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public GeneratorCommand(EzGeneratorsPlugin plugin, CobbleGeneratorUpgradeService cobbleService, BasaltGeneratorUpgradeService basaltService, ObsidianGeneratorUpgradeService obsidianService) {
        this.plugin = plugin;
        this.cobbleService = cobbleService;
        this.basaltService = basaltService;
        this.obsidianService = obsidianService;
        this.menuKey = new NamespacedKey((Plugin)plugin, "generator_menu");
        this.typeKey = new NamespacedKey((Plugin)plugin, "generator_type");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.playerData = plugin.getPlayerGeneratorData();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("debugmeta")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
                return true;
            }
            Player player = (Player)sender;
            this.updatePlayerGeneratorMetadata(player);
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Player Metadata ---");
            List metaList = player.getMetadata("cobblegen_level");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "cobblegen_level: " + (metaList.isEmpty() ? "<none>" : ((MetadataValue)metaList.get(0)).asString()));
            for (String key : new String[]{"cobblegen_level", "basaltgen_level", "obsidiangen_level"}) {
                List metas = player.getMetadata(key);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + key + ": " + (metas.isEmpty() ? "<none>" : ((MetadataValue)metas.get(0)).asString()));
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "----------------------");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ezgenerators.command.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload EzGenerators.");
                return true;
            }
            this.plugin.reloadAllConfigs();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All EzGenerators config files reloaded.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0 && args[0].equalsIgnoreCase("levels")) {
            this.showLevelsInfo(player, args.length > 1 ? args[1] : null);
            return true;
        }
        this.openMainMenu(player);
        return true;
    }

    private void showLevelsInfo(Player player, String typeArg) {
        int maxLevel;
        String type;
        Function<Integer, Map> getChances = switch (type = typeArg != null ? typeArg.toLowerCase() : "cobble") {
            case "basalt" -> {
                maxLevel = Math.max(1, this.basaltService.getMaxLevel());
                yield lvl -> this.toChanceMap(this.basaltService.getLevel((int)lvl));
            }
            case "obsidian" -> {
                maxLevel = Math.max(1, this.obsidianService.getMaxLevel());
                yield lvl -> this.toChanceMap(this.obsidianService.getLevel((int)lvl));
            }
            default -> {
                maxLevel = Math.max(1, this.cobbleService.getMaxLevel());
                yield lvl -> this.toChanceMap(this.cobbleService.getLevel((int)lvl));
            }
        };
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- " + type.substring(0, 1).toUpperCase() + type.substring(1) + " Generator Levels ---");
        for (int level = 1; level <= maxLevel; ++level) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Level " + level + ":");
            Map chances = getChances.apply(level);
            if (chances == null || chances.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "  (No block chances configured)");
                continue;
            }
            for (Map.Entry entry : chances.entrySet()) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + ((Material)entry.getKey()).name() + String.valueOf(ChatColor.WHITE) + ": " + String.format("%.2f%%", (Double)entry.getValue() * 100.0));
            }
        }
    }

    private Map<Material, Double> toChanceMap(GeneratorUpgradeService.GeneratorUpgradeLevel level) {
        List<GeneratorUpgradeService.WeightedMaterial> mats = level.materials();
        double total = level.totalWeight();
        LinkedHashMap<Material, Double> map = new LinkedHashMap<Material, Double>();
        if (total <= 0.0) {
            return map;
        }
        for (GeneratorUpgradeService.WeightedMaterial wm : mats) {
            map.put(wm.material(), wm.weight() / total);
        }
        return map;
    }

    private void openMainMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Generator Upgrades"));
        ItemStack cobble = new ItemStack(Material.COBBLESTONE);
        ItemMeta cobbleMeta = cobble.getItemMeta();
        if (cobbleMeta != null) {
            cobbleMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Cobblestone Generator");
            cobbleMeta.getPersistentDataContainer().set(this.menuKey, PersistentDataType.STRING, (Object)"main");
            cobbleMeta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)"cobble");
            cobble.setItemMeta(cobbleMeta);
        }
        inv.setItem(11, cobble);
        ItemStack basalt = new ItemStack(Material.BASALT);
        ItemMeta basaltMeta = basalt.getItemMeta();
        if (basaltMeta != null) {
            basaltMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Basalt Generator");
            basaltMeta.getPersistentDataContainer().set(this.menuKey, PersistentDataType.STRING, (Object)"main");
            basaltMeta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)"basalt");
            basalt.setItemMeta(basaltMeta);
        }
        inv.setItem(13, basalt);
        ItemStack obsidian = new ItemStack(Material.OBSIDIAN);
        ItemMeta obsidianMeta = obsidian.getItemMeta();
        if (obsidianMeta != null) {
            obsidianMeta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "Obsidian Generator");
            obsidianMeta.getPersistentDataContainer().set(this.menuKey, PersistentDataType.STRING, (Object)"main");
            obsidianMeta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)"obsidian");
            obsidian.setItemMeta(obsidianMeta);
        }
        inv.setItem(15, obsidian);
        player.openInventory(inv);
    }

    private void openLevelMenu(Player player, String type) {
        Material icon;
        int maxLevel;
        String title = switch (type) {
            case "basalt" -> {
                maxLevel = Math.max(1, this.basaltService.getMaxLevel());
                icon = Material.BASALT;
                yield String.valueOf(ChatColor.AQUA) + "Basalt Generator Levels";
            }
            case "obsidian" -> {
                maxLevel = Math.max(1, this.obsidianService.getMaxLevel());
                icon = Material.OBSIDIAN;
                yield String.valueOf(ChatColor.LIGHT_PURPLE) + "Obsidian Generator Levels";
            }
            default -> {
                maxLevel = Math.max(1, this.cobbleService.getMaxLevel());
                icon = Material.COBBLESTONE;
                yield String.valueOf(ChatColor.YELLOW) + "Cobble Generator Levels";
            }
        };
        int currentLevel = this.playerData.getLevel(player.getUniqueId(), type);
        int rows = Math.min(6, Math.max(1, (int)Math.ceil((double)(maxLevel + 1) / 9.0)));
        Inventory inv = Bukkit.createInventory(null, (int)(rows * 9), (String)title);
        Economy econ = this.getEconomy();
        for (int level = 1; level <= maxLevel; ++level) {
            ItemStack item = new ItemStack(icon);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                String costString;
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Level " + String.valueOf(ChatColor.YELLOW) + level);
                double cost = 0.0;
                switch (type) {
                    case "basalt": {
                        cost = this.basaltService.getLevel(level).cost();
                        break;
                    }
                    case "obsidian": {
                        cost = this.obsidianService.getLevel(level).cost();
                        break;
                    }
                    default: {
                        cost = this.cobbleService.getLevel(level).cost();
                    }
                }
                String string = costString = econ != null ? econ.format(cost) : String.format("%.2f", cost);
                if (level == currentLevel) {
                    meta.setLore(List.of(String.valueOf(ChatColor.GREEN) + "Current Level", String.valueOf(ChatColor.GRAY) + "Cost: " + costString));
                } else if (level < currentLevel) {
                    meta.setLore(List.of(String.valueOf(ChatColor.AQUA) + "Unlocked", String.valueOf(ChatColor.GRAY) + "Cost: " + costString));
                } else if (level == currentLevel + 1) {
                    meta.setLore(List.of(String.valueOf(ChatColor.YELLOW) + "Click to upgrade!", String.valueOf(ChatColor.GRAY) + "Cost: " + costString));
                } else {
                    meta.setLore(List.of(String.valueOf(ChatColor.DARK_GRAY) + "Locked", String.valueOf(ChatColor.GRAY) + "Cost: " + costString));
                }
                meta.getPersistentDataContainer().set(this.menuKey, PersistentDataType.STRING, (Object)"level");
                meta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)type);
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "level"), PersistentDataType.INTEGER, (Object)level);
                item.setItemMeta(meta);
            }
            inv.addItem(new ItemStack[]{item});
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(String.valueOf(ChatColor.GRAY) + "Back");
            backMeta.getPersistentDataContainer().set(this.menuKey, PersistentDataType.STRING, (Object)"back");
            backMeta.getPersistentDataContainer().set(this.typeKey, PersistentDataType.STRING, (Object)type);
            back.setItemMeta(backMeta);
        }
        inv.setItem(rows * 9 - 1, back);
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack item = event.getCurrentItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(this.menuKey, PersistentDataType.STRING)) {
            return;
        }
        String menu = (String)container.get(this.menuKey, PersistentDataType.STRING);
        event.setCancelled(true);
        if (menu == null) {
            return;
        }
        if (menu.equals("main")) {
            String type = (String)container.get(this.typeKey, PersistentDataType.STRING);
            if (type != null) {
                this.openLevelMenu(player, type);
            }
        } else if (menu.equals("back")) {
            this.openMainMenu(player);
        } else if (menu.equals("level")) {
            String type = (String)container.get(this.typeKey, PersistentDataType.STRING);
            Integer level = (Integer)container.get(new NamespacedKey((Plugin)this.plugin, "level"), PersistentDataType.INTEGER);
            if (type == null || level == null) {
                return;
            }
            int currentLevel = this.playerData.getLevel(player.getUniqueId(), type);
            if (level <= currentLevel) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You already have this level or higher.");
                return;
            }
            if (level != currentLevel + 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must upgrade to the next level in order.");
                return;
            }
            double cost = 0.0;
            switch (type) {
                case "basalt": {
                    cost = this.basaltService.getLevel(level).cost();
                    break;
                }
                case "obsidian": {
                    cost = this.obsidianService.getLevel(level).cost();
                    break;
                }
                default: {
                    cost = this.cobbleService.getLevel(level).cost();
                }
            }
            Economy econ = this.getEconomy();
            if (econ != null) {
                if (!econ.has((OfflinePlayer)player, cost)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You need " + econ.format(cost) + " to upgrade.");
                    return;
                }
                if (!econ.withdrawPlayer((OfflinePlayer)player, cost).transactionSuccess()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to withdraw funds.");
                    return;
                }
            } else if (cost > 0.0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Economy plugin not found. Cannot upgrade.");
                return;
            }
            this.playerData.setLevel(player.getUniqueId(), type, level);
            this.updatePlayerGeneratorMetadata(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Upgraded " + type + " generator to level " + String.valueOf(ChatColor.YELLOW) + level + String.valueOf(ChatColor.GREEN) + "!");
            this.openLevelMenu(player, type);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayerGeneratorMetadata(event.getPlayer());
    }
}

